/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.ui.nodes.editors;

import java.beans.FeatureDescriptor;
import java.beans.PropertyEditorSupport;
import java.util.StringTokenizer;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaEnum;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.common.ui.nodes.elements.ElementNode;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.NbBundle;

public final class TypeEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    public static final String[] LVALUE_TYPES = new String[]{"boolean", "int", "char", "byte", "short", "long", "float", "double", "Object", "String"};
    public static final String[] RVALUE_TYPES = new String[]{"void", "boolean", "int", "char", "byte", "short", "long", "float", "double", "Object", "String"};
    public static final String[] ANNTYPE_VALUE_TYPES = new String[]{"boolean", "int", "char", "byte", "short", "long", "float", "double", "String", "String[]"};
    public static final String ANN_TYPE_EDITOR = "annTypeEditor";
    private boolean acceptsVoid;
    private boolean isAnnTypeEditor = false;
    private JavaModelPackage model;

    public String getAsText() {
        Object val = this.getValue();
        Type t = (Type)val;
        return t == null ? "" : JMIUtils.elementName((NamedElement)t);
    }

    public void setAsText(String text) throws IllegalArgumentException {
        Type type = this.model.getType().resolve(text);
        if (!TypeEditor.isValidTypeSyntax(text)) {
            TypeEditor.throwUserWarning("MSG_InvalidTypeDecl");
        }
        if (this.isAnnTypeEditor) {
            if (!TypeEditor.isValidTypeOfAnnTypeMethod(type)) {
                TypeEditor.throwUserWarning("MSG_InvalidTypeDecl");
            }
        } else if (!this.acceptsVoid && type instanceof PrimitiveType && PrimitiveTypeKindEnum.VOID.equals((Object)((PrimitiveType)type).getKind())) {
            TypeEditor.throwUserWarning("MSG_VoidTypeNotPermitted");
        }
        this.setValue(type);
    }

    private static void throwUserWarning(String key) throws IllegalArgumentException {
        IllegalArgumentException ex = new IllegalArgumentException(key);
        ErrorManager.getDefault().annotate((Throwable)ex, 256, null, TypeEditor.getString(key), null, null);
        throw ex;
    }

    public static boolean isValidTypeOfAnnTypeMethod(Type type) {
        Type t = type;
        while (t instanceof Array) {
            t = ((Array)t).getType();
        }
        if (t instanceof PrimitiveType) {
            return !PrimitiveTypeKindEnum.VOID.equals((Object)((PrimitiveType)t).getKind());
        }
        if (t instanceof JavaEnum || t instanceof AnnotationType || t instanceof UnresolvedClass) {
            return true;
        }
        if (t instanceof JavaClass) {
            String cname = t.getName();
            return cname.equals(String.class.getName()) || cname.equals(Class.class.getName());
        }
        throw new IllegalStateException("unknown type: " + type);
    }

    public static boolean isValidTypeSyntax(String type) {
        if (type.length() == 0 || type.charAt(0) == '<') {
            return false;
        }
        StringTokenizer tukac = new StringTokenizer(type, "<,>", true);
        int depth = 0;
        while (tukac.hasMoreTokens()) {
            String token = tukac.nextToken();
            if (depth <= 0 && ",".equals(token)) {
                return false;
            }
            if ("<".equals(token)) {
                ++depth;
                continue;
            }
            if (!">".equals(token)) continue;
            if (depth <= 0) {
                return false;
            }
            --depth;
        }
        return depth == 0;
    }

    public void setValue(Object v) {
        if (v != null && !(v instanceof Type)) {
            throw new IllegalArgumentException();
        }
        super.setValue(v);
    }

    public String getJavaInitializationString() {
        return this.getAsText();
    }

    public String[] getTags() {
        if (this.isAnnTypeEditor) {
            return ANNTYPE_VALUE_TYPES;
        }
        return this.acceptsVoid ? RVALUE_TYPES : LVALUE_TYPES;
    }

    public void attachEnv(PropertyEnv env) {
        FeatureDescriptor desc = env.getFeatureDescriptor();
        Object o = desc.getValue("acceptVoidType");
        this.acceptsVoid = o instanceof Boolean ? (Boolean)o : true;
        o = desc.getValue(ANN_TYPE_EDITOR);
        if (o instanceof Boolean) {
            this.isAnnTypeEditor = (Boolean)o;
        }
        desc.setValue("canEditAsText", Boolean.TRUE);
        this.model = ElementNode.getModel(desc);
    }

    private static String getString(String key) {
        return NbBundle.getMessage(TypeEditor.class, (String)key);
    }
}

