/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.ui.AbstractOutputTab;
import org.netbeans.core.output2.ui.CloseButtonTabbedPane;
import org.openide.windows.TopComponent;

public abstract class AbstractOutputWindow
extends TopComponent
implements ChangeListener,
PropertyChangeListener {
    protected JTabbedPane pane = new CloseButtonTabbedPane();
    private Runnable pendingFocusRunnable = null;
    private AbstractOutputTab lastKnownSelection = null;
    private final boolean isGtk = "GTK".equals(UIManager.getLookAndFeel().getID()) || UIManager.getLookAndFeel().getClass().getSuperclass().getName().indexOf("Synth") != -1;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AbstractOutputWindow() {
        this.pane.addChangeListener(this);
        this.pane.addPropertyChangeListener("close", this);
        this.setFocusable(true);
        this.setBackground(UIManager.getColor("text"));
    }

    public void propertyChange(PropertyChangeEvent pce) {
        if ("close".equals(pce.getPropertyName())) {
            AbstractOutputTab tab = (AbstractOutputTab)pce.getNewValue();
            this.closeRequest(tab);
        }
    }

    protected abstract void closeRequest(AbstractOutputTab var1);

    protected abstract void removed(AbstractOutputTab var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addImpl(Component c, Object constraints, int idx) {
        this.setFocusable(false);
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        boolean hadFocus = this.hasFocus() || this.isAncestorOf(focusOwner);
        Object object = this.getTreeLock();
        synchronized (object) {
            if (c instanceof AbstractOutputTab) {
                AbstractOutputTab aop = this.getInternalTab();
                if (aop != null) {
                    if (aop == c) {
                        return;
                    }
                    super.remove((Component)aop);
                    if (!$assertionsDisabled && this.pane.getParent() == this) {
                        throw new AssertionError();
                    }
                    this.pane.add(aop);
                    this.pane.add(c);
                    super.addImpl((Component)this.pane, constraints, idx);
                    this.updateSingletonName(null);
                    this.revalidate();
                } else if (this.pane.getParent() == this) {
                    this.pane.add(c);
                    this.revalidate();
                } else {
                    super.addImpl(c, constraints, idx);
                    this.revalidate();
                }
                if (hadFocus) {
                    this.requestFocus();
                }
                return;
            }
            super.addImpl(c, constraints, idx);
        }
        if (this.getComponentCount() == 1 && this.getComponent(0) instanceof AbstractOutputTab) {
            this.updateSingletonName(this.getComponent(0).getName());
        }
        this.revalidate();
    }

    public final AbstractOutputTab[] getTabs() {
        ArrayList<Component> al = new ArrayList<Component>(this.pane.getParent() == this ? this.pane.getTabCount() : this.getComponentCount());
        if (this.pane.getParent() == this) {
            int tabs = this.pane.getTabCount();
            for (int i = 0; i < tabs; ++i) {
                Component c = this.pane.getComponentAt(i);
                if (!(c instanceof AbstractOutputTab)) continue;
                al.add(c);
            }
        } else {
            Component[] c = this.getComponents();
            for (int i = 0; i < c.length; ++i) {
                if (!(c[i] instanceof AbstractOutputTab)) continue;
                al.add(c[i]);
            }
        }
        AbstractOutputTab[] result = new AbstractOutputTab[al.size()];
        result = al.toArray(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Component c) {
        AbstractOutputTab removedSelectedView = null;
        Object object = this.getTreeLock();
        synchronized (object) {
            if (c.getParent() == this.pane && c instanceof AbstractOutputTab) {
                if (c == this.pane.getSelectedComponent()) {
                    if (Controller.log) {
                        Controller.log("Selected view is being removed: " + c.getName());
                    }
                    removedSelectedView = (AbstractOutputTab)c;
                }
                this.checkWinXPLFBug();
                this.pane.remove(c);
                if (this.pane.getTabCount() == 1) {
                    Component comp = this.pane.getComponentAt(0);
                    this.pane.remove(comp);
                    super.remove((Component)this.pane);
                    this.add(comp);
                    this.updateSingletonName(c.getName());
                    this.revalidate();
                }
            } else {
                if (c == this.getSelectedTab()) {
                    removedSelectedView = (AbstractOutputTab)c;
                }
                super.remove(c);
                this.updateSingletonName(null);
            }
            if (removedSelectedView != null) {
                this.fire(removedSelectedView);
            }
        }
        if (c instanceof AbstractOutputTab && c.getParent() == null) {
            this.removed((AbstractOutputTab)c);
        }
        if (this.getComponentCount() == 1 && this.getComponent(0) instanceof AbstractOutputTab) {
            this.updateSingletonName(this.getComponent(0).getName());
        }
        this.revalidate();
        this.setFocusable(this.getComponentCount() == 0);
    }

    private AbstractOutputTab getInternalTab() {
        Component[] c = this.getComponents();
        for (int i = 0; i < c.length; ++i) {
            if (!(c[i] instanceof AbstractOutputTab)) continue;
            return (AbstractOutputTab)c[i];
        }
        return null;
    }

    public final AbstractOutputTab getSelectedTab() {
        if (this.pane.getParent() == this) {
            return (AbstractOutputTab)this.pane.getSelectedComponent();
        }
        return this.getInternalTab();
    }

    public void setSelectedTab(AbstractOutputTab op) {
        if (!$assertionsDisabled && op.getParent() != this && op.getParent() != this.pane) {
            throw new AssertionError();
        }
        if (Controller.log) {
            Controller.log("SetSelectedTab: " + op + " parent is " + op.getParent());
        }
        if (this.pane.getParent() == this && op != this.pane.getSelectedComponent()) {
            this.pane.setSelectedComponent(op);
        }
        this.getActionMap().setParent(op.getActionMap());
    }

    public void setTabTitle(AbstractOutputTab tab, String name) {
        if (tab.getParent() == this.pane) {
            this.pane.setTitleAt(this.pane.indexOfComponent(tab), name);
        } else if (tab.getParent() == this) {
            this.updateSingletonName(name);
        }
        tab.setName(name);
    }

    public void requestFocus() {
        if (!this.isShowing()) {
            return;
        }
        AbstractOutputTab tab = this.getSelectedTab();
        if (tab != null && this.pendingFocusRunnable == null) {
            this.pendingFocusRunnable = new Runnable(){

                public void run() {
                    AbstractOutputTab tab = AbstractOutputWindow.this.getSelectedTab();
                    if (tab != null) {
                        tab.requestFocus();
                    }
                    AbstractOutputWindow.this.pendingFocusRunnable = null;
                }
            };
            SwingUtilities.invokeLater(this.pendingFocusRunnable);
        } else {
            super.requestFocus();
        }
    }

    protected abstract void updateSingletonName(String var1);

    public void doLayout() {
        Insets ins = this.getInsets();
        Component c = null;
        if (this.pane.getParent() == this) {
            c = this.pane;
        } else if (this.getComponentCount() > 0) {
            c = this.getComponent(0);
        }
        if (c != null) {
            c.setBounds(ins.left, ins.top, this.getWidth() - (ins.left + ins.right), this.getHeight() - (ins.top + ins.bottom));
        }
    }

    protected void fire(AbstractOutputTab formerSelection) {
        AbstractOutputTab selection = this.getSelectedTab();
        if (formerSelection != selection) {
            this.selectionChanged(formerSelection, selection);
            this.lastKnownSelection = selection;
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.fire(this.lastKnownSelection);
    }

    protected abstract void selectionChanged(AbstractOutputTab var1, AbstractOutputTab var2);

    public void paint(Graphics g) {
        if (this.isGtk) {
            Color c = this.getBackground();
            if (c == null) {
                c = Color.WHITE;
            }
            g.setColor(c);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        super.paint(g);
    }

    public final void selectNextTab(AbstractOutputTab tab) {
        AbstractOutputTab[] tabs = this.getTabs();
        if (tabs.length > 1) {
            int nextTabIndex = this.getSelectedTabIndex(tabs, tab) + 1;
            if (nextTabIndex > tabs.length - 1) {
                nextTabIndex = 0;
            }
            this.setSelectedTab(tabs[nextTabIndex]);
        }
    }

    public final void selectPreviousTab(AbstractOutputTab tab) {
        AbstractOutputTab[] tabs = this.getTabs();
        if (tabs.length > 1) {
            int prevTabIndex = this.getSelectedTabIndex(tabs, tab) - 1;
            if (prevTabIndex < 0) {
                prevTabIndex = tabs.length - 1;
            }
            this.setSelectedTab(tabs[prevTabIndex]);
        }
    }

    private int getSelectedTabIndex(AbstractOutputTab[] tabs, AbstractOutputTab tab) {
        for (int i = 0; i < tabs.length; ++i) {
            if (tabs[i] != tab) continue;
            return i;
        }
        return -1;
    }

    private void checkWinXPLFBug() {
        if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
            TabbedPaneUI ui = this.pane.getUI();
            try {
                Method method = ui.getClass().getDeclaredMethod("setRolloverTab", Integer.TYPE);
                if (method != null) {
                    method.setAccessible(true);
                    method.invoke((Object)ui, new Integer(-1));
                    method.setAccessible(false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        $assertionsDisabled = !AbstractOutputWindow.class.desiredAssertionStatus();
    }
}

