/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.openide.awt.Actions;
import org.openide.awt.DynamicMenuContent;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;

class DynaMenuModel {
    private static final Icon BLANK_ICON = new ImageIcon(Utilities.loadImage((String)"org/openide/loaders/empty.gif"));
    private List menuItems;
    private HashMap actionToMenuMap = new HashMap();
    private boolean isWithIcons = false;

    public void loadSubmenu(List cInstances, JMenu m) {
        boolean addSeparator = false;
        Object curIcon = null;
        Iterator it = cInstances.iterator();
        this.menuItems = new ArrayList(cInstances.size());
        this.actionToMenuMap.clear();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof Presenter.Menu) {
                obj = ((Presenter.Menu)obj).getMenuPresenter();
            }
            if (obj instanceof DynamicMenuContent) {
                if (addSeparator) {
                    this.menuItems.add(null);
                    addSeparator = false;
                }
                DynamicMenuContent mn = (DynamicMenuContent)obj;
                JComponent[] itms = this.convertArray(mn.getMenuPresenters());
                this.actionToMenuMap.put(mn, itms);
                Iterator<JComponent> itx = Arrays.asList(itms).iterator();
                while (itx.hasNext()) {
                    JComponent comp = itx.next();
                    this.menuItems.add(comp);
                    this.isWithIcons = this.checkIcon(comp, this.isWithIcons);
                }
                continue;
            }
            if (obj instanceof JMenuItem) {
                if (addSeparator) {
                    this.menuItems.add(null);
                    addSeparator = false;
                }
                this.isWithIcons = this.checkIcon(obj, this.isWithIcons);
                this.menuItems.add((JMenuItem)obj);
                continue;
            }
            if (obj instanceof JSeparator) {
                addSeparator = this.menuItems.size() > 0;
                continue;
            }
            if (!(obj instanceof Action)) continue;
            if (addSeparator) {
                this.menuItems.add(null);
                addSeparator = false;
            }
            Action a = (Action)obj;
            Actions.MenuItem item = new Actions.MenuItem(a, true);
            this.isWithIcons = this.checkIcon(item, this.isWithIcons);
            this.actionToMenuMap.put(item, new JComponent[]{item});
            this.menuItems.add(item);
        }
        if (this.isWithIcons) {
            this.menuItems = this.alignVertically(this.menuItems);
        }
        JComponent curItem = null;
        boolean wasSeparator = false;
        Iterator iter = this.menuItems.iterator();
        while (iter.hasNext()) {
            curItem = (JComponent)iter.next();
            if (curItem != null) {
                m.add(curItem);
                wasSeparator = curItem instanceof JSeparator;
                continue;
            }
            if (wasSeparator) continue;
            m.addSeparator();
        }
    }

    private boolean checkIcon(Object obj, boolean isWithIconsAlready) {
        if (isWithIconsAlready) {
            return isWithIconsAlready;
        }
        return obj instanceof JMenuItem && ((JMenuItem)obj).getIcon() != null && !BLANK_ICON.equals(((JMenuItem)obj).getIcon());
    }

    public void checkSubmenu(JMenu menu) {
        Iterator it = this.actionToMenuMap.entrySet().iterator();
        boolean oldisWithIcons = this.isWithIcons;
        boolean changed = false;
        while (it.hasNext()) {
            int i;
            int menuIndex;
            Map.Entry entry = it.next();
            DynamicMenuContent pres = (DynamicMenuContent)entry.getKey();
            JComponent[] old = (JComponent[])entry.getValue();
            boolean oldIndex = false;
            Component[] menuones = menu.getPopupMenu().getComponents();
            int n = menuIndex = old.length > 0 ? this.findFirstItemIndex(old[0], menuones) : -1;
            JComponent[] newones = this.convertArray(pres.synchMenuPresenters(old));
            if (this.compareEqualArrays(old, newones)) continue;
            if (menuIndex < 0) {
                menuIndex = 0;
            } else {
                for (i = 0; i < old.length; ++i) {
                    if (old[i] == null) continue;
                    menu.getPopupMenu().remove(old[i]);
                    this.menuItems.remove(old[i]);
                }
            }
            for (i = 0; i < newones.length; ++i) {
                JComponent one = newones[i];
                menu.getPopupMenu().add((Component)one, i + menuIndex);
                changed = true;
                this.menuItems.add(one);
                boolean thisOneHasIcon = this.checkIcon(one, false);
                if (!thisOneHasIcon && this.isWithIcons) {
                    this.alignVertically(Collections.singletonList(one));
                }
                if (!thisOneHasIcon || this.isWithIcons) continue;
                this.isWithIcons = true;
            }
            entry.setValue(newones);
        }
        boolean hasAnyIcons = false;
        Component[] menuones = menu.getPopupMenu().getComponents();
        for (int i = 0; !(i >= menuones.length || menuones[i] != null && (hasAnyIcons = this.checkIcon(menuones[i], hasAnyIcons))); ++i) {
        }
        if (!hasAnyIcons && this.isWithIcons) {
            this.isWithIcons = false;
        }
        if (oldisWithIcons != this.isWithIcons) {
            this.menuItems = this.alignVertically(this.menuItems);
        }
        if (changed && Utilities.isWindows()) {
            menu.getPopupMenu().revalidate();
        }
    }

    private JComponent[] convertArray(JComponent[] arr) {
        if (arr == null || arr.length == 0) {
            return new JComponent[0];
        }
        JComponent[] toRet = new JComponent[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            toRet[i] = arr[i] == null ? new JSeparator() : arr[i];
        }
        return toRet;
    }

    private int findFirstItemIndex(JComponent first, Component[] menuItems) {
        for (int i = 0; i < menuItems.length; ++i) {
            if (first != menuItems[i]) continue;
            return i;
        }
        return -1;
    }

    private boolean compareEqualArrays(JComponent[] one, JComponent[] two) {
        if (one.length != two.length) {
            return false;
        }
        for (int i = 0; i < one.length; ++i) {
            if (one[i] == two[i]) continue;
            return false;
        }
        return true;
    }

    private List alignVertically(List menuItems) {
        ArrayList result = new ArrayList(menuItems.size());
        JMenuItem curItem = null;
        Iterator iter = menuItems.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof JMenuItem) {
                curItem = (JMenuItem)obj;
                if (this.isWithIcons && curItem != null && curItem.getIcon() == null) {
                    curItem.setIcon(BLANK_ICON);
                } else if (!this.isWithIcons && curItem != null) {
                    curItem.setIcon(null);
                }
            }
            result.add(obj);
        }
        return result;
    }
}

