/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.sunresources.beans;

import java.util.Vector;
import org.netbeans.modules.j2ee.sun.sunresources.beans.Field;
import org.netbeans.modules.j2ee.sun.sunresources.beans.FieldGroup;
import org.netbeans.modules.j2ee.sun.sunresources.beans.OptionValuePair;
import org.netbeans.modules.j2ee.sun.sunresources.beans.Wizard;

public class FieldHelper {
    public static String[] getFieldNames(Wizard wiz) {
        FieldGroup[] groups = wiz.getFieldGroup();
        Vector<String> vec = new Vector<String>();
        for (int i = 0; i < groups.length; ++i) {
            Field[] fields = groups[i].getField();
            for (int j = 0; j < fields.length; ++j) {
                vec.add(fields[j].getName());
            }
        }
        String[] result = new String[vec.size()];
        return vec.toArray(result);
    }

    public static Field getField(FieldGroup group, String fieldName) {
        Field[] fields = group.getField();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getName().equals(fieldName)) continue;
            return fields[i];
        }
        return null;
    }

    public static String getFieldType(Field fld) {
        return fld.getAttributeValue("field-type");
    }

    public static boolean isList(Field fld) {
        return fld.getAttributeValue("field-type").equals("list");
    }

    public static boolean isInt(Field fld) {
        return fld.getAttributeValue("field-type").equals("int");
    }

    public static boolean isTextArea(Field fld) {
        return fld.getAttributeValue("field-type").equals("textarea");
    }

    public static String[] getTags(Field fld) {
        return fld.getTag().getTagItem();
    }

    public static String getDefaultValue(Field fld) {
        return fld.getFieldValue().getDefaultFieldValue();
    }

    public static String getConditionalFieldValue(Field fld, String optionName) {
        OptionValuePair[] pairs = fld.getFieldValue().getOptionValuePair();
        for (int i = 0; i < pairs.length; ++i) {
            if (!pairs[i].getOptionName().equals(optionName)) continue;
            return pairs[i].getConditionalValue();
        }
        return fld.getFieldValue().getDefaultFieldValue();
    }

    public static String getOptionNameFromValue(Field urlField, String connUrl) {
        String vendorName = "";
        OptionValuePair[] options = urlField.getFieldValue().getOptionValuePair();
        for (int i = 0; i < options.length; ++i) {
            String condUrl = options[i].getConditionalValue();
            if (connUrl.indexOf(condUrl) == -1) continue;
            return options[i].getOptionName();
        }
        return vendorName;
    }

    public static String getReplacedConditionalFieldValue(Field fld, String optionName) {
        return FieldHelper.getConditionalFieldValue(fld, optionName).replace('#', '<').replace('$', '>');
    }

    public static String toUrl(String str) {
        return str.replace('#', '<').replace('$', '>');
    }

    public static String[] getRemainingFieldNames(FieldGroup group, Vector fieldNames) {
        Field[] allFields = group.getField();
        Vector<String> vec = new Vector<String>();
        for (int i = 0; i < allFields.length; ++i) {
            if (fieldNames.contains(allFields[i].getName())) continue;
            vec.add(allFields[i].getName());
        }
        String[] remainingFields = new String[vec.size()];
        return vec.toArray(remainingFields);
    }
}

