/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.sunresources.wizards;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.ResourceUtils;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ResourceConfigData;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ResourceConfigHelper;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ResourceWizardPanel;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.setFocus;
import org.netbeans.modules.j2ee.sun.sunresources.beans.Field;
import org.netbeans.modules.j2ee.sun.sunresources.beans.FieldGroup;
import org.netbeans.modules.j2ee.sun.sunresources.beans.FieldGroupHelper;
import org.netbeans.modules.j2ee.sun.sunresources.beans.FieldHelper;
import org.netbeans.modules.j2ee.sun.sunresources.beans.Wizard;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CPVendorPanel
extends ResourceWizardPanel
implements ChangeListener,
DocumentListener,
ListDataListener {
    static final long serialVersionUID = 93474632245456421L;
    private ArrayList dbconns;
    private ResourceConfigHelper helper;
    private FieldGroup generalGroup;
    private FieldGroup propGroup;
    private FieldGroup vendorGroup;
    private boolean useExistingConnection = true;
    private String[] vendors;
    private boolean firstTime = true;
    private boolean setupValid = true;
    private JTextField nameField;
    private JTextArea descriptionTextArea;
    private JLabel nameLabel;
    private JComboBox nameComboBox;
    private JRadioButton newCofigRadioButton;
    private JRadioButton existingConnRadioButton;
    private JPanel jPanel1;
    private JComboBox existingConnComboBox;
    private JCheckBox isXA;
    private static final ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.Bundle");

    public CPVendorPanel(ResourceConfigHelper helper, Wizard wiardInfo) {
        this.helper = helper;
        this.generalGroup = FieldGroupHelper.getFieldGroup(wiardInfo, "general");
        this.propGroup = FieldGroupHelper.getFieldGroup(wiardInfo, "properties");
        this.vendorGroup = FieldGroupHelper.getFieldGroup(wiardInfo, "propertiesUrl");
        ButtonGroup bg = new ButtonGroup();
        this.dbconns = new ArrayList();
        this.setName(bundle.getString("TITLE_ConnPoolWizardPanel_dbConn"));
        this.initComponents();
        this.initAccessibility();
        this.nameLabel.setLabelFor(this.nameField);
        this.nameLabel.setDisplayedMnemonic(bundle.getString("LBL_pool-name_Mnemonic").charAt(0));
        this.existingConnRadioButton.setMnemonic(bundle.getString("ExistingConnection_Mnemonic").charAt(0));
        this.newCofigRadioButton.setMnemonic(bundle.getString("NewConfiguration_Mnemonic").charAt(0));
        this.isXA.setMnemonic(bundle.getString("isXA_Mnemonic").charAt(0));
        this.nameComboBox.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CPVendorPanel.this.nameComboBox.requestFocus();
            }
        }, KeyStroke.getKeyStroke(78, 8), 2);
        bg.add(this.existingConnRadioButton);
        bg.add(this.newCofigRadioButton);
        bg.getSelection().addChangeListener(this);
        try {
            DatabaseConnection[] cons = ConnectionManager.getDefault().getConnections();
            for (int i = 0; i < cons.length; ++i) {
                this.existingConnComboBox.addItem(cons[i].getName());
                this.dbconns.add(cons[i]);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (this.existingConnComboBox.getItemCount() == 0) {
            this.existingConnComboBox.insertItemAt(bundle.getString("NoConnection"), 0);
            this.newCofigRadioButton.setSelected(true);
        } else {
            this.existingConnComboBox.insertItemAt(bundle.getString("SelectFromTheList"), 0);
            this.existingConnRadioButton.setSelected(true);
            this.setExistingConnData();
        }
        String vendorName = "other";
        this.existingConnRadioButton.setEnabled(true);
        this.existingConnComboBox.setEnabled(true);
        this.newCofigRadioButton.setEnabled(true);
        this.nameComboBox.setEnabled(true);
        Field vendorField = FieldHelper.getField(this.generalGroup, "database-vendor");
        this.vendors = FieldHelper.getTags(vendorField);
        for (int i = 0; i < this.vendors.length; ++i) {
            this.nameComboBox.addItem(bundle.getString("DBVendor_" + this.vendors[i]));
        }
        if (this.nameComboBox.getItemCount() == 0) {
            this.nameComboBox.insertItemAt(bundle.getString("NoTemplate"), 0);
        } else {
            this.nameComboBox.insertItemAt(bundle.getString("SelectFromTheList"), 0);
        }
        this.nameComboBox.setSelectedIndex(0);
        this.existingConnComboBox.getModel().addListDataListener(this);
        this.nameComboBox.getModel().addListDataListener(this);
        this.isXA.setSelected(helper.getData().getString("isXA").equals("true"));
        this.isXA.addChangeListener(this);
        this.newCofigRadioButton.addChangeListener(this);
        this.getAccessibleContext().setAccessibleName(bundle.getString("TITLE_ConnPoolWizardPanel_dbConn"));
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("TITLE_ConnPoolWizardPanel_dbConn"));
        this.firstTime = false;
    }

    private void initAccessibility() {
        this.descriptionTextArea.getAccessibleContext().setAccessibleName(bundle.getString("ACS_DescriptionA11yName"));
        this.descriptionTextArea.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_DescriptionA11yDesc"));
        this.nameLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ToolTip_pool-name"));
        this.nameField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_pool-nameA11yDesc"));
        this.existingConnRadioButton.getAccessibleContext().setAccessibleName(bundle.getString("ExistingConnection"));
        this.existingConnRadioButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_ExistingConnectionA11yDesc"));
        this.existingConnComboBox.getAccessibleContext().setAccessibleName(bundle.getString("ACS_ExistingConnectionComboBoxA11yName"));
        this.existingConnComboBox.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_ExistingConnectionComboBoxA11yDesc"));
        this.newCofigRadioButton.getAccessibleContext().setAccessibleName(bundle.getString("NewConfiguration"));
        this.newCofigRadioButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_NewConnectionA11yDesc"));
        this.nameComboBox.getAccessibleContext().setAccessibleName(bundle.getString("ACS_NewConnectionComboBoxA11yName"));
        this.nameComboBox.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_NewConnectionComboBoxA11yDesc"));
        this.isXA.getAccessibleContext().setAccessibleName(bundle.getString("isXA"));
        this.isXA.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_isXA_A11yDesc"));
    }

    private void initComponents() {
        this.descriptionTextArea = new JTextArea();
        this.jPanel1 = new JPanel();
        this.nameLabel = new JLabel();
        this.nameField = new JTextField();
        this.existingConnRadioButton = new JRadioButton();
        this.existingConnComboBox = new JComboBox();
        this.newCofigRadioButton = new JRadioButton();
        this.nameComboBox = new JComboBox();
        this.isXA = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.setMaximumSize(new Dimension(600, 350));
        this.setMinimumSize(new Dimension(600, 350));
        this.setPreferredSize(new Dimension(600, 350));
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setFont(UIManager.getFont("Label.font"));
        this.descriptionTextArea.setText(bundle.getString("Description"));
        this.descriptionTextArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        this.descriptionTextArea.setRequestFocusEnabled(false);
        this.descriptionTextArea.setEnabled(false);
        this.descriptionTextArea.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.descriptionTextArea, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.nameLabel.setText(bundle.getString("LBL_pool-name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 12, 0);
        this.jPanel1.add((Component)this.nameLabel, gridBagConstraints);
        this.nameField.setText(this.helper.getData().getString("name"));
        this.nameField.setMinimumSize(new Dimension(60, 21));
        this.nameField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CPVendorPanel.this.nameFieldActionPerformed(evt);
            }
        });
        this.nameField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                CPVendorPanel.this.nameFieldKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 12, 0);
        this.jPanel1.add((Component)this.nameField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 12, 20, 12);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.existingConnRadioButton.setSelected(true);
        this.existingConnRadioButton.setText(bundle.getString("ExistingConnection"));
        this.existingConnRadioButton.setToolTipText(bundle.getString("ACS_ExistingConnectionA11yDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.existingConnRadioButton, gridBagConstraints);
        this.existingConnComboBox.setToolTipText(bundle.getString("ACS_ExistingConnectionComboBoxA11yDesc"));
        this.existingConnComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CPVendorPanel.this.existingConnComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 24, 0, 11);
        this.add((Component)this.existingConnComboBox, gridBagConstraints);
        this.newCofigRadioButton.setText(bundle.getString("NewConfiguration"));
        this.newCofigRadioButton.setToolTipText(bundle.getString("ACS_NewConnectionA11yDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.newCofigRadioButton, gridBagConstraints);
        this.nameComboBox.setToolTipText(bundle.getString("ACS_NewConnectionComboBoxA11yDesc"));
        this.nameComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CPVendorPanel.this.nameComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 24, 50, 11);
        this.add((Component)this.nameComboBox, gridBagConstraints);
        this.isXA.setText(bundle.getString("isXA"));
        this.isXA.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CPVendorPanel.this.isXAActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 5, 11);
        this.add((Component)this.isXA, gridBagConstraints);
    }

    private void nameFieldKeyReleased(KeyEvent evt) {
        String newValue;
        ResourceConfigData data = this.helper.getData();
        String value = data.getString("name");
        if (!value.equals(newValue = this.nameField.getText())) {
            this.helper.getData().setString("name", newValue);
        }
        this.fireChange(this);
    }

    private void nameFieldActionPerformed(ActionEvent evt) {
        this.setResourceName();
    }

    public String getNameField() {
        return this.nameField.getText();
    }

    private void setResourceName() {
        String newValue;
        ResourceConfigData data = this.helper.getData();
        String value = data.getString("name");
        if (!value.equals(newValue = this.nameField.getText())) {
            this.helper.getData().setString("name", newValue);
            this.fireChange(this);
        }
        if (this.getRootPane().getDefaultButton() != null && this.getRootPane().getDefaultButton().isEnabled()) {
            this.getRootPane().getDefaultButton().doClick();
        }
    }

    private void isXAActionPerformed(ActionEvent evt) {
        this.setNewConfigData(false);
    }

    private void nameComboBoxActionPerformed(ActionEvent evt) {
        this.setNewConfigData(true);
    }

    private void setNewConfigData(boolean replaceProps) {
        if (this.firstTime) {
            return;
        }
        int index = this.nameComboBox.getSelectedIndex();
        if (index > 0) {
            if (this.useExistingConnection) {
                this.useExistingConnection = false;
            }
            ResourceConfigData data = this.helper.getData();
            data.setString("is-cp-existing", "false");
            String vendorName = this.vendors[index - 1];
            String savedVendorName = data.getString("database-vendor");
            String savedXA = data.getString("isXA");
            String XA = this.isXA.isSelected() ? "true" : "false";
            boolean vendorNotChanged = vendorName.equals(savedVendorName);
            boolean isXANotChanged = XA.equals(savedXA);
            if (vendorNotChanged && isXANotChanged) {
                return;
            }
            if (!vendorNotChanged) {
                data.setString("database-vendor", vendorName);
            }
            if (!isXANotChanged) {
                data.setString("isXA", XA);
            }
            this.setDataSourceClassNameAndResTypeInData(vendorName);
            if (replaceProps) {
                this.setPropertiesInData(vendorName);
            }
        }
    }

    private void setDataSourceClassNameAndResTypeInData(String vendorName) {
        ResourceConfigData data = this.helper.getData();
        Field dsField = this.isXA.isSelected() ? FieldHelper.getField(this.generalGroup, "datasource-classname-xa") : FieldHelper.getField(this.generalGroup, "datasource-classname");
        data.setString("datasource-classname", FieldHelper.getConditionalFieldValue(dsField, vendorName));
        if (this.isXA.isSelected()) {
            data.setString("res-type", "javax.sql.XADataSource");
            data.setString("isXA", "true");
        } else {
            data.setString("res-type", "javax.sql.DataSource");
            data.setString("isXA", "false");
        }
    }

    private void setPropertiesInData(String vendorName) {
        ResourceConfigData data = this.helper.getData();
        data.setProperties(new Vector());
        Field[] propFields = this.propGroup.getField();
        for (int i = 0; i < propFields.length; ++i) {
            String value = FieldHelper.getConditionalFieldValue(propFields[i], vendorName);
            String name = propFields[i].getName();
            if (name.equals("URL") && value.length() > 0) {
                data.addProperty(name, FieldHelper.toUrl(value));
                continue;
            }
            if (name.equals("databaseName") && value.length() > 0) {
                data.addProperty(name, FieldHelper.toUrl(value));
                continue;
            }
            if (name.equals("User") || name.equals("Password")) {
                data.addProperty(propFields[i].getName(), value);
                continue;
            }
            if (value.length() <= 0 || !value.equals("NA")) continue;
            data.addProperty(propFields[i].getName(), "");
        }
    }

    private void existingConnComboBoxActionPerformed(ActionEvent evt) {
        this.setExistingConnData();
    }

    public void setExistingConnData() {
        if (this.existingConnComboBox.getSelectedIndex() > 0) {
            if (!this.useExistingConnection) {
                this.helper.getData().setResourceName("jdbc-connection-pool");
                this.useExistingConnection = true;
            }
            this.helper.getData().setString("is-cp-existing", "true");
            DatabaseConnection dbconn = (DatabaseConnection)this.dbconns.get(this.existingConnComboBox.getSelectedIndex() - 1);
            String url = dbconn.getDatabaseURL();
            String user = dbconn.getUser();
            String password = dbconn.getPassword();
            String tmpStr = url;
            Field urlField = FieldHelper.getField(this.vendorGroup, "vendorUrls");
            String vendorName = FieldHelper.getOptionNameFromValue(urlField, tmpStr);
            ResourceConfigData data = this.helper.getData();
            data.setProperties(new Vector());
            data.setString("database-vendor", vendorName);
            if (vendorName.equals("pointbase")) {
                data.addProperty("databaseName", dbconn.getDatabaseURL());
            } else if (vendorName.startsWith("derby")) {
                this.setDerbyProps(vendorName, url);
            } else {
                data.addProperty("URL", url);
            }
            data.addProperty("User", user);
            data.addProperty("Password", password);
            this.setDataSourceClassNameAndResTypeInData(vendorName);
        }
    }

    private void setDerbyProps(String vendorName, String url) {
        ResourceConfigData data = this.helper.getData();
        data.setProperties(new Vector());
        Field[] propFields = this.propGroup.getField();
        for (int i = 0; i < propFields.length; ++i) {
            String value = FieldHelper.getConditionalFieldValue(propFields[i], vendorName);
            if (!value.equals("NA")) continue;
            String name = propFields[i].getName();
            if (!vendorName.equals("derby_net")) continue;
            String hostName = "";
            String portNumber = "";
            String databaseName = "";
            try {
                String workingUrl = url.substring(url.indexOf("//") + 2, url.length());
                if (workingUrl.indexOf(":") != -1) {
                    hostName = workingUrl.substring(0, workingUrl.indexOf(":"));
                    if (workingUrl.indexOf("/") != -1) {
                        portNumber = workingUrl.substring(workingUrl.indexOf(":") + 1, workingUrl.indexOf("/"));
                        int braceIndex = workingUrl.indexOf("[");
                        databaseName = braceIndex == -1 ? workingUrl.substring(workingUrl.indexOf("/") + 1, workingUrl.length()) : workingUrl.substring(workingUrl.indexOf("/") + 1, braceIndex + 1).trim();
                    }
                }
            }
            catch (StringIndexOutOfBoundsException ex) {
                // empty catch block
            }
            if (name.equals("PortNumber")) {
                data.addProperty(name, portNumber);
                continue;
            }
            if (name.equals("DatabaseName")) {
                data.addProperty(name, databaseName);
                continue;
            }
            if (!name.equals("serverName")) continue;
            data.addProperty(name, hostName);
        }
    }

    public boolean isValid() {
        if (!this.setupValid) {
            this.setErrorMsg(bundle.getString("Err_InvalidSetup"));
            return false;
        }
        this.setErrorMsg(bundle.getString("Empty_String"));
        String name = this.nameField.getText();
        if (name == null || name.length() == 0) {
            this.setErrorMsg(bundle.getString("Err_InvalidName"));
            return false;
        }
        if (!ResourceUtils.isLegalResourceName(name)) {
            return false;
        }
        if (!ResourceUtils.isUniqueFileName(name, this.helper.getData().getTargetFileObject(), "connectionPool")) {
            this.setErrorMsg(bundle.getString("Err_DuplFileName"));
            return false;
        }
        if (this.existingConnRadioButton.isSelected()) {
            if (this.existingConnComboBox.getSelectedIndex() > 0) {
                return true;
            }
            this.setErrorMsg(bundle.getString("Err_ChooseDBConn"));
        } else if (this.newCofigRadioButton.isSelected()) {
            if (this.nameComboBox.getSelectedIndex() > 0) {
                return true;
            }
            this.setErrorMsg(bundle.getString("Err_ChooseDBVendor"));
        }
        return false;
    }

    public void removeUpdate(DocumentEvent event) {
        this.fireChange(this);
    }

    public void changedUpdate(DocumentEvent event) {
        this.fireChange(this);
    }

    public void insertUpdate(DocumentEvent event) {
        this.fireChange(this);
    }

    public void intervalAdded(ListDataEvent p1) {
        this.fireChange(this);
    }

    public void intervalRemoved(ListDataEvent p1) {
        this.fireChange(this);
    }

    public void contentsChanged(ListDataEvent p1) {
        this.fireChange(this);
    }

    public void stateChanged(ChangeEvent p1) {
        if (this.firstTime) {
            return;
        }
        if (p1.getSource().getClass() == JToggleButton.ToggleButtonModel.class) {
            if (this.existingConnRadioButton.isSelected()) {
                if (this.firstTime) {
                    return;
                }
                this.existingConnComboBox.setEnabled(true);
                this.nameComboBox.setEnabled(false);
                this.setExistingConnData();
            } else {
                this.existingConnComboBox.setEnabled(false);
                this.nameComboBox.setEnabled(true);
                this.setNewConfigData(true);
            }
        }
        this.fireChange(this);
    }

    public CPVendorPanel setFirstTime(boolean first) {
        this.firstTime = first;
        return this;
    }

    protected void initData() {
    }

    public HelpCtx getHelp() {
        return new HelpCtx("AS_Wiz_ConnPool_chooseDB");
    }

    public void readSettings(Object settings) {
        this.wizDescriptor = (WizardDescriptor)settings;
        TemplateWizard wizard = (TemplateWizard)settings;
        String targetName = wizard.getTargetName();
        if (this.helper.getData().getString("dynamicPanel").equals("true")) {
            targetName = null;
        }
        FileObject setupFolder = ResourceUtils.getResourceDirectory(this.helper.getData().getTargetFileObject());
        this.helper.getData().setTargetFileObject(setupFolder);
        if (setupFolder != null) {
            targetName = ResourceUtils.createUniqueFileName(targetName, setupFolder, "connectionPool");
            this.nameField.setText(targetName);
            this.helper.getData().setString("name", targetName);
            this.helper.getData().setTargetFile(targetName);
        } else {
            this.setupValid = false;
        }
    }

    public void setInitialFocus() {
        new setFocus(this.nameField);
    }

    private boolean setupValid() {
        return this.setupValid;
    }
}

