/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.editors;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyEditorSupport;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import org.netbeans.modules.j2ee.sun.ide.editors.NameValuePair;
import org.netbeans.modules.j2ee.sun.ide.editors.NameValuePairEditor;
import org.netbeans.modules.j2ee.sun.ide.editors.ui.AbstractDDTableModel;
import org.netbeans.modules.j2ee.sun.ide.editors.ui.DDTableModelEditor;
import org.netbeans.modules.j2ee.sun.ide.editors.ui.DDTablePanel;
import org.netbeans.modules.j2ee.sun.ide.editors.ui.SortableDDTableModel;

public class NameValuePairsPropertyEditor
extends PropertyEditorSupport {
    NameValuePair[] params;
    static final ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/editors/Bundle");
    protected static String[] requiredToolTips = new String[]{bundle.getString("tipParamName"), bundle.getString("tipParamValue")};

    public NameValuePairsPropertyEditor(NameValuePair[] val) {
        this.params = val == null ? new NameValuePair[0] : val;
    }

    public NameValuePairsPropertyEditor(Object val) {
        this.params = val == null ? new NameValuePair[0] : this.getNameValuePairs(val);
    }

    public void setAsText(String string) throws IllegalArgumentException {
    }

    public String getAsText() {
        return this.getPaintableString();
    }

    public Component getCustomEditor() {
        ParamModel model = null;
        model = new ParamModel(this.params);
        DDTablePanel panel = new DDTablePanel(new SortableDDTableModel(model), requiredToolTips);
        return panel;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        String s = this.getPaintableString();
        FontMetrics fm = gfx.getFontMetrics();
        gfx.drawString(s, 4, (box.height - fm.getHeight()) / 2 + 1 + fm.getMaxAscent());
    }

    protected String getPaintableString() {
        Object[] entries = (Object[])this.getValue();
        if (entries == null || entries.length == 0) {
            return bundle.getString("TXT_Param");
        }
        if (entries.length == 1) {
            return bundle.getString("TXT_OneParam");
        }
        return MessageFormat.format(bundle.getString("TXT_MultiParam"), Integer.toString(entries.length));
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void setValue(Object value) {
        if (value instanceof NameValuePair[]) {
            NameValuePair[] tmpValue = (NameValuePair[])value;
            this.params = new NameValuePair[tmpValue.length];
            for (int i = 0; i < tmpValue.length; ++i) {
                NameValuePair param = new NameValuePair();
                param.setParamName(tmpValue[i].getParamName());
                param.setParamValue(tmpValue[i].getParamValue());
                this.params[i] = param;
            }
        } else {
            this.params = this.getNameValuePairs(value);
        }
    }

    public Object getValue() {
        NameValuePair[] retVal = new NameValuePair[this.params.length];
        for (int i = 0; i < this.params.length; ++i) {
            NameValuePair val = new NameValuePair();
            val.setParamName(this.params[i].getParamName());
            val.setParamValue(this.params[i].getParamValue());
            retVal[i] = val;
        }
        return retVal;
    }

    private NameValuePair[] getNameValuePairs(Object attrVal) {
        Map attributeMap = (Map)attrVal;
        Set attributeKeys = attributeMap.keySet();
        Iterator it = attributeKeys.iterator();
        NameValuePair[] pairs = new NameValuePair[attributeKeys.size()];
        int i = 0;
        while (it.hasNext()) {
            NameValuePair pair = new NameValuePair();
            Object key = it.next();
            pair.setParamName(key.toString());
            pair.setParamValue(attributeMap.get(key).toString());
            pairs[i] = pair;
            ++i;
        }
        return pairs;
    }

    public class ParamModel
    extends AbstractDDTableModel {
        public ParamModel(NameValuePair[] rows) {
            super(rows);
        }

        public String getColumnName(int col) {
            if (0 == col) {
                return bundle.getString("colHdrParamName");
            }
            return bundle.getString("colHdrParamValue");
        }

        public Object getValueAt(int row, int col) {
            NameValuePair rowObj = null;
            rowObj = (NameValuePair)this.data.get(row);
            if (null != rowObj) {
                if (0 == col) {
                    return rowObj.getParamName();
                }
                return rowObj.getParamValue();
            }
            return null;
        }

        public List isValueValid(Object obj, int param) {
            Vector<String> errors = new Vector<String>();
            NameValuePair edit = (NameValuePair)obj;
            String editParamName = edit.getParamName();
            String editParamValue = edit.getParamValue();
            NameValuePair row = null;
            String rowParamName = null;
            if (editParamName == null || editParamName.trim().length() == 0) {
                errors.add(bundle.getString("ERR_InvalidEntry"));
            } else if (editParamValue == null || editParamValue.trim().length() == 0) {
                errors.add(bundle.getString("ERR_NoValue"));
            }
            for (int i = 0; i < this.data.size(); ++i) {
                row = (NameValuePair)this.data.elementAt(i);
                rowParamName = row.getParamName();
                if (i == param || !rowParamName.equals(editParamName)) continue;
                errors.add(bundle.getString("ERR_DuplicateEntry"));
            }
            return errors;
        }

        public boolean isEditValid(Object obj, int index) {
            return true;
        }

        public String getModelName() {
            return bundle.getString("ParamModel_modelName");
        }

        public DDTableModelEditor getEditor() {
            return new NameValuePairEditor();
        }

        protected void setValueAt(String str, Object obj, int param) {
            NameValuePair inVal = (NameValuePair)obj;
            if (0 == param) {
                inVal.setParamName(str);
            } else {
                inVal.setParamValue(str);
            }
        }

        public Object makeNewElement() {
            NameValuePair retVal = new NameValuePair();
            retVal.setParamName("");
            retVal.setParamValue("");
            return retVal;
        }

        public Object[] getValue() {
            return this.data.toArray();
        }

        public int getColumnCount() {
            return 2;
        }
    }
}

