/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.wizards;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.common.DelegatingWizardDescriptorPanel;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.Entity;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.wizard.PersistenceClientEntitySelection;
import org.netbeans.modules.web.jsf.wizards.JSFClinetGenerator;
import org.netbeans.modules.web.jsf.wizards.PersistenceClientSetupPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PersistenceClientIterator
implements TemplateWizard.Iterator {
    private int index;
    private transient WizardDescriptor.Panel[] panels;

    public Set instantiate(TemplateWizard wizard) throws IOException {
        List entities = (List)wizard.getProperty("EntityClass");
        String jsfFolder = (String)wizard.getProperty("JSFFolder");
        Project project = Templates.getProject((WizardDescriptor)wizard);
        FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)wizard);
        String controllerPkg = (String)wizard.getProperty("ControllerBean");
        PersistenceUnit persistenceUnit = (PersistenceUnit)wizard.getProperty("PersistenceUnit");
        if (persistenceUnit != null) {
            ProviderUtil.addPersistenceUnit((PersistenceUnit)persistenceUnit, (Project)Templates.getProject((WizardDescriptor)wizard));
        }
        for (Entity entity : entities) {
            String entityClass = entity.getClass2();
            String simpleClassName = JSFClinetGenerator.simpleClassName(entityClass);
            String firstLower = simpleClassName.substring(0, 1).toLowerCase() + simpleClassName.substring(1);
            String folder = jsfFolder.endsWith("/") ? jsfFolder : jsfFolder + "/";
            folder = folder + firstLower;
            String controller = controllerPkg + "." + simpleClassName + "Controller";
            JSFClinetGenerator.generateJSFPages(project, entityClass, folder, controller, targetFolder);
        }
        return Collections.singleton(DataFolder.findFolder((FileObject)targetFolder));
    }

    public void initialize(TemplateWizard wizard) {
        this.index = 0;
        Project project = Templates.getProject((WizardDescriptor)wizard);
        DataFolder targetFolder = null;
        try {
            targetFolder = wizard.getTargetFolder();
        }
        catch (IOException ex) {
            targetFolder = DataFolder.findFolder((FileObject)project.getProjectDirectory());
        }
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        ValidationPanel secondPanel = new ValidationPanel((WizardDescriptor.Panel)new PersistenceClientEntitySelection(NbBundle.getMessage(PersistenceClientIterator.class, (String)"LBL_EntityClasses"), new HelpCtx(PersistenceClientIterator.class.getName() + "$PersistenceClientEntitySelection"), (WizardDescriptor)wizard));
        PersistenceClientSetupPanel thirdPanel = new PersistenceClientSetupPanel(project, (WizardDescriptor)wizard);
        this.panels = new WizardDescriptor.Panel[]{secondPanel, thirdPanel};
        String[] names = new String[]{NbBundle.getMessage(PersistenceClientIterator.class, (String)"LBL_EntityClasses"), NbBundle.getMessage(PersistenceClientIterator.class, (String)"LBL_JSFPagesAndClasses")};
        wizard.putProperty("NewFileWizard_Title", (Object)NbBundle.getMessage(PersistenceClientIterator.class, (String)"Templates/Persistence/JsfFromDB"));
        org.netbeans.modules.j2ee.persistence.wizard.Util.mergeSteps((WizardDescriptor)wizard, (WizardDescriptor.Panel[])this.panels, (String[])names);
    }

    private String[] createSteps(String[] before, WizardDescriptor.Panel[] panels) {
        int diff = 0;
        if (before == null) {
            before = new String[]{};
        } else if (before.length > 0) {
            diff = "...".equals(before[before.length - 1]) ? 1 : 0;
        }
        String[] res = new String[before.length - diff + panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < before.length - diff ? before[i] : panels[i - before.length + diff].getComponent().getName();
        }
        return res;
    }

    public void uninitialize(TemplateWizard wiz) {
        this.panels = null;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public String name() {
        return NbBundle.getMessage(PersistenceClientIterator.class, (String)"LBL_WizardTitle_FromEntity");
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private class ValidationPanel
    extends DelegatingWizardDescriptorPanel {
        private ValidationPanel(WizardDescriptor.Panel delegate) {
            super(delegate);
        }

        public boolean isValid() {
            Project project = this.getProject();
            WizardDescriptor wizardDescriptor = this.getWizardDescriptor();
            if (!Util.isValidServerInstance((Project)project)) {
                wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PersistenceClientIterator.class, (String)"ERR_MissingServer"));
                return false;
            }
            return super.isValid();
        }
    }
}

