/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.refactoring;

import java.util.Collection;
import java.util.List;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveClassRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.web.jsf.refactoring.JSFRenamePlugin;
import org.netbeans.modules.web.jsf.refactoring.Occurrences;
import org.openide.ErrorManager;

public class JSFMoveClassPlugin
implements RefactoringPlugin {
    private static ThreadLocal semafor = new ThreadLocal();
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.web.jsf.refactoring");
    private final MoveClassRefactoring refactoring;

    public JSFMoveClassPlugin(MoveClassRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public void cancelRequest() {
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        if (semafor.get() == null) {
            semafor.set(new Object());
            Collection resources = this.refactoring.getResources();
            for (Resource resource : resources) {
                String newPackageName = this.refactoring.getTargetPackageName(resource);
                List classes = resource.getClassifiers();
                for (JavaClass jClass : classes) {
                    String newClassName = newPackageName + "." + jClass.getSimpleName();
                    List<Occurrences.OccurrenceItem> items = Occurrences.getAllOccurrences(jClass, newClassName);
                    for (Occurrences.OccurrenceItem item : items) {
                        refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new JSFRenamePlugin.JSFConfigRenameClassElement(item));
                    }
                }
            }
            semafor.set(null);
        }
        return null;
    }
}

