/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.jspel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.modules.web.core.syntax.completion.JspCompletionItem;
import org.netbeans.modules.web.jsf.config.model.ManagedBean;
import org.netbeans.modules.web.jsf.editor.jspel.JSFBeanCache;
import org.netbeans.modules.web.jsf.editor.jspel.JSFELExpression;
import org.netbeans.modules.web.jsf.editor.jspel.JSFResultItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.filesystems.FileObject;

public class JSFELCompletionProvider
implements CompletionProvider {
    public CompletionTask createTask(int queryType, JTextComponent component) {
        if (queryType == 1) {
            return new AsyncCompletionTask((AsyncCompletionQuery)new CCQuery(component.getCaret().getDot()), component);
        }
        return null;
    }

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 0;
    }

    static class DocQuery
    extends AsyncCompletionQuery {
        DocQuery() {
        }

        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
        }
    }

    static final class CCQuery
    extends AsyncCompletionQuery {
        private int creationCaretOffset;
        private JTextComponent component;

        CCQuery(int caretOffset) {
            this.creationCaretOffset = caretOffset;
        }

        protected void query(CompletionResultSet resultSet, Document doc, int offset) {
            ExtSyntaxSupport sup = (ExtSyntaxSupport)Utilities.getSyntaxSupport((JTextComponent)this.component);
            FileObject fObject = NbEditorUtilities.getFileObject((Document)doc);
            WebModule wm = null;
            if (fObject != null) {
                wm = WebModule.getWebModule((FileObject)fObject);
            }
            if (sup instanceof JspSyntaxSupport && wm != null) {
                JSFELExpression elExpr = new JSFELExpression(wm, (JspSyntaxSupport)sup);
                ArrayList<JspCompletionItem.ELBean> complItems = new ArrayList<JspCompletionItem.ELBean>();
                switch (elExpr.parse(offset)) {
                    case 1: {
                        List beans = JSFBeanCache.getBeans(wm);
                        for (int i = 0; i < beans.size(); ++i) {
                            ManagedBean bean = (ManagedBean)beans.get(i);
                            if (!bean.getManagedBeanName().startsWith(elExpr.getReplace())) continue;
                            complItems.add(new JSFResultItem.JSFBean(bean.getManagedBeanName(), bean.getManagedBeanClass()));
                        }
                        break;
                    }
                    case 100: {
                        String name;
                        JavaClass mbean = elExpr.getBean(elExpr.getExpression());
                        Iterator iter = elExpr.getProperties(elExpr.getExpression(), mbean).iterator();
                        while (iter.hasNext()) {
                            name = (String)iter.next();
                            if (!name.startsWith(elExpr.getReplace())) continue;
                            complItems.add((JspCompletionItem.ELBean)new JspCompletionItem.ELProperty(name, (String)iter.next()));
                        }
                        if (!elExpr.onlyJSFExpression(offset)) break;
                        iter = elExpr.getMethods(elExpr.getExpression(), mbean).iterator();
                        while (iter.hasNext()) {
                            name = (String)iter.next();
                            if (!name.startsWith(elExpr.getReplace())) continue;
                            complItems.add(new JSFResultItem.JSFMethod(name, (String)iter.next()));
                        }
                        break;
                    }
                }
                for (int i = 0; i < complItems.size(); ++i) {
                    ((JspCompletionItem.JspResultItem)complItems.get(i)).setSubstituteOffset(offset - elExpr.getReplace().length());
                }
                resultSet.addAllItems(complItems);
            }
            resultSet.finish();
        }

        protected void prepareQuery(JTextComponent component) {
            this.component = component;
        }
    }
}

