/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.schema2beans.GraphManager;
import org.netbeans.modules.web.jsf.JSFCatalog;
import org.netbeans.modules.web.jsf.JSFConfigEditorSupport;
import org.netbeans.modules.web.jsf.JSFConfigLoader;
import org.netbeans.modules.web.jsf.JSFConfigNode;
import org.netbeans.modules.web.jsf.SAXParseError;
import org.netbeans.modules.web.jsf.config.model_1_1.FacesConfig;
import org.netbeans.spi.xml.cookies.CheckXMLSupport;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.netbeans.spi.xml.cookies.ValidateXMLSupport;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class JSFConfigDataObject
extends MultiDataObject
implements CookieSet.Factory {
    private static JSFCatalog jsfCatalog = new JSFCatalog();
    private boolean documentDirty = true;
    private boolean documentValid = true;
    protected boolean nodeDirty = false;
    private InputStream inputStream;
    private transient JSFConfigEditorSupport editorSupport;
    private SAXParseError error;
    private org.netbeans.modules.web.jsf.config.model.FacesConfig lastGoodFacesConfig = null;
    public static final String PROP_DOC_VALID = "documentValid";

    public JSFConfigDataObject(FileObject pf, JSFConfigLoader loader) throws DataObjectExistsException {
        super(pf, (MultiFileLoader)loader);
        this.init();
    }

    private void init() {
        CookieSet cookies = this.getCookieSet();
        this.getCookieSet().add(JSFConfigEditorSupport.class, (CookieSet.Factory)this);
        InputSource in = DataObjectAdapters.inputSource((DataObject)this);
        CheckXMLSupport checkCookie = new CheckXMLSupport(in);
        this.getCookieSet().add((Node.Cookie)checkCookie);
        ValidateXMLSupport validateCookie = new ValidateXMLSupport(in);
        this.getCookieSet().add((Node.Cookie)validateCookie);
    }

    protected synchronized Node createNodeDelegate() {
        return new JSFConfigNode(this);
    }

    public Node.Cookie createCookie(Class clazz) {
        if (clazz.isAssignableFrom(JSFConfigEditorSupport.class)) {
            return this.getEditorSupport();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSFConfigEditorSupport getEditorSupport() {
        if (this.editorSupport == null) {
            JSFConfigDataObject jSFConfigDataObject = this;
            synchronized (jSFConfigDataObject) {
                if (this.editorSupport == null) {
                    this.editorSupport = new JSFConfigEditorSupport(this);
                }
            }
        }
        return this.editorSupport;
    }

    public org.netbeans.modules.web.jsf.config.model.FacesConfig getFacesConfig() throws IOException {
        if (this.lastGoodFacesConfig == null) {
            this.parsingDocument();
        }
        return this.lastGoodFacesConfig;
    }

    protected InputStream prepareInputSource() throws IOException {
        if (this.getEditorSupport() != null && this.getEditorSupport().isDocumentLoaded()) {
            return this.getEditorSupport().getInputStream();
        }
        return this.getPrimaryFile().getInputStream();
    }

    protected void closeInputSource() {
        InputStream is = this.inputStream;
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (is == this.inputStream) {
                this.inputStream = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(org.netbeans.modules.web.jsf.config.model.FacesConfig config) throws IOException {
        File file = FileUtil.toFile((FileObject)this.getPrimaryFile());
        FileObject configFO = this.getPrimaryFile();
        try {
            FileLock lock = configFO.lock();
            try {
                OutputStream os = configFO.getOutputStream(lock);
                try {
                    config.write(os);
                }
                finally {
                    os.close();
                }
            }
            finally {
                lock.releaseLock();
            }
        }
        catch (FileAlreadyLockedException ex) {
            try {
                BaseDocument doc = (BaseDocument)this.getEditorSupport().getDocument();
                doc.remove(0, doc.getLength());
                StringWriter text = new StringWriter();
                config.write(text);
                doc.insertString(0, text.toString(), null);
                doc.getFormatter().reformat(doc, 0, doc.getLength());
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parsingDocument() {
        this.error = null;
        try {
            this.error = this.updateNode(this.prepareInputSource());
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            this.setDocumentValid(false);
            return;
        }
        finally {
            this.closeInputSource();
            this.documentDirty = false;
        }
        if (this.error == null) {
            this.setDocumentValid(true);
        } else {
            this.setDocumentValid(false);
        }
        this.setNodeDirty(false);
    }

    public void setDocumentValid(boolean valid) {
        if (this.documentValid != valid) {
            if (valid) {
                this.repairNode();
            }
            this.documentValid = valid;
            this.firePropertyChange(PROP_DOC_VALID, !this.documentValid ? Boolean.TRUE : Boolean.FALSE, this.documentValid ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    protected void repairNode() {
        StatusDisplayer.getDefault().setStatusText("");
    }

    private Document getDomDocument(InputStream inputSource) throws SAXParseException {
        try {
            Document doc = GraphManager.createXmlDocument((InputSource)new InputSource(inputSource), (boolean)false, (EntityResolver)jsfCatalog, (ErrorHandler)new J2eeErrorHandler(this));
            return doc;
        }
        catch (Exception e) {
            throw new SAXParseException(e.getMessage(), new LocatorImpl());
        }
    }

    protected SAXParseError updateNode(InputStream is) throws IOException {
        try {
            Document doc = this.getDomDocument(is);
            String version = JSFCatalog.extractVersion(doc);
            if ("1.1".equals(version)) {
                this.lastGoodFacesConfig = FacesConfig.createGraph(doc);
            }
            if ("1.0".equals(version)) {
                this.lastGoodFacesConfig = FacesConfig.createGraph(doc);
            }
            if ("1.2".equals(version)) {
                this.lastGoodFacesConfig = org.netbeans.modules.web.jsf.config.model_1_2.FacesConfig.createGraph(doc);
            }
        }
        catch (SAXParseException ex) {
            return new SAXParseError(ex);
        }
        catch (SAXException ex) {
            throw new IOException();
        }
        return null;
    }

    public boolean isDocumentValid() {
        return this.documentValid;
    }

    public void setDocumentDirty(boolean dirty) {
        this.documentDirty = dirty;
    }

    public boolean isDocumentDirty() {
        return this.documentDirty;
    }

    public boolean isNodeDirty() {
        return this.nodeDirty;
    }

    public void setNodeDirty(boolean dirty) {
        this.nodeDirty = dirty;
    }

    CookieSet getCookieSet0() {
        return this.getCookieSet();
    }

    private void createSAXParseError(SAXParseException error) {
        this.error = new SAXParseError(error);
    }

    public static class J2eeErrorHandler
    implements ErrorHandler {
        private JSFConfigDataObject dataObject;

        public J2eeErrorHandler(JSFConfigDataObject obj) {
            this.dataObject = obj;
        }

        public void error(SAXParseException exception) throws SAXException {
            this.dataObject.createSAXParseError(exception);
            throw exception;
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            this.dataObject.createSAXParseError(exception);
            throw exception;
        }

        public void warning(SAXParseException exception) throws SAXException {
            this.dataObject.createSAXParseError(exception);
            throw exception;
        }
    }
}

