/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import org.netbeans.tax.CannotMergeException;
import org.netbeans.tax.InvalidArgumentException;
import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeEntityDecl;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.TreeParentNode;
import org.netbeans.tax.TreeReference;
import org.netbeans.tax.Util;

public abstract class TreeEntityReference
extends TreeParentNode
implements TreeReference {
    public static final String PROP_NAME = "name";
    private String name;
    private TreeEntityDecl entityDecl;

    protected TreeEntityReference(String name) throws InvalidArgumentException {
        this.checkName(name);
        this.name = name;
    }

    protected TreeEntityReference(TreeEntityReference entityReference, boolean deep) {
        super(entityReference, deep);
        this.name = entityReference.name;
    }

    public boolean equals(Object object, boolean deep) {
        if (!super.equals(object, deep)) {
            return false;
        }
        TreeEntityReference peer = (TreeEntityReference)object;
        return Util.equals(this.getName(), peer.getName());
    }

    public void merge(TreeObject treeObject) throws CannotMergeException {
        super.merge(treeObject);
        TreeEntityReference peer = (TreeEntityReference)treeObject;
        this.setNameImpl(peer.getName());
    }

    public String getName() {
        return this.name;
    }

    private final void setNameImpl(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.firePropertyChange(PROP_NAME, oldName, newName);
    }

    public final void setName(String newName) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.name, newName)) {
            return;
        }
        this.checkReadOnly();
        this.checkName(newName);
        this.setNameImpl(newName);
    }

    protected abstract void checkName(String var1) throws InvalidArgumentException;

    public TreeEntityDecl getEntityDecl() {
        return this.entityDecl;
    }

    protected abstract class ChildListContentManager
    extends TreeParentNode.ChildListContentManager {
        protected ChildListContentManager() {
            super(TreeEntityReference.this);
        }
    }
}

