/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import org.netbeans.tax.CannotMergeException;
import org.netbeans.tax.InvalidArgumentException;
import org.netbeans.tax.InvalidStateException;
import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeNodeDecl;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.TreeUtilities;
import org.netbeans.tax.Util;
import org.netbeans.tax.spec.ConditionalSection;
import org.netbeans.tax.spec.DTD;
import org.netbeans.tax.spec.DocumentType;
import org.netbeans.tax.spec.ParameterEntityReference;

public class TreeEntityDecl
extends TreeNodeDecl
implements DTD.Child,
ParameterEntityReference.Child,
DocumentType.Child,
ConditionalSection.Child {
    public static final String PROP_PARAMETER = "parameter";
    public static final String PROP_NAME = "name";
    public static final String PROP_TYPE = "type";
    public static final String PROP_INTERNAL_TEXT = "internalText";
    public static final String PROP_PUBLIC_ID = "publicId";
    public static final String PROP_SYSTEM_ID = "systemId";
    public static final String PROP_NOTATION_NAME = "notationName";
    public static final short TYPE_INTERNAL = 1;
    public static final short TYPE_EXTERNAL = 2;
    public static final short TYPE_UNPARSED = 3;
    public static final boolean GENERAL_DECL = false;
    public static final boolean PARAMETER_DECL = true;
    private boolean parameter;
    private String name;
    private short type;
    private String internalText;
    private String publicId;
    private String systemId;
    private String notationName;

    private TreeEntityDecl(boolean parameter, String name) throws InvalidArgumentException {
        this.checkName(name);
        this.name = name;
        this.parameter = parameter;
    }

    public TreeEntityDecl(boolean parameter, String name, String internalText) throws InvalidArgumentException {
        this(parameter, name);
        this.checkInternalText(internalText);
        this.type = 1;
        this.internalText = internalText;
        this.publicId = null;
        this.systemId = null;
        this.notationName = null;
    }

    public TreeEntityDecl(String name, String internalText) throws InvalidArgumentException {
        this(false, name, internalText);
    }

    public TreeEntityDecl(boolean parameter, String name, String publicId, String systemId) throws InvalidArgumentException {
        this(parameter, name);
        this.checkExternalDecl(publicId, systemId);
        this.type = (short)2;
        this.internalText = null;
        this.publicId = publicId;
        this.systemId = systemId;
        this.notationName = null;
    }

    public TreeEntityDecl(String name, String publicId, String systemId) throws InvalidArgumentException {
        this(false, name, publicId, systemId);
    }

    public TreeEntityDecl(String name, String publicId, String systemId, String notationName) throws InvalidArgumentException {
        this(false, name);
        this.checkUnparsedDecl(publicId, systemId, notationName);
        this.type = (short)3;
        this.internalText = null;
        this.publicId = publicId;
        this.systemId = systemId;
        this.notationName = notationName;
    }

    protected TreeEntityDecl(TreeEntityDecl entityDecl) {
        super(entityDecl);
        this.parameter = entityDecl.parameter;
        this.name = entityDecl.name;
        this.type = entityDecl.type;
        this.internalText = entityDecl.internalText;
        this.publicId = entityDecl.publicId;
        this.systemId = entityDecl.systemId;
        this.notationName = entityDecl.notationName;
    }

    public Object clone() {
        return new TreeEntityDecl(this);
    }

    public boolean equals(Object object, boolean deep) {
        if (!super.equals(object, deep)) {
            return false;
        }
        TreeEntityDecl peer = (TreeEntityDecl)object;
        if (!Util.equals(this.getName(), peer.getName())) {
            return false;
        }
        if (this.isParameter() != peer.isParameter()) {
            return false;
        }
        if (this.getType() != peer.getType()) {
            return false;
        }
        if (!Util.equals(this.getPublicId(), peer.getPublicId())) {
            return false;
        }
        if (!Util.equals(this.getSystemId(), peer.getSystemId())) {
            return false;
        }
        if (!Util.equals(this.getInternalText(), peer.getInternalText())) {
            return false;
        }
        return Util.equals(this.getNotationName(), peer.getNotationName());
    }

    public void merge(TreeObject treeObject) throws CannotMergeException {
        super.merge(treeObject);
        TreeEntityDecl peer = (TreeEntityDecl)treeObject;
        this.setNameImpl(peer.getName());
        this.setParameterImpl(peer.isParameter());
        short peerType = peer.getType();
        switch (peerType) {
            case 2: {
                this.setExternalDeclImpl(peer.getPublicId(), peer.getSystemId());
                break;
            }
            case 1: {
                this.setInternalTextImpl(peer.getInternalText());
                break;
            }
            case 3: {
                this.setUnparsedDeclImpl(peer.getPublicId(), peer.getSystemId(), peer.getNotationName());
            }
        }
    }

    public final boolean isParameter() {
        return this.parameter;
    }

    private final void setParameterImpl(boolean newParameter) {
        boolean oldParameter = this.parameter;
        this.parameter = newParameter;
        this.firePropertyChange(PROP_PARAMETER, oldParameter ? Boolean.TRUE : Boolean.FALSE, newParameter ? Boolean.TRUE : Boolean.FALSE);
    }

    public final void setParameter(boolean newParameter) throws ReadOnlyException, InvalidStateException, InvalidArgumentException {
        if (this.parameter == newParameter) {
            return;
        }
        this.checkReadOnly();
        if (newParameter && this.type == 3) {
            throw new InvalidStateException(Util.THIS.getString("EXC_ted_parameter_unparsed"));
        }
        this.setParameterImpl(newParameter);
    }

    public final String getName() {
        return this.name;
    }

    private final void setNameImpl(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.firePropertyChange(PROP_NAME, oldName, newName);
    }

    public final void setName(String newName) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.name, newName)) {
            return;
        }
        this.checkReadOnly();
        this.checkName(newName);
        this.setNameImpl(newName);
    }

    protected final void checkName(String name) throws InvalidArgumentException {
        TreeUtilities.checkEntityDeclName(name);
    }

    public final short getType() {
        return this.type;
    }

    public final String getInternalText() {
        return this.internalText;
    }

    private final void setInternalTextImpl(String newInternalText) {
        short oldType = this.type;
        String oldInternalText = this.internalText;
        String oldPublicId = this.publicId;
        String oldSystemId = this.systemId;
        String oldNotationName = this.notationName;
        this.type = 1;
        this.internalText = newInternalText;
        this.publicId = null;
        this.systemId = null;
        this.notationName = null;
        this.firePropertyChange(PROP_TYPE, new Short(oldType), new Short(this.type));
        this.firePropertyChange(PROP_INTERNAL_TEXT, oldInternalText, newInternalText);
        this.firePropertyChange(PROP_PUBLIC_ID, oldPublicId, this.publicId);
        this.firePropertyChange(PROP_SYSTEM_ID, oldSystemId, this.systemId);
        this.firePropertyChange(PROP_NOTATION_NAME, oldNotationName, this.notationName);
    }

    public final void setInternalText(String newInternalText) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.internalText, newInternalText)) {
            return;
        }
        this.checkReadOnly();
        this.checkInternalText(newInternalText);
        this.setInternalTextImpl(newInternalText);
    }

    protected final void checkInternalText(String internalText) throws InvalidArgumentException {
        TreeUtilities.checkEntityDeclInternalText(internalText);
    }

    public final String getPublicId() {
        return this.publicId;
    }

    private final void setPublicIdImpl(String newPublicId) {
        String oldPublicId = this.publicId;
        this.publicId = newPublicId;
        this.firePropertyChange(PROP_PUBLIC_ID, oldPublicId, newPublicId);
    }

    public final void setPublicId(String newPublicId) throws ReadOnlyException, InvalidStateException, InvalidArgumentException {
        if (Util.equals(this.publicId, newPublicId)) {
            return;
        }
        this.checkReadOnly();
        if (this.type == 1) {
            throw new InvalidStateException(Util.THIS.getString("EXC_ted_internal_public"));
        }
        this.checkPublicId(newPublicId);
        this.setPublicIdImpl(newPublicId);
    }

    protected final void checkPublicId(String publicId) throws InvalidArgumentException {
        TreeUtilities.checkEntityDeclPublicId(publicId);
        this.checkExternalId(publicId, this.systemId);
    }

    public final String getSystemId() {
        return this.systemId;
    }

    private final void setSystemIdImpl(String newSystemId) {
        String oldSystemId = this.systemId;
        this.systemId = newSystemId;
        this.firePropertyChange(PROP_SYSTEM_ID, oldSystemId, newSystemId);
    }

    public final void setSystemId(String newSystemId) throws ReadOnlyException, InvalidStateException, InvalidArgumentException {
        if (Util.equals(this.systemId, newSystemId)) {
            return;
        }
        this.checkReadOnly();
        if (this.type == 1) {
            throw new InvalidStateException(Util.THIS.getString("EXC_ted_internal_system"));
        }
        this.checkSystemId(newSystemId);
        this.setSystemIdImpl(newSystemId);
    }

    protected final void checkSystemId(String systemId) throws InvalidArgumentException {
        TreeUtilities.checkEntityDeclSystemId(systemId);
        this.checkExternalId(this.publicId, systemId);
    }

    private final void setExternalDeclImpl(String newPublicId, String newSystemId) {
        short oldType = this.type;
        String oldInternalText = this.internalText;
        String oldPublicId = this.publicId;
        String oldSystemId = this.systemId;
        String oldNotationName = this.notationName;
        this.type = (short)2;
        this.internalText = null;
        this.publicId = newPublicId;
        this.systemId = newSystemId;
        this.notationName = null;
        this.firePropertyChange(PROP_TYPE, new Short(oldType), new Short(this.type));
        this.firePropertyChange(PROP_INTERNAL_TEXT, oldInternalText, this.internalText);
        this.firePropertyChange(PROP_PUBLIC_ID, oldPublicId, newPublicId);
        this.firePropertyChange(PROP_SYSTEM_ID, oldSystemId, newSystemId);
        this.firePropertyChange(PROP_NOTATION_NAME, oldNotationName, this.notationName);
    }

    public final void setExternalDecl(String newPublicId, String newSystemId) throws ReadOnlyException, InvalidArgumentException {
        boolean setSystemId;
        boolean setPublicId = !Util.equals(this.publicId, newPublicId);
        boolean bl = setSystemId = !Util.equals(this.systemId, newSystemId);
        if (!setPublicId && !setSystemId) {
            return;
        }
        this.checkReadOnly();
        this.checkExternalDecl(newPublicId, newSystemId);
        this.setExternalDeclImpl(newPublicId, newSystemId);
    }

    protected final void checkExternalDecl(String publicId, String systemId) throws InvalidArgumentException {
        TreeUtilities.checkEntityDeclPublicId(publicId);
        TreeUtilities.checkEntityDeclSystemId(systemId);
        this.checkExternalId(publicId, systemId);
    }

    public final String getNotationName() {
        return this.notationName;
    }

    private final void setNotationNameImpl(String newNotationName) {
        short oldType = this.type;
        String oldNotationName = this.notationName;
        this.type = newNotationName == null ? (short)2 : (short)3;
        this.notationName = newNotationName;
        this.firePropertyChange(PROP_TYPE, new Short(oldType), new Short(this.type));
        this.firePropertyChange(PROP_NOTATION_NAME, oldNotationName, newNotationName);
    }

    public final void setNotationName(String newNotationName) throws ReadOnlyException, InvalidStateException, InvalidArgumentException {
        if (Util.equals(this.notationName, newNotationName)) {
            return;
        }
        this.checkReadOnly();
        if (this.type == 1) {
            throw new InvalidStateException(Util.THIS.getString("EXC_internal_notation"));
        }
        if (this.parameter) {
            throw new InvalidStateException(Util.THIS.getString("EXC_ted_parameter_unparsed"));
        }
        this.checkNotationName(newNotationName);
        this.setNotationNameImpl(newNotationName);
    }

    protected final void checkNotationName(String notationName) throws InvalidArgumentException {
        TreeUtilities.checkEntityDeclNotationName(notationName);
    }

    private final void setUnparsedDeclImpl(String newPublicId, String newSystemId, String newNotationName) {
        short oldType = this.type;
        String oldInternalText = this.internalText;
        String oldPublicId = this.publicId;
        String oldSystemId = this.systemId;
        String oldNotationName = this.notationName;
        this.type = (short)3;
        this.internalText = null;
        this.publicId = newPublicId;
        this.systemId = newSystemId;
        this.notationName = newNotationName;
        this.firePropertyChange(PROP_TYPE, new Short(oldType), new Short(this.type));
        this.firePropertyChange(PROP_INTERNAL_TEXT, oldInternalText, this.internalText);
        this.firePropertyChange(PROP_PUBLIC_ID, oldPublicId, newPublicId);
        this.firePropertyChange(PROP_SYSTEM_ID, oldSystemId, newSystemId);
        this.firePropertyChange(PROP_NOTATION_NAME, oldNotationName, newNotationName);
    }

    public final void setUnparsedDecl(String newPublicId, String newSystemId, String newNotationName) throws ReadOnlyException, InvalidStateException, InvalidArgumentException {
        boolean setNotationName;
        boolean setPublicId = !Util.equals(this.publicId, newPublicId);
        boolean setSystemId = !Util.equals(this.systemId, newSystemId);
        boolean bl = setNotationName = !Util.equals(this.notationName, newNotationName);
        if (!(setPublicId || setSystemId || setNotationName)) {
            return;
        }
        this.checkReadOnly();
        if (this.parameter) {
            throw new InvalidStateException(Util.THIS.getString("EXC_ted_parameter_unparsed"));
        }
        this.checkUnparsedDecl(newPublicId, newSystemId, newNotationName);
        this.setUnparsedDeclImpl(newPublicId, newSystemId, newNotationName);
    }

    protected final void checkUnparsedDecl(String publicId, String systemId, String notationName) throws InvalidArgumentException {
        TreeUtilities.checkEntityDeclPublicId(publicId);
        TreeUtilities.checkEntityDeclSystemId(systemId);
        this.checkExternalId(publicId, systemId);
        TreeUtilities.checkEntityDeclNotationName(notationName);
        if (notationName == null) {
            throw new InvalidArgumentException(Util.THIS.getString("EXC_ted_unparsed_must_notation"), new NullPointerException());
        }
    }

    protected final void checkExternalId(String publicId, String systemId) throws InvalidArgumentException {
        if (systemId == null) {
            if (publicId == null) {
                throw new InvalidArgumentException(Util.THIS.getString("EXC_ted_system_required"), new NullPointerException());
            }
            throw new InvalidArgumentException(Util.THIS.getString("EXC_ted_system_required"), new NullPointerException());
        }
    }
}

