/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.netbeans.Events;
import org.netbeans.Module;
import org.netbeans.TopSecurityManager;
import org.netbeans.Util;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.NbProblemDisplayer;
import org.netbeans.core.startup.Splash;
import org.netbeans.core.startup.StartLog;
import org.openide.filesystems.FileObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

final class NbEvents
extends Events {
    static /* synthetic */ Class class$org$netbeans$core$startup$NbEvents$Notifier;

    NbEvents() {
    }

    protected void logged(String message, Object[] args) {
        if (message == "perfTick") {
            StartLog.logProgress((String)args[0]);
        } else if (message == "perfStart") {
            StartLog.logStart((String)args[0]);
        } else if (message == "perfEnd") {
            StartLog.logEnd((String)args[0]);
        } else if (message == "startCreateBootModule") {
            Main.addToSplashMaxSteps(1);
        } else if (message == "startLoadBootModules") {
            NbEvents.setStatusText(NbBundle.getMessage((Class)NbEvents.class, (String)"MSG_start_load_boot_modules"));
            StartLog.logStart("ModuleSystem.loadBootModules");
        } else if (message == "startLoad") {
            StartLog.logStart("NbInstaller.load");
        } else if (message == "finishLoadBootModules") {
            NbEvents.setStatusText(NbBundle.getMessage((Class)NbEvents.class, (String)"MSG_finish_load_boot_modules"));
            StartLog.logEnd("ModuleSystem.loadBootModules");
        } else if (message == "finishLoad") {
            StartLog.logEnd("NbInstaller.load");
        } else if (message == "startAutoRestore") {
            Set modules = (Set)args[0];
            if (!modules.isEmpty()) {
                NbEvents.setStatusText(NbBundle.getMessage((Class)NbEvents.class, (String)"MSG_start_auto_restore"));
            }
        } else if (message == "finishAutoRestore") {
            NbEvents.setStatusText(NbBundle.getMessage((Class)NbEvents.class, (String)"MSG_finish_auto_restore"));
        } else if (message == "startEnableModules") {
            NbEvents.setStatusText(NbBundle.getMessage((Class)NbEvents.class, (String)"MSG_start_enable_modules"));
        } else if (message == "finishEnableModules") {
            List modules = (List)args[0];
            if (!modules.isEmpty()) {
                System.err.println(NbBundle.getMessage((Class)NbEvents.class, (String)"TEXT_finish_enable_modules"));
                this.dumpModulesList(modules);
            }
            NbEvents.setStatusText(NbBundle.getMessage((Class)NbEvents.class, (String)"MSG_finish_enable_modules"));
            StartLog.logEnd("ModuleManager.enable");
        } else if (message == "startDisableModules") {
            NbEvents.setStatusText(NbBundle.getMessage((Class)NbEvents.class, (String)"MSG_start_disable_modules"));
        } else if (message == "finishDisableModules") {
            List modules = (List)args[0];
            if (!modules.isEmpty()) {
                System.err.println(NbBundle.getMessage((Class)NbEvents.class, (String)"TEXT_finish_disable_modules"));
                this.dumpModulesList(modules);
            }
            NbEvents.setStatusText(NbBundle.getMessage((Class)NbEvents.class, (String)"MSG_finish_disable_modules"));
        } else if (message == "startDeployTestModule") {
            NbEvents.setStatusText("Deploying test module in " + (File)args[0] + "...");
        } else if (message == "finishDeployTestModule") {
            NbEvents.setStatusText("Finished deploying test module.");
        } else if (message == "failedInstallNew") {
            ArrayList problemTexts = new ArrayList();
            Set modules = (Set)args[0];
            StringBuffer buf = new StringBuffer(NbBundle.getMessage((Class)NbEvents.class, (String)"MSG_failed_install_new"));
            NbProblemDisplayer.problemMessagesForModules(buf, modules, false);
            System.err.println(buf.toString());
            buf = new StringBuffer(NbBundle.getMessage((Class)NbEvents.class, (String)"MSG_failed_install_new"));
            NbProblemDisplayer.problemMessagesForModules(buf, modules, true);
            String msg = buf.toString();
            this.notify(msg, true);
            NbEvents.setStatusText("");
        } else if (message == "failedInstallNewUnexpected") {
            Module m = (Module)args[0];
            StringBuffer buf = new StringBuffer(NbBundle.getMessage((Class)NbEvents.class, (String)"MSG_failed_install_new_unexpected", (Object)m.getDisplayName()));
            NbProblemDisplayer.problemMessagesForModules(buf, Collections.singleton(m), false);
            System.err.println(buf.toString());
            buf = new StringBuffer(NbBundle.getMessage((Class)NbEvents.class, (String)"MSG_failed_install_new_unexpected", (Object)m.getDisplayName()));
            NbProblemDisplayer.problemMessagesForModules(buf, Collections.singleton(m), true);
            this.notify(buf.toString(), true);
            NbEvents.setStatusText("");
        } else if (message == "startRead") {
            NbEvents.setStatusText(NbBundle.getMessage((Class)NbEvents.class, (String)"MSG_start_read"));
            StartLog.logStart("ModuleList.readInitial");
        } else if (message == "modulesFileProcessed") {
            NbEvents.incrementSplashProgressBar();
            if (StartLog.willLog()) {
                StartLog.logProgress("file " + ((FileObject)args[0]).getNameExt() + " processed");
            }
        } else if (message == "finishRead") {
            Set modules = (Set)args[0];
            Main.addToSplashMaxSteps(modules.size() + modules.size());
            NbEvents.setStatusText(NbBundle.getMessage((Class)NbEvents.class, (String)"MSG_finish_read"));
            StartLog.logEnd("ModuleList.readInitial");
        } else if (message == "restore") {
            NbEvents.setStatusText(NbBundle.getMessage((Class)NbEvents.class, (String)"MSG_restore"));
            NbEvents.incrementSplashProgressBar();
        } else if (message == "install") {
            NbEvents.setStatusText(NbBundle.getMessage((Class)NbEvents.class, (String)"MSG_install", (Object)((Module)args[0]).getDisplayName()));
            System.err.println(NbBundle.getMessage((Class)NbEvents.class, (String)"TEXT_install", (Object)((Module)args[0]).getDisplayName()));
            NbEvents.incrementSplashProgressBar();
        } else if (message == "update") {
            NbEvents.setStatusText(NbBundle.getMessage((Class)NbEvents.class, (String)"MSG_update", (Object)((Module)args[0]).getDisplayName()));
            System.err.println(NbBundle.getMessage((Class)NbEvents.class, (String)"TEXT_update", (Object)((Module)args[0]).getDisplayName()));
            NbEvents.incrementSplashProgressBar();
        } else if (message == "uninstall") {
            NbEvents.setStatusText(NbBundle.getMessage((Class)NbEvents.class, (String)"MSG_uninstall", (Object)((Module)args[0]).getDisplayName()));
        } else if (message == "loadSection") {
            NbEvents.setStatusText(NbBundle.getMessage((Class)NbEvents.class, (String)"MSG_load_section"));
        } else if (message == "loadLayers") {
            NbEvents.setStatusText(NbBundle.getMessage((Class)NbEvents.class, (String)"MSG_load_layers"));
        } else if (message == "wrongClassLoader") {
            if (!Boolean.getBoolean("netbeans.moduleitem.dontverifyclassloader") && Util.err.isLoggable(16)) {
                Class clazz = (Class)args[1];
                StringBuffer b = new StringBuffer();
                b.append("The module " + ((Module)args[0]).getDisplayName() + " loaded the class " + clazz.getName() + "\n");
                b.append("from the wrong classloader. The expected classloader was " + args[2] + "\n");
                b.append("whereas it was actually loaded from " + clazz.getClassLoader() + "\n");
                b.append("Usually this means that some classes were in the startup classpath.\n");
                b.append("To suppress this message, run with: -J-Dnetbeans.moduleitem.dontverifyclassloader=true");
                Util.err.log(16, b.toString());
            }
        } else if (message == "extensionMultiplyLoaded") {
            Util.err.log(16, "Warning: the extension " + (File)args[0] + " may be multiply loaded by modules: " + (Set)args[1] + "; see: http://www.netbeans.org/download/dev/javadoc/org-openide-modules/org/openide/modules/doc-files/classpath.html#class-path");
        } else if (message == "missingJarFile") {
            File jar = (File)args[0];
            System.err.println(NbBundle.getMessage((Class)NbEvents.class, (String)"TEXT_missing_jar_file", (Object)jar.getAbsolutePath()));
        } else if (message == "cantDeleteEnabledAutoload") {
            Module m = (Module)args[0];
            System.err.println(NbBundle.getMessage((Class)NbEvents.class, (String)"TEXT_cant_delete_enabled_autoload", (Object)m.getDisplayName()));
        } else if (message == "miscPropMismatch") {
            Module m = (Module)args[0];
            String prop = (String)args[1];
            Object onDisk = args[2];
            Object inMem = args[3];
            System.err.println(NbBundle.getMessage((Class)NbEvents.class, (String)"TEXT_misc_prop_mismatch", (Object[])new Object[]{m.getDisplayName(), prop, onDisk, inMem}));
        } else if (message == "patch") {
            File f = (File)args[0];
            System.err.println(NbBundle.getMessage((Class)NbEvents.class, (String)"TEXT_patch", (Object)f.getAbsolutePath()));
        }
    }

    private void dumpModulesList(Collection modules) {
        Iterator it = modules.iterator();
        if (!it.hasNext()) {
            throw new IllegalArgumentException();
        }
        StringBuffer buf = new StringBuffer(modules.size() * 100 + 1);
        String lineSep = System.getProperty("line.separator");
        while (it.hasNext()) {
            String bv;
            String iv;
            Module m = (Module)it.next();
            buf.append('\t');
            buf.append(m.getCodeName());
            buf.append(" [");
            SpecificationVersion sv = m.getSpecificationVersion();
            if (sv != null) {
                buf.append(sv);
            }
            if ((iv = m.getImplementationVersion()) != null) {
                buf.append(' ');
                buf.append(iv);
            }
            if ((bv = m.getBuildVersion()) != null && !bv.equals(iv)) {
                buf.append(' ');
                buf.append(bv);
            }
            buf.append(']');
            buf.append(lineSep);
        }
        System.err.print(buf.toString());
    }

    private void notify(String text, boolean warn) {
        if (Boolean.getBoolean("netbeans.full.hack")) {
            System.err.println(text);
        } else {
            new Notifier(text, warn);
        }
    }

    private static void incrementSplashProgressBar() {
        Main.incrementSplashProgressBar();
    }

    private static void setStatusText(String msg) {
        Main.setStatusText(msg);
    }

    private static final class Notifier
    implements Runnable {
        private static int questions;
        private boolean warn;
        private String text;
        private static RequestProcessor RP;
        private volatile boolean shown;
        private Object[] options;
        private Object value;

        public Notifier(String text, boolean type) {
            this.warn = type;
            this.text = text;
            RequestProcessor.Task t = RP.post((Runnable)this, 0, 1);
            if (questions++ == 0) {
                this.options = new String[]{NbBundle.getMessage((Class)(class$org$netbeans$core$startup$NbEvents$Notifier == null ? (class$org$netbeans$core$startup$NbEvents$Notifier = NbEvents.class$("org.netbeans.core.startup.NbEvents$Notifier")) : class$org$netbeans$core$startup$NbEvents$Notifier), (String)"MSG_continue"), NbBundle.getMessage((Class)(class$org$netbeans$core$startup$NbEvents$Notifier == null ? (class$org$netbeans$core$startup$NbEvents$Notifier = NbEvents.class$("org.netbeans.core.startup.NbEvents$Notifier")) : class$org$netbeans$core$startup$NbEvents$Notifier), (String)"MSG_exit")};
            }
            if (this.options != null) {
                t.waitFinished();
            }
        }

        public Object getOption() {
            return this.value;
        }

        public void run() {
            this.shown = true;
            int type = this.warn ? 2 : 1;
            String msg = NbBundle.getMessage((Class)(class$org$netbeans$core$startup$NbEvents$Notifier == null ? (class$org$netbeans$core$startup$NbEvents$Notifier = NbEvents.class$("org.netbeans.core.startup.NbEvents$Notifier")) : class$org$netbeans$core$startup$NbEvents$Notifier), (String)(this.warn ? "MSG_warning" : "MSG_info"));
            Splash.SplashOutput out = Main.getSplash();
            Component c = out == null ? null : out.getComponent();
            JTextArea area = new JTextArea();
            area.setText(this.text);
            area.setEditable(false);
            area.setEnabled(true);
            area.setOpaque(false);
            JScrollPane pane = new JScrollPane(area);
            pane.setPreferredSize(new Dimension(pane.getPreferredSize().width + 50, area.getFont().getSize() * 15));
            if (this.options == null) {
                JOptionPane.showMessageDialog(null, pane, msg, type);
            } else {
                int ret = JOptionPane.showOptionDialog(c, pane, msg, 0, type, null, this.options, this.options[1]);
                if (ret == 1 || ret == -1) {
                    TopSecurityManager.exit((int)1);
                }
            }
        }

        static {
            RP = new RequestProcessor("Notify About Module System");
        }
    }
}

