/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.queries;

import java.util.Iterator;
import java.util.regex.Pattern;
import org.netbeans.spi.java.queries.SourceLevelQueryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class SourceLevelQuery {
    private static final Pattern SOURCE_LEVEL = Pattern.compile("\\d+\\.\\d+");
    private static final Lookup.Result implementations = Lookup.getDefault().lookup(new Lookup.Template(SourceLevelQueryImplementation.class));
    static /* synthetic */ Class class$org$netbeans$api$java$queries$SourceLevelQuery;

    private SourceLevelQuery() {
    }

    public static String getSourceLevel(FileObject javaFile) {
        Iterator it = implementations.allInstances().iterator();
        while (it.hasNext()) {
            SourceLevelQueryImplementation sqi = (SourceLevelQueryImplementation)it.next();
            String s = sqi.getSourceLevel(javaFile);
            if (s == null) continue;
            if (!SOURCE_LEVEL.matcher(s).matches()) {
                ErrorManager.getDefault().getInstance((class$org$netbeans$api$java$queries$SourceLevelQuery == null ? SourceLevelQuery.class$("org.netbeans.api.java.queries.SourceLevelQuery") : class$org$netbeans$api$java$queries$SourceLevelQuery).getName()).log(16, "#83994: Ignoring bogus source level " + s + " for " + javaFile + " from " + sqi);
                continue;
            }
            return s;
        }
        return null;
    }
}

