/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.debugger.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import javax.swing.JEditorPane;
import javax.swing.text.Caret;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.ant.debugger.breakpoints.AntBreakpoint;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public class AntBreakpointActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener {
    private static final Set actions = Collections.singleton(ActionsManager.ACTION_TOGGLE_BREAKPOINT);

    public AntBreakpointActionProvider() {
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, true);
        TopComponent.getRegistry().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)TopComponent.getRegistry()));
    }

    public void doAction(Object action) {
        int i;
        Line line = AntBreakpointActionProvider.getCurrentLine();
        if (line == null) {
            return;
        }
        if (!AntBreakpointActionProvider.isAntFile((FileObject)line.getLookup().lookup(FileObject.class))) {
            return;
        }
        Breakpoint[] breakpoints = DebuggerManager.getDebuggerManager().getBreakpoints();
        int k = breakpoints.length;
        for (i = 0; i < k; ++i) {
            if (!(breakpoints[i] instanceof AntBreakpoint) || !((AntBreakpoint)breakpoints[i]).getLine().equals(line)) continue;
            DebuggerManager.getDebuggerManager().removeBreakpoint(breakpoints[i]);
            break;
        }
        if (i == k) {
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)new AntBreakpoint(line));
        }
    }

    public Set getActions() {
        return actions;
    }

    static Line getCurrentLine() {
        Node[] nodes = TopComponent.getRegistry().getCurrentNodes();
        if (nodes == null) {
            return null;
        }
        if (nodes.length != 1) {
            return null;
        }
        Node n = nodes[0];
        LineCookie lineCookie = (LineCookie)n.getCookie(LineCookie.class);
        if (lineCookie == null) {
            return null;
        }
        EditorCookie editorCookie = (EditorCookie)n.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return null;
        }
        JEditorPane[] jEditorPane = editorCookie.getOpenedPanes();
        if (jEditorPane == null || jEditorPane.length < 1) {
            return null;
        }
        StyledDocument document = editorCookie.getDocument();
        if (document == null) {
            return null;
        }
        Caret caret = jEditorPane[0].getCaret();
        if (caret == null) {
            return null;
        }
        int lineNumber = NbDocument.findLineNumber((StyledDocument)document, (int)caret.getDot());
        try {
            return lineCookie.getLineSet().getCurrent(lineNumber);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    private static boolean isAntFile(FileObject fo) {
        if (fo == null) {
            return false;
        }
        return fo.getMIMEType().equals("text/x-ant+xml");
    }

    public void propertyChange(PropertyChangeEvent evt) {
        boolean enabled = true;
        Line line = AntBreakpointActionProvider.getCurrentLine();
        enabled = line == null ? false : AntBreakpointActionProvider.isAntFile((FileObject)line.getLookup().lookup(FileObject.class));
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, enabled);
    }
}

