/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.debugger;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.support.TargetLister;
import org.apache.tools.ant.module.spi.AntEvent;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.ant.debugger.AntDebuggerEngineProvider;
import org.netbeans.modules.ant.debugger.CallStackModel;
import org.netbeans.modules.ant.debugger.IOManager;
import org.netbeans.modules.ant.debugger.Task;
import org.netbeans.modules.ant.debugger.Utils;
import org.netbeans.modules.ant.debugger.VariablesModel;
import org.netbeans.modules.ant.debugger.breakpoints.AntBreakpoint;
import org.netbeans.modules.ant.debugger.breakpoints.BreakpointModel;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.DebuggerEngineProvider;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotatable;
import org.openide.util.RequestProcessor;
import org.openide.util.TaskListener;
import org.w3c.dom.Element;

public class AntDebugger
extends ActionsProviderSupport {
    private static RequestProcessor actionsRequestProcessor;
    private AntProjectCookie antCookie;
    private AntDebuggerEngineProvider engineProvider;
    private ContextProvider contextProvider;
    private ExecutorTask execTask;
    private Object LOCK = new Object();
    private Object LOCK_ACTIONS = new Object();
    private boolean actionRunning = false;
    private IOManager ioManager;
    private Object currentLine;
    private LinkedList callStackList = new LinkedList();
    private File currentFile;
    private String currentTargetName;
    private String currentTaskName;
    private int originatingIndex = -1;
    private static final Set actions;
    private AntEvent lastEvent;
    private Map watches = new HashMap();
    private Object lastAction;
    private Set finishedTasks = new HashSet();
    private String targetEndToStopAt = null;
    private String taskEndToStopAt = null;
    private File fileToStopAt = null;
    private boolean doStop = true;
    private CallStackModel callStackModel;
    private Map nameToTargetByFiles = new HashMap();
    private Map projectNamesByFiles = new HashMap();
    private VariablesModel variablesModel;
    private BreakpointModel breakpointModel;
    private String[] variables = new String[0];

    public AntDebugger(ContextProvider contextProvider) {
        this.contextProvider = contextProvider;
        this.antCookie = (AntProjectCookie)contextProvider.lookupFirst(null, AntProjectCookie.class);
        this.engineProvider = (AntDebuggerEngineProvider)((Object)contextProvider.lookupFirst(null, DebuggerEngineProvider.class));
        Iterator it = actions.iterator();
        while (it.hasNext()) {
            this.setEnabled(it.next(), true);
        }
        this.ioManager = new IOManager(this.antCookie.getFile().getName());
    }

    void setExecutor(ExecutorTask execTask) {
        this.execTask = execTask;
        if (execTask != null) {
            execTask.addTaskListener(new TaskListener(){

                public void taskFinished(org.openide.util.Task task) {
                    AntDebugger.this.finish();
                }
            });
        }
    }

    public Set getActions() {
        return actions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAction(Object action) {
        Object object = this.LOCK_ACTIONS;
        synchronized (object) {
            this.actionRunning = true;
        }
        if (action == ActionsManager.ACTION_KILL) {
            this.finish();
        } else if (action == ActionsManager.ACTION_CONTINUE) {
            this.doContinue();
        } else {
            if (action == ActionsManager.ACTION_START) {
                return;
            }
            if (action == ActionsManager.ACTION_STEP_INTO || action == ActionsManager.ACTION_STEP_OUT || action == ActionsManager.ACTION_STEP_OVER) {
                this.doStep(action);
            }
        }
        object = this.LOCK_ACTIONS;
        synchronized (object) {
            if (this.actionRunning) {
                try {
                    this.LOCK_ACTIONS.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postAction(final Object action, final Runnable actionPerformedNotifier) {
        Iterator it = actions.iterator();
        while (it.hasNext()) {
            this.setEnabled(it.next(), false);
        }
        Class clazz = AntDebugger.class;
        synchronized (clazz) {
            if (actionsRequestProcessor == null) {
                actionsRequestProcessor = new RequestProcessor("Ant debugger actions RP", 1);
            }
        }
        actionsRequestProcessor.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    AntDebugger.this.doAction(action);
                }
                finally {
                    actionPerformedNotifier.run();
                    Iterator it = actions.iterator();
                    while (it.hasNext()) {
                        AntDebugger.this.setEnabled(it.next(), true);
                    }
                }
            }
        });
    }

    void taskStarted(AntEvent event) {
        Object taskLine = Utils.getLine(event);
        this.callStackList.addFirst(new Task(event.getTaskStructure(), taskLine, event.getScriptLocation()));
        this.currentTaskName = event.getTaskStructure().getName();
        this.originatingIndex = 0;
        this.elementStarted(event);
    }

    private void elementStarted(AntEvent event) {
        if (!this.doStop && !this.onBreakpoint()) {
            return;
        }
        this.stopHere(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopHere(AntEvent event) {
        this.lastEvent = event;
        this.updateUI();
        this.currentFile = event.getScriptLocation();
        Set properties = event.getPropertyNames();
        this.variables = properties.toArray(new String[properties.size()]);
        this.getVariablesModel().fireChanges();
        this.getBreakpointModel().fireChanges();
        Object object = this.LOCK_ACTIONS;
        synchronized (object) {
            this.actionRunning = false;
            this.LOCK_ACTIONS.notifyAll();
        }
        object = this.LOCK;
        synchronized (object) {
            try {
                this.LOCK.wait();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    void taskFinished(AntEvent event) {
        this.callStackList.remove(0);
        if (this.taskEndToStopAt != null && this.taskEndToStopAt.equals(event.getTaskStructure().getName()) && event.getScriptLocation().equals(this.fileToStopAt)) {
            if (this.targetEndToStopAt != null) {
                if (this.targetEndToStopAt.equals(event.getTargetName())) {
                    this.targetEndToStopAt = null;
                    this.taskEndToStopAt = null;
                    this.fileToStopAt = null;
                    this.doStop = true;
                }
            } else {
                this.taskEndToStopAt = null;
                this.fileToStopAt = null;
                this.doStop = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void buildFinished(AntEvent event) {
        this.engineProvider.getDestructor().killEngine();
        this.ioManager.closeStream();
        Utils.unmarkCurrent();
        Object object = this.LOCK_ACTIONS;
        synchronized (object) {
            this.actionRunning = false;
            this.LOCK_ACTIONS.notifyAll();
        }
    }

    void targetStarted(AntEvent event) {
        Object topFrame;
        List originatingTargets;
        TargetLister.Target target;
        String targetName;
        block6: {
            block4: {
                String start;
                block8: {
                    block7: {
                        block5: {
                            targetName = event.getTargetName();
                            target = this.findTarget(targetName, event.getScriptLocation());
                            originatingTargets = null;
                            if (this.callStackList.size() <= 0) break block4;
                            topFrame = this.callStackList.get(0);
                            if (!(topFrame instanceof Task)) break block5;
                            Task t1 = (Task)topFrame;
                            String startingTargetName = t1.getTaskStructure().getAttribute("target");
                            if (startingTargetName == null || targetName.equals(startingTargetName)) break block6;
                            originatingTargets = this.findPath(event.getScriptLocation(), startingTargetName, targetName);
                            break block6;
                        }
                        if (!(topFrame instanceof TargetLister.Target)) break block7;
                        String start2 = ((TargetLister.Target)topFrame).getName();
                        LinkedList path = this.findPath(event.getScriptLocation(), start2, targetName);
                        if (path == null) break block6;
                        this.callStackList.removeFirst();
                        originatingTargets = path;
                        break block6;
                    }
                    if (!(topFrame instanceof TargetOriginating)) break block6;
                    start = ((TargetOriginating)topFrame).getOriginatingTarget().getName();
                    if (!start.equals(targetName)) break block8;
                    this.callStackList.removeFirst();
                    --this.originatingIndex;
                    break block6;
                }
                LinkedList path = this.findPath(event.getScriptLocation(), start, targetName);
                if (path == null) break block6;
                this.callStackList.removeFirst();
                originatingTargets = path;
                break block6;
            }
            String[] sessionOriginatingTargets = event.getSession().getOriginatingTargets();
            int l = sessionOriginatingTargets.length;
            for (int i = 0; i < l; ++i) {
                LinkedList path;
                String start = sessionOriginatingTargets[i];
                if (start.equals(targetName) || (path = this.findPath(event.getScriptLocation(), start, targetName)) == null) continue;
                originatingTargets = path;
                break;
            }
        }
        if (originatingTargets != null) {
            this.originatingIndex = originatingTargets.size();
            this.callStackList.addAll(0, originatingTargets);
        } else {
            this.originatingIndex = 0;
        }
        Object v0 = (topFrame = this.callStackList.size() > 0 ? this.callStackList.getFirst() : null);
        if (topFrame instanceof TargetOriginating && ((TargetOriginating)topFrame).getOriginatingTarget().getName().equals(targetName)) {
            this.callStackList.removeFirst();
            --this.originatingIndex;
        }
        this.callStackList.addFirst(target);
        this.currentTargetName = targetName;
        this.currentTaskName = null;
        this.elementStarted(event);
    }

    void targetFinished(AntEvent event) {
        this.callStackList.remove(0);
        if (this.targetEndToStopAt != null && this.targetEndToStopAt.equals(event.getTargetName()) && this.fileToStopAt.equals(event.getScriptLocation())) {
            this.targetEndToStopAt = null;
            this.taskEndToStopAt = null;
            this.fileToStopAt = null;
            this.doStop = true;
        }
        this.currentTargetName = null;
    }

    private Object getTopFrame() {
        Object topFrame = this.originatingIndex > 0 ? this.callStackList.get(this.originatingIndex) : this.callStackList.get(0);
        if (topFrame instanceof TargetOriginating) {
            topFrame = ((TargetOriginating)topFrame).getOriginatingTarget();
        }
        return topFrame;
    }

    private void updateUI() {
        String nextTargetName = null;
        Object topFrame = this.originatingIndex > 0 ? this.callStackList.get(this.originatingIndex) : this.callStackList.get(0);
        if (topFrame instanceof TargetOriginating) {
            TargetLister.Target nextTarget = ((TargetOriginating)topFrame).getDependentTarget();
            nextTargetName = nextTarget.getName();
            topFrame = ((TargetOriginating)topFrame).getOriginatingTarget();
        }
        this.currentLine = topFrame instanceof Task ? ((Task)topFrame).getLine() : Utils.getLine((TargetLister.Target)topFrame, nextTargetName);
        this.updateOutputWindow(this.currentLine);
        Utils.markCurrent(this.currentLine);
        this.getCallStackModel().fireChanges();
    }

    private TargetLister.Target getNextTarget() {
        Object topFrame;
        if (this.originatingIndex > 0 && (topFrame = this.callStackList.get(this.originatingIndex)) instanceof TargetOriginating) {
            return ((TargetOriginating)topFrame).getDependentTarget();
        }
        return null;
    }

    private void updateOutputWindow(Object currentLine) {
        Object topFrame = this.getTopFrame();
        if (topFrame instanceof Task) {
            Task task = (Task)topFrame;
            this.ioManager.println(task.getFile().getName() + ":" + (Utils.getLineNumber(currentLine) + 1) + ": Task " + this.getStackAsString(), currentLine);
        } else {
            TargetLister.Target target = (TargetLister.Target)topFrame;
            this.ioManager.println(target.getScript().getFile().getName() + ":" + (Utils.getLineNumber(currentLine) + 1) + ": Target " + this.getStackAsString(), currentLine);
        }
    }

    private String getStackAsString() {
        StringBuffer sb = new StringBuffer();
        int i = this.callStackList.size() - 1;
        sb.append(AntDebugger.getFrameName(this.callStackList.get(i--)));
        int end = Math.max(0, this.originatingIndex);
        while (i >= end) {
            sb.append('.').append(AntDebugger.getFrameName(this.callStackList.get(i--)));
        }
        return new String(sb);
    }

    private static String getFrameName(Object frame) {
        if (frame instanceof TargetOriginating) {
            frame = ((TargetOriginating)frame).getOriginatingTarget();
        }
        return frame instanceof Task ? ((Task)frame).getTaskStructure().getName() : ((TargetLister.Target)frame).getName();
    }

    private boolean onBreakpoint() {
        Watch[] ws = DebuggerManager.getDebuggerManager().getWatches();
        int jj = ws.length;
        for (int j = 0; j < jj; ++j) {
            Object value = this.getVariableValue(ws[j].getExpression());
            if (value == null) {
                value = new Integer(0);
            }
            if (this.watches.containsKey(ws[j].getExpression()) && !this.watches.get(ws[j].getExpression()).equals(value)) {
                this.watches.put(ws[j].getExpression(), value);
                return true;
            }
            this.watches.put(ws[j].getExpression(), value);
        }
        Breakpoint[] breakpoints = DebuggerManager.getDebuggerManager().getBreakpoints();
        jj = this.callStackList.size();
        if (jj >= 1) {
            Annotatable[] line;
            Object frame = this.callStackList.getFirst();
            if (frame instanceof TargetOriginating) {
                frame = ((TargetOriginating)frame).getOriginatingTarget();
            }
            Object object = line = frame instanceof Task ? ((Task)frame).getLine() : Utils.getLine((TargetLister.Target)frame, null);
            if (line != null) {
                line = new Annotatable[]{((Annotatable[])line)[0]};
            }
            int k = breakpoints.length;
            for (int i = 0; i < k; ++i) {
                if (!(breakpoints[i] instanceof AntBreakpoint) || !breakpoints[i].isEnabled() || !Utils.contains(line, ((AntBreakpoint)breakpoints[i]).getLine())) continue;
                return true;
            }
        }
        return false;
    }

    public Object getCurrentLine() {
        return this.currentLine;
    }

    private void doContinue() {
        Utils.unmarkCurrent();
        this.doStop = false;
        this.targetEndToStopAt = null;
        this.taskEndToStopAt = null;
        this.fileToStopAt = null;
        this.doEngineStep();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStep(Object action) {
        if (action == ActionsManager.ACTION_STEP_INTO) {
            if (this.originatingIndex > 0) {
                --this.originatingIndex;
                this.updateUI();
                Object object = this.LOCK_ACTIONS;
                synchronized (object) {
                    this.actionRunning = false;
                    this.LOCK_ACTIONS.notifyAll();
                }
                return;
            }
            this.doStop = true;
        } else if (action == ActionsManager.ACTION_STEP_OVER) {
            if (this.originatingIndex > 0) {
                Object frame = this.callStackList.get(this.originatingIndex);
                TargetLister.Target dep = ((TargetOriginating)frame).getDependentTarget();
                this.targetEndToStopAt = dep.getName();
                this.taskEndToStopAt = null;
                this.fileToStopAt = this.currentFile;
                this.doStop = false;
            } else {
                this.taskEndToStopAt = this.currentTaskName;
                this.targetEndToStopAt = this.currentTargetName;
                this.fileToStopAt = this.currentFile;
                this.doStop = false;
            }
        } else if (action == ActionsManager.ACTION_STEP_OUT) {
            Object frame;
            if (this.originatingIndex > 1) {
                frame = this.callStackList.get(this.originatingIndex - 1);
                TargetLister.Target dep = ((TargetOriginating)frame).getDependentTarget();
                this.targetEndToStopAt = dep.getName();
                this.taskEndToStopAt = null;
                this.fileToStopAt = this.currentFile;
                this.doStop = false;
            }
            if (this.callStackList.size() > 1) {
                frame = this.callStackList.get(1);
                if (frame instanceof Task) {
                    this.taskEndToStopAt = ((Task)frame).getTaskStructure().getName();
                    for (int i = 2; i < this.callStackList.size(); ++i) {
                        frame = this.callStackList.get(i);
                        if (!(frame instanceof String)) continue;
                        this.targetEndToStopAt = ((TargetLister.Target)frame).getName();
                        break;
                    }
                } else {
                    this.targetEndToStopAt = frame instanceof TargetOriginating ? ((TargetOriginating)frame).getOriginatingTarget().getName() : ((TargetLister.Target)frame).getName();
                }
                this.fileToStopAt = this.currentFile;
                this.doStop = false;
            }
        } else {
            throw new IllegalArgumentException(action.toString());
        }
        this.doEngineStep();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEngineStep() {
        Object object = this.LOCK;
        synchronized (object) {
            this.LOCK.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish() {
        if (this.execTask != null) {
            this.execTask.stop();
        }
        Utils.unmarkCurrent();
        this.doStop = false;
        this.taskEndToStopAt = null;
        this.targetEndToStopAt = null;
        this.fileToStopAt = null;
        Object object = this.LOCK;
        synchronized (object) {
            this.LOCK.notify();
        }
        this.buildFinished(null);
    }

    private CallStackModel getCallStackModel() {
        if (this.callStackModel == null) {
            this.callStackModel = (CallStackModel)this.contextProvider.lookupFirst("CallStackView", TreeModel.class);
        }
        return this.callStackModel;
    }

    Object[] getCallStack() {
        Object[] callStack = this.originatingIndex > 0 ? this.callStackList.subList(this.originatingIndex, this.callStackList.size()).toArray() : this.callStackList.toArray();
        for (int i = 0; i < callStack.length; ++i) {
            if (!(callStack[i] instanceof TargetOriginating)) continue;
            callStack[i] = ((TargetOriginating)callStack[i]).getOriginatingTarget();
        }
        return callStack;
    }

    private LinkedList findPath(File file, String start, String end) {
        TargetLister.Target t = this.findTarget(start, file);
        if (t == null) {
            return null;
        }
        if (start.equals(end)) {
            LinkedList<TargetOriginating> ll = new LinkedList<TargetOriginating>();
            ll.addFirst(new TargetOriginating(null, t));
            return ll;
        }
        String depends = t.getElement().getAttribute("depends");
        StringTokenizer st = new StringTokenizer(depends, ",");
        while (st.hasMoreTokens()) {
            String newStart = st.nextToken().trim();
            LinkedList ll = this.findPath(file, newStart, end);
            if (ll == null) continue;
            TargetOriginating to = (TargetOriginating)ll.getLast();
            if (to.getOriginatingTarget() == null) {
                to.setOriginatingTarget(this.findTarget(start, file));
            } else {
                ll.addLast(new TargetOriginating(this.findTarget(start, file), to.getOriginatingTarget()));
            }
            return ll;
        }
        return null;
    }

    private synchronized TargetLister.Target findTarget(String name, File file) {
        String projName;
        TargetLister.Target target;
        HashMap<String, TargetLister.Target> nameToTarget = (HashMap<String, TargetLister.Target>)this.nameToTargetByFiles.get(file);
        if (nameToTarget == null) {
            DataObject dob;
            nameToTarget = new HashMap<String, TargetLister.Target>();
            FileObject fo = FileUtil.toFileObject((File)file);
            try {
                dob = DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException donfex) {
                throw new IllegalStateException(donfex.getLocalizedMessage());
            }
            AntProjectCookie ant = (AntProjectCookie)dob.getCookie(AntProjectCookie.class);
            Element proj = ant.getProjectElement();
            if (proj != null) {
                String projName2 = proj.getAttribute("name");
                this.projectNamesByFiles.put(file, projName2);
            }
            try {
                Set targets = TargetLister.getTargets((AntProjectCookie)ant);
                Iterator it = targets.iterator();
                while (it.hasNext()) {
                    TargetLister.Target t = (TargetLister.Target)it.next();
                    nameToTarget.put(t.getName(), t);
                }
            }
            catch (IOException ioex) {
                // empty catch block
            }
            this.nameToTargetByFiles.put(file, nameToTarget);
        }
        if ((target = (TargetLister.Target)nameToTarget.get(name)) == null && name.startsWith((projName = (String)this.projectNamesByFiles.get(file)) + ".")) {
            name = name.substring(projName.length() + 1);
            target = (TargetLister.Target)nameToTarget.get(name);
        }
        return target;
    }

    private VariablesModel getVariablesModel() {
        if (this.variablesModel == null) {
            this.variablesModel = (VariablesModel)this.contextProvider.lookupFirst("LocalsView", TreeModel.class);
        }
        return this.variablesModel;
    }

    private BreakpointModel getBreakpointModel() {
        if (this.breakpointModel == null) {
            Iterator it = DebuggerManager.getDebuggerManager().lookup("BreakpointsView", TableModel.class).iterator();
            while (it.hasNext()) {
                TableModel model = (TableModel)it.next();
                if (!(model instanceof BreakpointModel)) continue;
                this.breakpointModel = (BreakpointModel)model;
                break;
            }
        }
        return this.breakpointModel;
    }

    String evaluate(String expression) {
        String value = this.getVariableValue(expression);
        if (value != null) {
            return value;
        }
        if (this.lastEvent == null) {
            return null;
        }
        return this.lastEvent.evaluate(expression);
    }

    String[] getVariables() {
        return this.variables;
    }

    String getVariableValue(String variableName) {
        if (this.lastEvent == null) {
            return null;
        }
        return this.lastEvent.getProperty(variableName);
    }

    static {
        actions = new HashSet();
        actions.add(ActionsManager.ACTION_KILL);
        actions.add(ActionsManager.ACTION_CONTINUE);
        actions.add(ActionsManager.ACTION_START);
        actions.add(ActionsManager.ACTION_STEP_INTO);
        actions.add(ActionsManager.ACTION_STEP_OVER);
        actions.add(ActionsManager.ACTION_STEP_OUT);
    }

    private class TargetOriginating {
        private TargetLister.Target target;
        private TargetLister.Target dependent;

        TargetOriginating(TargetLister.Target target, TargetLister.Target dependent) {
            this.target = target;
            this.dependent = dependent;
        }

        TargetLister.Target getOriginatingTarget() {
            return this.target;
        }

        void setOriginatingTarget(TargetLister.Target target) {
            this.target = target;
        }

        TargetLister.Target getDependentTarget() {
            return this.dependent;
        }
    }
}

