/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.metadata;

import java.beans.Introspector;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Type;

public class JMIClassIntrospector {
    private static final String GET_PREFIX = "get";
    private static final String SET_PREFIX = "set";
    private static final int GET_PREFIX_SIZE = 3;
    private static final int SET_PREFIX_SIZE = 3;
    private static final String IS_PREFIX = "is";
    private static final int IS_PREFIX_SIZE = 2;

    public static boolean isGetter(Method method) {
        String name = method.getName();
        if (name.length() <= 3 && !name.startsWith(IS_PREFIX)) {
            return false;
        }
        String resultTypeName = method.getType().getName();
        List parameters = method.getParameters();
        if (parameters.isEmpty() && !resultTypeName.equals("void") && !Modifier.isStatic(method.getModifiers())) {
            if (name.startsWith(GET_PREFIX)) {
                return Character.isUpperCase(name.charAt(3));
            }
            if (name.startsWith(IS_PREFIX) && (resultTypeName.equals("boolean") || resultTypeName.equals("java.lang.Boolean"))) {
                return Character.isUpperCase(name.charAt(2));
            }
        }
        return false;
    }

    public static boolean isSetter(Method method) {
        String name = method.getName();
        if (name.startsWith(SET_PREFIX)) {
            String resultTypeName = method.getType().getName();
            List parameters = method.getParameters();
            if (parameters.size() == 1 && resultTypeName.equals("void") && !Modifier.isStatic(method.getModifiers())) {
                return Character.isUpperCase(name.charAt(3));
            }
        }
        return false;
    }

    public static String getPropertyNameFromGetter(Method getter) {
        assert (JMIClassIntrospector.isGetter(getter));
        String methodName = getter.getName();
        if (methodName.startsWith(IS_PREFIX)) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        return Introspector.decapitalize(methodName.substring(3));
    }

    public static String getPropertyNameFromSetter(Method setter) {
        assert (JMIClassIntrospector.isSetter(setter));
        String methodName = setter.getName();
        return Introspector.decapitalize(methodName.substring(3));
    }

    public static Method getSetter(Method getter) {
        String getterName = getter.getName();
        String setterName = getterName.startsWith(IS_PREFIX) ? SET_PREFIX + getterName.substring(2) : SET_PREFIX + getterName.substring(3);
        Method setter = getter.getDeclaringClass().getMethod(setterName, Arrays.asList(getter.getType()), true);
        if (setter != null && setter.getType().getName().equals("void") && !Modifier.isStatic(setter.getModifiers())) {
            return setter;
        }
        return null;
    }

    public static Method getGetter(Method setter) {
        assert (JMIClassIntrospector.isSetter(setter));
        String getterName = GET_PREFIX + setter.getName().substring(3);
        Method getter = setter.getDeclaringClass().getMethod(getterName, Collections.emptyList(), true);
        Type setterParamType = ((Parameter)Parameter.class.cast(setter.getParameters().get(0))).getType();
        if (getter == null && setterParamType.getName().equals("boolean")) {
            getterName = IS_PREFIX + setter.getName().substring(3);
            getter = setter.getDeclaringClass().getMethod(getterName, Collections.emptyList(), true);
        }
        if (getter != null && getter.getType().equals(setterParamType) && !Modifier.isStatic(getter.getModifiers())) {
            return getter;
        }
        return null;
    }

    public static String capitalize(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static Method getGetter(Field field) {
        JavaClass javaClass = (JavaClass)field.getDeclaringClass();
        return javaClass.getMethod(GET_PREFIX + JMIClassIntrospector.capitalize(field.getName()), Collections.EMPTY_LIST, false);
    }
}

