/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.streaming;

import com.sun.xml.ws.streaming.XMLReaderException;
import com.sun.xml.ws.streaming.XMLStreamReaderException;
import com.sun.xml.ws.util.FastInfosetReflection;
import com.sun.xml.ws.util.SunStAXReflection;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.xml.sax.InputSource;

public class XMLStreamReaderFactory {
    static XMLInputFactory xmlInputFactory;
    static ThreadLocal fiStreamReader;
    static ThreadLocal xmlStreamReader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLStreamReader createFreshXMLStreamReader(InputSource source, boolean rejectDTDs) {
        try {
            XMLInputFactory xMLInputFactory = xmlInputFactory;
            synchronized (xMLInputFactory) {
                if (source.getCharacterStream() != null) {
                    return xmlInputFactory.createXMLStreamReader(source.getSystemId(), source.getCharacterStream());
                }
                if (source.getByteStream() != null) {
                    return xmlInputFactory.createXMLStreamReader(source.getSystemId(), source.getByteStream());
                }
                return xmlInputFactory.createXMLStreamReader(source.getSystemId(), new URL(source.getSystemId()).openStream());
            }
        }
        catch (Exception e) {
            throw new XMLReaderException("stax.cantCreate", new Object[]{e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLStreamReader createFreshXMLStreamReader(String systemId, InputStream stream) {
        try {
            XMLInputFactory xMLInputFactory = xmlInputFactory;
            synchronized (xMLInputFactory) {
                return xmlInputFactory.createXMLStreamReader(systemId, stream);
            }
        }
        catch (Exception e) {
            throw new XMLReaderException("stax.cantCreate", new Object[]{e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLStreamReader createFreshXMLStreamReader(String systemId, Reader reader) {
        try {
            XMLInputFactory xMLInputFactory = xmlInputFactory;
            synchronized (xMLInputFactory) {
                return xmlInputFactory.createXMLStreamReader(systemId, reader);
            }
        }
        catch (Exception e) {
            throw new XMLReaderException("stax.cantCreate", new Object[]{e});
        }
    }

    public static XMLStreamReader createXMLStreamReader(InputStream in, boolean rejectDTDs) {
        return XMLStreamReaderFactory.createXMLStreamReader(null, in, rejectDTDs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLStreamReader createXMLStreamReader(String systemId, InputStream in, boolean rejectDTDs) {
        try {
            if (SunStAXReflection.XMLReaderImpl_setInputSource != null) {
                Object xsr = xmlStreamReader.get();
                if (xsr == null) {
                    XMLInputFactory xMLInputFactory = xmlInputFactory;
                    synchronized (xMLInputFactory) {
                        xsr = xmlInputFactory.createXMLStreamReader(systemId, in);
                        xmlStreamReader.set(xsr);
                    }
                } else {
                    SunStAXReflection.XMLReaderImpl_reset.invoke(xsr, new Object[0]);
                    InputSource inputSource = new InputSource(in);
                    inputSource.setSystemId(systemId);
                    SunStAXReflection.XMLReaderImpl_setInputSource.invoke(xsr, inputSource);
                }
                return (XMLStreamReader)xsr;
            }
            XMLInputFactory xsr = xmlInputFactory;
            synchronized (xsr) {
                return xmlInputFactory.createXMLStreamReader(systemId, in);
            }
        }
        catch (Exception e) {
            throw new XMLReaderException("stax.cantCreate", new Object[]{e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLStreamReader createXMLStreamReader(Reader reader, boolean rejectDTDs) {
        try {
            if (SunStAXReflection.XMLReaderImpl_setInputSource != null) {
                Object xsr = xmlStreamReader.get();
                if (xsr == null) {
                    XMLInputFactory xMLInputFactory = xmlInputFactory;
                    synchronized (xMLInputFactory) {
                        xsr = xmlInputFactory.createXMLStreamReader(reader);
                        xmlStreamReader.set(xsr);
                    }
                } else {
                    SunStAXReflection.XMLReaderImpl_reset.invoke(xsr, new Object[0]);
                    SunStAXReflection.XMLReaderImpl_setInputSource.invoke(xsr, new InputSource(reader));
                }
                return (XMLStreamReader)xsr;
            }
            XMLInputFactory xsr = xmlInputFactory;
            synchronized (xsr) {
                return xmlInputFactory.createXMLStreamReader(reader);
            }
        }
        catch (Exception e) {
            throw new XMLReaderException("stax.cantCreate", new Object[]{e});
        }
    }

    public static XMLStreamReader createFIStreamReader(InputSource source) {
        return XMLStreamReaderFactory.createFIStreamReader(source.getByteStream());
    }

    public static XMLStreamReader createFIStreamReader(InputStream in) {
        if (FastInfosetReflection.fiStAXDocumentParser_new == null) {
            throw new XMLReaderException("fastinfoset.noImplementation", new Object[0]);
        }
        try {
            Object sdp = fiStreamReader.get();
            if (sdp == null) {
                sdp = FastInfosetReflection.fiStAXDocumentParser_new.newInstance(new Object[0]);
                fiStreamReader.set(sdp);
                FastInfosetReflection.fiStAXDocumentParser_setStringInterning.invoke(sdp, Boolean.TRUE);
            }
            FastInfosetReflection.fiStAXDocumentParser_setInputStream.invoke(sdp, in);
            return (XMLStreamReader)sdp;
        }
        catch (Exception e) {
            throw new XMLStreamReaderException(e);
        }
    }

    static {
        fiStreamReader = new ThreadLocal();
        xmlStreamReader = new ThreadLocal();
        xmlInputFactory = XMLInputFactory.newInstance();
        xmlInputFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        try {
            xmlInputFactory.setProperty("reuse-instance", Boolean.FALSE);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

