/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.model.soap;

import com.sun.xml.bind.api.TypeReference;
import com.sun.xml.messaging.saaj.soap.SOAPVersionMismatchException;
import com.sun.xml.ws.encoding.jaxb.JAXBBridgeInfo;
import com.sun.xml.ws.encoding.jaxb.RpcLitPayload;
import com.sun.xml.ws.encoding.soap.SOAPConstants;
import com.sun.xml.ws.encoding.soap.internal.BodyBlock;
import com.sun.xml.ws.encoding.soap.internal.HeaderBlock;
import com.sun.xml.ws.encoding.soap.internal.InternalMessage;
import com.sun.xml.ws.encoding.soap.message.FaultCode;
import com.sun.xml.ws.encoding.soap.message.FaultCodeEnum;
import com.sun.xml.ws.encoding.soap.message.FaultReason;
import com.sun.xml.ws.encoding.soap.message.FaultReasonText;
import com.sun.xml.ws.encoding.soap.message.FaultSubcode;
import com.sun.xml.ws.encoding.soap.message.SOAP12FaultInfo;
import com.sun.xml.ws.encoding.soap.message.SOAPFaultInfo;
import com.sun.xml.ws.model.CheckedException;
import com.sun.xml.ws.model.JavaMethod;
import com.sun.xml.ws.model.Mode;
import com.sun.xml.ws.model.Parameter;
import com.sun.xml.ws.model.ParameterBinding;
import com.sun.xml.ws.model.RuntimeModel;
import com.sun.xml.ws.model.WrapperParameter;
import com.sun.xml.ws.model.soap.SOAPBinding;
import com.sun.xml.ws.pept.ept.MessageInfo;
import com.sun.xml.ws.server.ServerRtException;
import com.sun.xml.ws.util.MessageInfoUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.soap.SOAPFaultException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPRuntimeModel
extends RuntimeModel {
    @Override
    protected void createDecoderInfo() {
        Collection<JavaMethod> methods = this.getJavaMethods();
        for (JavaMethod m : methods) {
            if (m.isAsync()) continue;
            SOAPBinding binding = (SOAPBinding)m.getBinding();
            this.setDecoderInfo(m.getRequestParameters(), binding, Mode.IN);
            this.setDecoderInfo(m.getResponseParameters(), binding, Mode.OUT);
            for (CheckedException ce : m.getCheckedExceptions()) {
                JAXBBridgeInfo bi = new JAXBBridgeInfo(this.getBridge(ce.getDetailType()));
                this.addDecoderInfo(ce.getDetailType().tagName, bi);
            }
        }
    }

    private void setDecoderInfo(List<Parameter> params, SOAPBinding binding, Mode mode) {
        for (Parameter param : params) {
            ParameterBinding paramBinding;
            ParameterBinding parameterBinding = paramBinding = mode == Mode.IN ? param.getInBinding() : param.getOutBinding();
            if (paramBinding.isBody() && binding.isRpcLit()) {
                RpcLitPayload payload = new RpcLitPayload(param.getName());
                WrapperParameter wp = (WrapperParameter)param;
                for (Parameter p : wp.getWrapperChildren()) {
                    if (p.getBinding().isUnbound()) continue;
                    JAXBBridgeInfo bi = new JAXBBridgeInfo(this.getBridge(p.getTypeReference()), null);
                    payload.addParameter(bi);
                }
                this.addDecoderInfo(param.getName(), payload);
                continue;
            }
            JAXBBridgeInfo bi = new JAXBBridgeInfo(this.getBridge(param.getTypeReference()), null);
            this.addDecoderInfo(param.getName(), bi);
        }
    }

    @Override
    protected void populateMaps() {
        int emptyBodyCount = 0;
        for (JavaMethod jm : this.getJavaMethods()) {
            this.put(jm.getMethod(), jm);
            boolean bodyFound = false;
            for (Parameter p : jm.getRequestParameters()) {
                ParameterBinding binding = p.getBinding();
                if (!binding.isBody()) continue;
                this.put(p.getName(), jm);
                bodyFound = true;
            }
            if (bodyFound) continue;
            this.put(this.emptyBodyName, jm);
            ++emptyBodyCount;
        }
        if (emptyBodyCount > 1) {
            // empty if block
        }
    }

    @Override
    protected void fillTypes(JavaMethod m, List<TypeReference> types) {
        if (!(m.getBinding() instanceof SOAPBinding)) {
            System.out.println("Error: Wrong Binding!");
            return;
        }
        if (((SOAPBinding)m.getBinding()).isDocLit()) {
            super.fillTypes(m, types);
            return;
        }
        this.addTypes(m.getRequestParameters(), types, Mode.IN);
        this.addTypes(m.getResponseParameters(), types, Mode.OUT);
    }

    private void addTypes(List<Parameter> params, List<TypeReference> types, Mode mode) {
        for (Parameter p : params) {
            ParameterBinding binding;
            ParameterBinding parameterBinding = binding = mode == Mode.IN ? p.getInBinding() : p.getOutBinding();
            if (!p.isWrapperStyle()) {
                types.add(p.getTypeReference());
                continue;
            }
            if (!binding.isBody()) continue;
            List<Parameter> wcParams = ((WrapperParameter)p).getWrapperChildren();
            for (Parameter wc : wcParams) {
                types.add(wc.getTypeReference());
            }
        }
    }

    public Set<QName> getKnownHeaders() {
        HashSet<QName> headers = new HashSet<QName>();
        for (JavaMethod method : this.getJavaMethods()) {
            Iterator<Parameter> params = method.getRequestParameters().iterator();
            this.fillHeaders(params, headers, Mode.IN);
            params = method.getResponseParameters().iterator();
            this.fillHeaders(params, headers, Mode.OUT);
        }
        return headers;
    }

    private void fillHeaders(Iterator<Parameter> params, Set<QName> headers, Mode mode) {
        while (params.hasNext()) {
            Parameter param = params.next();
            ParameterBinding binding = mode == Mode.IN ? param.getInBinding() : param.getOutBinding();
            QName name = param.getName();
            if (!binding.isHeader() || headers.contains(name)) continue;
            headers.add(name);
        }
    }

    public static InternalMessage createFaultInBody(Object obj, String actor, Object detail, InternalMessage internalMsg) {
        BodyBlock bodyBlock;
        QName faultCode;
        SOAPFaultInfo faultInfo;
        if (obj instanceof SOAPFaultInfo) {
            faultInfo = (SOAPFaultInfo)obj;
        } else if (obj instanceof ServerRtException) {
            Throwable cause = ((ServerRtException)obj).getCause();
            Throwable th = cause == null ? (ServerRtException)obj : cause;
            faultInfo = SOAPRuntimeModel.createSOAPFaultInfo(th, actor, detail);
        } else if (obj instanceof SOAPFaultException) {
            SOAPFaultException e = (SOAPFaultException)obj;
            faultInfo = new SOAPFaultInfo(e.getFault());
        } else if (obj instanceof SOAPVersionMismatchException) {
            faultCode = SOAPConstants.FAULT_CODE_VERSION_MISMATCH;
            String faultString = "SOAP envelope version mismatch";
            faultInfo = new SOAPFaultInfo(faultString, faultCode, actor, null, "http://schemas.xmlsoap.org/wsdl/soap/http");
        } else if (obj instanceof Exception) {
            faultInfo = SOAPRuntimeModel.createSOAPFaultInfo((Exception)obj, actor, detail);
        } else {
            faultCode = SOAPConstants.FAULT_CODE_SERVER;
            String faultString = "Unknown fault type:" + obj.getClass();
            faultInfo = new SOAPFaultInfo(faultString, faultCode, actor, null, "http://schemas.xmlsoap.org/wsdl/soap/http");
        }
        if (internalMsg == null) {
            internalMsg = new InternalMessage();
        }
        if ((bodyBlock = internalMsg.getBody()) == null) {
            bodyBlock = new BodyBlock(faultInfo);
            internalMsg.setBody(bodyBlock);
        } else {
            bodyBlock.setFaultInfo(faultInfo);
        }
        return internalMsg;
    }

    public static InternalMessage createSOAP12FaultInBody(Object obj, String role, String node, Object detail, InternalMessage im) {
        BodyBlock bodyBlock;
        String faultString;
        SOAP12FaultInfo faultInfo;
        if (obj instanceof SOAP12FaultInfo) {
            faultInfo = (SOAP12FaultInfo)obj;
        } else if (obj instanceof ServerRtException) {
            Throwable cause = ((ServerRtException)obj).getCause();
            Throwable th = cause == null ? (ServerRtException)obj : cause;
            faultInfo = SOAPRuntimeModel.createSOAP12FaultInfo(th, role, node, detail);
        } else if (obj instanceof SOAPFaultException) {
            SOAPFaultException e = (SOAPFaultException)obj;
            faultInfo = new SOAP12FaultInfo(e.getFault());
        } else if (obj instanceof SOAPVersionMismatchException) {
            faultString = "SOAP envelope version mismatch";
            FaultCode code = new FaultCode(FaultCodeEnum.VersionMismatch, (FaultSubcode)null);
            FaultReason reason = new FaultReason(new FaultReasonText(faultString, Locale.getDefault()));
            faultInfo = new SOAP12FaultInfo(code, reason, null, null, null);
        } else if (obj instanceof Exception) {
            faultInfo = SOAPRuntimeModel.createSOAP12FaultInfo((Exception)obj, role, node, detail);
        } else {
            faultString = "Unknown fault type:" + obj.getClass();
            FaultCode code = new FaultCode(FaultCodeEnum.Receiver, (FaultSubcode)null);
            FaultReason reason = new FaultReason(new FaultReasonText(faultString, Locale.getDefault()));
            faultInfo = new SOAP12FaultInfo(code, reason, null, null, null);
        }
        if (im == null) {
            im = new InternalMessage();
        }
        if ((bodyBlock = im.getBody()) == null) {
            bodyBlock = new BodyBlock(faultInfo);
            im.setBody(bodyBlock);
        } else {
            bodyBlock.setValue(faultInfo);
        }
        return im;
    }

    public static void addHeaders(InternalMessage message, MessageInfo mi) {
        Set<HeaderBlock> notUnderstoodHeaders = MessageInfoUtil.getNotUnderstoodHeaders(mi);
        if (notUnderstoodHeaders != null) {
            for (HeaderBlock block : notUnderstoodHeaders) {
                message.addHeader(block);
            }
        }
    }

    private static SOAP12FaultInfo createSOAP12FaultInfo(Throwable e, String role, String node, Object detail) {
        SOAPFaultException soapFaultException = null;
        FaultCode code = null;
        FaultReason reason = null;
        String faultRole = null;
        String faultNode = null;
        Throwable cause = e.getCause();
        if (e instanceof SOAPFaultException) {
            soapFaultException = (SOAPFaultException)e;
        } else if (cause != null && cause instanceof SOAPFaultException) {
            soapFaultException = (SOAPFaultException)e.getCause();
        }
        if (soapFaultException != null) {
            SOAPFault soapFault = soapFaultException.getFault();
            code = new FaultCode(FaultCodeEnum.get(soapFault.getFaultCodeAsQName()), (FaultSubcode)null);
            reason = new FaultReason(new FaultReasonText(soapFault.getFaultString(), soapFault.getFaultStringLocale()));
            faultRole = soapFault.getFaultRole();
            if (faultRole == null) {
                faultRole = role;
            }
            if ((faultNode = soapFault.getFaultNode()) == null) {
                faultNode = node;
            }
        }
        if (code == null || code != null && code.getValue() == null) {
            code = new FaultCode(FaultCodeEnum.Receiver, (FaultSubcode)null);
        }
        if (reason == null) {
            String faultString = e.getMessage();
            if (faultString == null) {
                faultString = e.toString();
            }
            reason = new FaultReason(new FaultReasonText(faultString, Locale.getDefault()));
        }
        if (detail == null && soapFaultException != null) {
            detail = soapFaultException.getFault().getDetail();
        }
        return new SOAP12FaultInfo(code, reason, faultRole, faultNode, detail);
    }

    public static InternalMessage createHeaderFault(Object obj, String actor, JAXBBridgeInfo detailBlock, InternalMessage internalMsg) {
        internalMsg = SOAPRuntimeModel.createFaultInBody(obj, actor, null, internalMsg);
        HeaderBlock hdrBlock = new HeaderBlock(detailBlock);
        internalMsg.addHeader(hdrBlock);
        return internalMsg;
    }

    private static SOAPFaultInfo createSOAPFaultInfo(Throwable e, String actor, Object detail) {
        SOAPFaultException soapFaultException = null;
        QName faultCode = null;
        String faultString = null;
        String faultActor = null;
        Throwable cause = e.getCause();
        if (e instanceof SOAPFaultException) {
            soapFaultException = (SOAPFaultException)e;
        } else if (cause != null && cause instanceof SOAPFaultException) {
            soapFaultException = (SOAPFaultException)e.getCause();
        }
        if (soapFaultException != null) {
            faultCode = soapFaultException.getFault().getFaultCodeAsQName();
            faultString = soapFaultException.getFault().getFaultString();
            faultActor = soapFaultException.getFault().getFaultActor();
        }
        if (faultCode == null) {
            faultCode = SOAPConstants.FAULT_CODE_SERVER;
        }
        if (faultString == null && (faultString = e.getMessage()) == null) {
            faultString = e.toString();
        }
        if (faultActor == null) {
            faultActor = actor;
        }
        if (detail == null && soapFaultException != null) {
            detail = soapFaultException.getFault().getDetail();
        }
        return new SOAPFaultInfo(faultString, faultCode, faultActor, detail, "http://schemas.xmlsoap.org/wsdl/soap/http");
    }
}

