/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.encoding.jaxb;

import com.sun.xml.bind.api.Bridge;
import com.sun.xml.bind.api.BridgeContext;
import com.sun.xml.bind.api.TypeReference;
import com.sun.xml.ws.encoding.soap.DeserializationException;
import com.sun.xml.ws.encoding.soap.SerializationException;
import com.sun.xml.ws.streaming.XMLStreamReaderUtil;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import org.w3c.dom.Node;

public final class JAXBBridgeInfo {
    private final Bridge bridge;
    private Object value;

    public JAXBBridgeInfo(Bridge bridge) {
        this.bridge = bridge;
    }

    public JAXBBridgeInfo(Bridge bridge, Object value) {
        this(bridge);
        this.value = value;
    }

    public QName getName() {
        return this.bridge.getTypeReference().tagName;
    }

    public TypeReference getType() {
        return this.bridge.getTypeReference();
    }

    public Bridge getBridge() {
        return this.bridge;
    }

    public Object getValue() {
        return this.value;
    }

    public static JAXBBridgeInfo copy(JAXBBridgeInfo payload) {
        return new JAXBBridgeInfo(payload.getBridge(), payload.getValue());
    }

    public void serialize(BridgeContext bridgeContext, OutputStream os, NamespaceContext nsContext) {
        try {
            this.bridge.marshal(bridgeContext, this.value, os, nsContext);
        }
        catch (JAXBException e) {
            throw new SerializationException(e);
        }
    }

    public void serialize(BridgeContext bridgeContext, XMLStreamWriter writer) {
        try {
            this.bridge.marshal(bridgeContext, this.value, writer);
        }
        catch (JAXBException e) {
            throw new SerializationException(e);
        }
    }

    public void serialize(BridgeContext bridgeContext, Node node) {
        try {
            this.bridge.marshal(bridgeContext, this.value, node);
        }
        catch (JAXBException e) {
            throw new SerializationException(e);
        }
    }

    public void deserialize(Source source, BridgeContext bridgeContext) {
        try {
            this.value = this.bridge.unmarshal(bridgeContext, source);
        }
        catch (JAXBException e) {
            throw new DeserializationException(e);
        }
    }

    public void deserialize(InputStream stream, BridgeContext bridgeContext) {
        try {
            this.value = this.bridge.unmarshal(bridgeContext, stream);
        }
        catch (JAXBException e) {
            throw new DeserializationException(e);
        }
    }

    public void deserialize(XMLStreamReader reader, BridgeContext bridgeContext) {
        try {
            this.value = this.bridge.unmarshal(bridgeContext, reader);
            if (reader.getEventType() == 4 && reader.isWhiteSpace()) {
                XMLStreamReaderUtil.nextContent(reader);
            }
        }
        catch (JAXBException e) {
            throw new DeserializationException(e);
        }
    }
}

