/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.palette.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import org.netbeans.modules.palette.Category;
import org.netbeans.modules.palette.Utils;
import org.netbeans.modules.palette.ui.AutoscrollSupport;
import org.netbeans.modules.palette.ui.CategoryDescriptor;
import org.netbeans.modules.palette.ui.CategoryList;
import org.openide.nodes.Node;
import org.openide.util.Utilities;

class CategoryButton
extends JCheckBox
implements Autoscroll {
    private static final Icon openedIcon = (Icon)UIManager.get("Tree.expandedIcon");
    private static final Icon closedIcon = (Icon)UIManager.get("Tree.collapsedIcon");
    private static final Color GTK_BK_COLOR = new Color(184, 207, 229);
    private static final Color AQUA_BK_COLOR = new Color(225, 235, 240);
    private static final boolean isGTK = "GTK".equals(UIManager.getLookAndFeel().getID());
    private static final boolean isAqua = "Aqua".equals(UIManager.getLookAndFeel().getID());
    private CategoryDescriptor descriptor;
    private Category category;
    private AutoscrollSupport support;

    CategoryButton(CategoryDescriptor descriptor, Category category) {
        this.descriptor = descriptor;
        this.category = category;
        UIManager.get("nb.propertysheet");
        this.setFont(this.getFont().deriveFont(1));
        this.setMargin(new Insets(0, 3, 0, 3));
        if (this.getBorder() instanceof CompoundBorder) {
            Dimension pref = this.getPreferredSize();
            pref.height -= 3;
            this.setPreferredSize(pref);
        }
        this.setFocusPainted(false);
        this.setSelected(false);
        this.setHorizontalAlignment(2);
        this.setHorizontalTextPosition(4);
        this.setVerticalTextPosition(0);
        this.updateProperties();
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean opened = !CategoryButton.this.descriptor.isOpened();
                CategoryButton.this.setExpanded(opened);
            }
        });
        this.initActions();
    }

    private void initActions() {
        InputMap inputMap = this.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke(40, 0, false), "moveFocusDown");
        inputMap.put(KeyStroke.getKeyStroke(38, 0, false), "moveFocusUp");
        inputMap.put(KeyStroke.getKeyStroke(37, 0, false), "collapse");
        inputMap.put(KeyStroke.getKeyStroke(39, 0, false), "expand");
        inputMap.put(KeyStroke.getKeyStroke(121, 64, false), "popup");
        inputMap.put(KeyStroke.getKeyStroke("ctrl V"), "paste");
        inputMap.put(KeyStroke.getKeyStroke("PASTE"), "paste");
        ActionMap actionMap = this.getActionMap();
        actionMap.put("moveFocusDown", new MoveFocusAction(true));
        actionMap.put("moveFocusUp", new MoveFocusAction(false));
        actionMap.put("collapse", new ExpandAction(false));
        actionMap.put("expand", new ExpandAction(true));
        actionMap.put("popup", new PopupAction());
        Node categoryNode = (Node)this.category.getLookup().lookup(Node.class);
        if (null != categoryNode) {
            actionMap.put("paste", new Utils.PasteItemAction(categoryNode));
        }
    }

    void updateProperties() {
        this.setIcon(closedIcon);
        this.setSelectedIcon(openedIcon);
        this.setText(this.category.getDisplayName());
        this.setToolTipText(this.category.getShortDescription());
    }

    Category getCategory() {
        return this.category;
    }

    public void autoscroll(Point cursorLoc) {
        Point p = SwingUtilities.convertPoint(this, cursorLoc, this.getParent().getParent());
        this.getSupport().autoscroll(p);
    }

    public Insets getAutoscrollInsets() {
        return this.getSupport().getAutoscrollInsets();
    }

    boolean isExpanded() {
        return this.isSelected();
    }

    void setExpanded(boolean expand) {
        this.setSelected(expand);
        this.descriptor.setOpened(expand);
        this.descriptor.getPalettePanel().computeHeights(expand ? this.category : null);
        this.requestFocus();
    }

    AutoscrollSupport getSupport() {
        if (null == this.support) {
            this.support = new AutoscrollSupport(this.getParent().getParent());
        }
        return this.support;
    }

    public Color getBackground() {
        if (this.isFocusOwner()) {
            if (isAqua) {
                return UIManager.getColor("Table.selectionBackground");
            }
            return UIManager.getColor("PropSheet.selectedSetBackground");
        }
        if (isGTK) {
            return GTK_BK_COLOR;
        }
        if (isAqua) {
            return AQUA_BK_COLOR;
        }
        return UIManager.getColor("PropSheet.setBackground");
    }

    public Color getForeground() {
        if (this.isFocusOwner()) {
            if (isAqua) {
                return UIManager.getColor("Table.selectionForeground");
            }
            return UIManager.getColor("PropSheet.selectedSetForeground");
        }
        return super.getForeground();
    }

    private class PopupAction
    extends AbstractAction {
        private PopupAction() {
        }

        public void actionPerformed(ActionEvent e) {
            Action[] actions = CategoryButton.this.category.getActions();
            JPopupMenu popup = Utilities.actionsToPopup((Action[])actions, (Component)CategoryButton.this);
            Utils.addCustomizationMenuItems(popup, CategoryButton.this.descriptor.getPalettePanel().getController(), CategoryButton.this.descriptor.getPalettePanel().getSettings());
            popup.show(CategoryButton.this.getParent(), 0, CategoryButton.this.getHeight());
        }
    }

    private class ExpandAction
    extends AbstractAction {
        private boolean expand;

        public ExpandAction(boolean expand) {
            this.expand = expand;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.expand == CategoryButton.this.isExpanded()) {
                return;
            }
            CategoryButton.this.setExpanded(this.expand);
        }
    }

    private class MoveFocusAction
    extends AbstractAction {
        private boolean moveDown;

        public MoveFocusAction(boolean moveDown) {
            this.moveDown = moveDown;
        }

        public void actionPerformed(ActionEvent e) {
            Component next;
            KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Container container = kfm.getCurrentFocusCycleRoot();
            FocusTraversalPolicy policy = container.getFocusTraversalPolicy();
            if (null == policy) {
                policy = kfm.getDefaultFocusTraversalPolicy();
            }
            Component component = next = this.moveDown ? policy.getComponentAfter(container, CategoryButton.this) : policy.getComponentBefore(container, CategoryButton.this);
            if (null != next && next instanceof CategoryList) {
                if (((CategoryList)next).getModel().getSize() != 0) {
                    ((CategoryList)next).takeFocusFrom(CategoryButton.this);
                    return;
                }
                Component component2 = next = this.moveDown ? policy.getComponentAfter(container, next) : policy.getComponentBefore(container, next);
            }
            if (null != next && next instanceof CategoryButton) {
                next.requestFocus();
            }
        }
    }
}

