/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.palette;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.modules.palette.ui.PalettePanel;
import org.netbeans.spi.palette.PaletteController;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.windows.TopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;

public class PaletteSwitch
implements Runnable,
LookupListener {
    public static final String PROP_PALETTE_CONTENTS = "component_palette_contents";
    private static PaletteSwitch theInstance;
    private PropertyChangeListener registryListener;
    private PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private PaletteController currentPalette = this.findPalette();
    private boolean isGroupOpen = false;
    private TopComponent currentActiveTc;
    private Lookup.Result lookupRes;

    private PaletteSwitch() {
    }

    public static synchronized PaletteSwitch getDefault() {
        if (null == theInstance) {
            theInstance = new PaletteSwitch();
        }
        return theInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startListening() {
        PaletteSwitch paletteSwitch = theInstance;
        synchronized (paletteSwitch) {
            if (null == this.registryListener) {
                this.registryListener = this.createRegistryListener();
                TopComponent.getRegistry().addPropertyChangeListener(this.registryListener);
                this.switchLookupListener();
                this.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopListening() {
        PaletteSwitch paletteSwitch = theInstance;
        synchronized (paletteSwitch) {
            if (null != this.registryListener) {
                TopComponent.getRegistry().removePropertyChangeListener(this.registryListener);
                this.registryListener = null;
                this.currentPalette = null;
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertySupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertySupport.removePropertyChangeListener(l);
    }

    public PaletteController getCurrentPalette() {
        return this.currentPalette;
    }

    public void run() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this);
            return;
        }
        PaletteController oldPalette = this.currentPalette;
        this.currentPalette = this.findPalette();
        this.showHidePaletteTopComponent(oldPalette, this.currentPalette);
        this.propertySupport.firePropertyChange(PROP_PALETTE_CONTENTS, oldPalette, this.currentPalette);
    }

    private PaletteController findPalette() {
        TopComponent.Registry registry = TopComponent.getRegistry();
        PaletteController palette = null;
        TopComponent activeTc = registry.getActivated();
        palette = this.getPaletteFromTopComponent(activeTc);
        ArrayList<PaletteController> availablePalettes = new ArrayList<PaletteController>(3);
        if (null == palette) {
            Set openedTcs = registry.getOpened();
            Iterator i = openedTcs.iterator();
            while (i.hasNext()) {
                TopComponent tc = (TopComponent)i.next();
                palette = this.getPaletteFromTopComponent(tc);
                if (null == palette) continue;
                availablePalettes.add(palette);
            }
            if (null != this.currentPalette && availablePalettes.contains(this.currentPalette)) {
                palette = this.currentPalette;
            } else if (availablePalettes.size() > 0) {
                palette = (PaletteController)availablePalettes.get(0);
            }
        }
        return palette;
    }

    private PaletteController getPaletteFromTopComponent(TopComponent tc) {
        if (null == tc || !tc.isShowing()) {
            return null;
        }
        return (PaletteController)tc.getLookup().lookup(PaletteController.class);
    }

    private void showHidePaletteTopComponent(PaletteController prevPalette, PaletteController newPalette) {
        if (prevPalette == newPalette && null != newPalette) {
            return;
        }
        WindowManager wm = WindowManager.getDefault();
        TopComponentGroup group = wm.findTopComponentGroup("commonpalette");
        if (null == group) {
            return;
        }
        if (null == prevPalette && null != newPalette) {
            group.open();
            this.isGroupOpen = true;
        } else if ((null != prevPalette && null == newPalette || null == prevPalette && null == newPalette) && this.isGroupOpen) {
            PalettePanel.getDefault().setContent(null, null, null);
            group.close();
            this.isGroupOpen = false;
        }
    }

    private void switchLookupListener() {
        TopComponent active = TopComponent.getRegistry().getActivated();
        if (null != this.lookupRes) {
            this.lookupRes.removeLookupListener((LookupListener)this);
            this.lookupRes = null;
        }
        if (null != active) {
            this.lookupRes = active.getLookup().lookup(new Lookup.Template(PaletteController.class));
            this.lookupRes.addLookupListener((LookupListener)this);
            this.lookupRes.allItems();
        }
    }

    private PropertyChangeListener createRegistryListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("currentNodes".equals(evt.getPropertyName()) || "opened".equals(evt.getPropertyName()) || "activated".equals(evt.getPropertyName())) {
                    if ("activated".equals(evt.getPropertyName())) {
                        PaletteSwitch.this.switchLookupListener();
                    }
                    PaletteSwitch.this.run();
                }
            }
        };
    }

    public void resultChanged(LookupEvent ev) {
        this.run();
    }
}

