/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.ActionMap;
import org.netbeans.modules.search.SearchPerformer;
import org.openide.ErrorManager;
import org.openide.actions.FindAction;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Mutex;
import org.openide.util.SharedClassObject;
import org.openide.util.WeakSet;
import org.openide.windows.TopComponent;

final class FindActionManager
implements PropertyChangeListener,
Runnable {
    private static final String MAPPED_FIND_ACTION;
    private static FindActionManager instance;
    private final SearchPerformer performer;
    private final WeakSet activatedOnWindows = new WeakSet(8);
    private Object findActionMapKey;
    static final /* synthetic */ boolean $assertionsDisabled;

    private FindActionManager() {
        this.performer = (SearchPerformer)SharedClassObject.findObject((Class)SearchPerformer.class, (boolean)true);
    }

    static FindActionManager getInstance() {
        if (instance == null) {
            instance = new FindActionManager();
        }
        return instance;
    }

    void init() {
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
        Mutex.EVENT.writeAccess((Runnable)this);
    }

    void cleanup() {
        TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
        Mutex.EVENT.readAccess(new Mutex.Action(){

            public Object run() {
                FindActionManager.this.cleanupWindowRegistry();
                return null;
            }
        });
    }

    public void run() {
        this.someoneActivated();
    }

    private void cleanupWindowRegistry() {
        Object findActionKey = this.getFindActionMapKey();
        Iterator i = this.activatedOnWindows.iterator();
        while (i.hasNext()) {
            Object origFindActionObj;
            TopComponent tc = (TopComponent)i.next();
            Action origFindAction = null;
            Action currFindAction = null;
            Object origFindActionRef = tc.getClientProperty((Object)MAPPED_FIND_ACTION);
            if (origFindActionRef instanceof Reference && (origFindActionObj = ((Reference)origFindActionRef).get()) instanceof Action) {
                origFindAction = (Action)origFindActionObj;
            }
            if (origFindAction != null) {
                currFindAction = tc.getActionMap().get(findActionKey);
            }
            if (currFindAction != null && currFindAction == origFindAction) {
                tc.getActionMap().put(findActionKey, null);
            } else {
                ErrorManager.getDefault().log(16, "ActionMap mapping of FindAction changed for window " + tc.getName());
            }
            if (origFindActionRef == null) continue;
            tc.putClientProperty((Object)MAPPED_FIND_ACTION, null);
        }
        this.activatedOnWindows.clear();
    }

    private void someoneActivated() {
        TopComponent window = TopComponent.getRegistry().getActivated();
        if (window == null || window instanceof CloneableEditorSupport.Pane) {
            return;
        }
        Object key = this.getFindActionMapKey();
        ActionMap actionMap = window.getActionMap();
        if (actionMap.get(key) == null && this.activatedOnWindows.add((Object)window)) {
            Action a = this.performer.createContextAwareInstance(window.getLookup());
            actionMap.put(key, a);
            window.putClientProperty((Object)MAPPED_FIND_ACTION, new WeakReference<Action>(a));
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("activated".equals(evt.getPropertyName())) {
            this.someoneActivated();
        }
    }

    private Object getFindActionMapKey() {
        if (this.findActionMapKey == null) {
            SharedClassObject findAction = SharedClassObject.findObject((Class)FindAction.class);
            if (!$assertionsDisabled && findAction == null) {
                throw new AssertionError();
            }
            this.findActionMapKey = ((FindAction)findAction).getActionMapKey();
        }
        return this.findActionMapKey;
    }

    static {
        $assertionsDisabled = !FindActionManager.class.desiredAssertionStatus();
        MAPPED_FIND_ACTION = FindActionManager.class.getName() + " - FindActionImpl";
    }
}

