/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.models;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class SessionsActionsProvider
implements NodeActionsProvider {
    private static final Action FINISH_ALL_ACTION = new AbstractAction(NbBundle.getBundle((Class)SessionsActionsProvider.class).getString("CTL_SessionAction_FinishAll_Label")){

        public void actionPerformed(ActionEvent e) {
            Session[] ss = DebuggerManager.getDebuggerManager().getSessions();
            int k = ss.length;
            for (int i = 0; i < k; ++i) {
                ss[i].kill();
            }
        }
    };
    private Action MAKE_CURRENT_ACTION = Models.createAction((String)NbBundle.getBundle((Class)SessionsActionsProvider.class).getString("CTL_SessionAction_MakeCurrent_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            return DebuggerManager.getDebuggerManager().getCurrentSession() != node;
        }

        public void perform(Object[] nodes) {
            DebuggerManager.getDebuggerManager().setCurrentSession((Session)nodes[0]);
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    private static final Action FINISH_ACTION = Models.createAction((String)NbBundle.getBundle((Class)SessionsActionsProvider.class).getString("CTL_SessionAction_Finish_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            return true;
        }

        public void perform(Object[] nodes) {
            int k = nodes.length;
            for (int i = 0; i < k; ++i) {
                ((Session)nodes[i]).kill();
            }
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);

    public Action[] getActions(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return new Action[]{FINISH_ALL_ACTION};
        }
        if (node instanceof Session) {
            return new Action[]{this.MAKE_CURRENT_ACTION, FINISH_ACTION, null, FINISH_ALL_ACTION};
        }
        throw new UnknownTypeException(node);
    }

    public void performDefaultAction(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return;
        }
        if (node instanceof Session) {
            if (DebuggerManager.getDebuggerManager().getCurrentSession() == node) {
                return;
            }
            DebuggerManager.getDebuggerManager().setCurrentSession((Session)node);
            return;
        }
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
    }

    public void removeModelListener(ModelListener l) {
    }
}

