/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;

public class BreakpointsTableModel
implements TableModel,
Constants {
    private Map breakpointsBeingEnabled = new HashMap();
    private RequestProcessor rp;
    private Collection modelListeners = new ArrayList();

    public Object getValueAt(Object row, String columnID) throws UnknownTypeException {
        if (columnID.equals("BreakpointEnabled")) {
            if (row instanceof Breakpoint) {
                return ((Breakpoint)row).isEnabled();
            }
            if (row instanceof String) {
                String groupName = (String)row;
                Breakpoint[] bs = DebuggerManager.getDebuggerManager().getBreakpoints();
                Boolean enabled = null;
                for (int i = 0; i < bs.length; ++i) {
                    if (!bs[i].getGroupName().equals(groupName)) continue;
                    if (enabled == null) {
                        enabled = bs[i].isEnabled();
                        continue;
                    }
                    if (enabled.booleanValue() == bs[i].isEnabled()) continue;
                    return null;
                }
                return enabled;
            }
        }
        throw new UnknownTypeException(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReadOnly(Object row, String columnID) throws UnknownTypeException {
        if (row instanceof Breakpoint) {
            if (columnID.equals("BreakpointEnabled")) {
                Map map = this.breakpointsBeingEnabled;
                synchronized (map) {
                    return this.breakpointsBeingEnabled.containsKey(row);
                    {
                    }
                }
            }
        } else if (row instanceof String) {
            return false;
        }
        throw new UnknownTypeException(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueAt(Object row, String columnID, Object value) throws UnknownTypeException {
        if (columnID.equals("BreakpointEnabled")) {
            if (row instanceof Breakpoint) {
                Map map = this.breakpointsBeingEnabled;
                synchronized (map) {
                    this.breakpointsBeingEnabled.put(row, ((Breakpoint)row).isEnabled());
                    if (this.rp == null) {
                        this.rp = new RequestProcessor("Enable Breakpoints RP", 1);
                    }
                }
                this.rp.post((Runnable)new BreakpointEnabler((Breakpoint)row, (Boolean)value));
                return;
            }
            if (row instanceof String) {
                String groupName = (String)row;
                Breakpoint[] bs = DebuggerManager.getDebuggerManager().getBreakpoints();
                ArrayList<Breakpoint> breakpoints = new ArrayList<Breakpoint>();
                for (int i = 0; i < bs.length; ++i) {
                    if (!bs[i].getGroupName().equals(groupName)) continue;
                    breakpoints.add(bs[i]);
                }
                if (breakpoints.size() > 0) {
                    Map map = this.breakpointsBeingEnabled;
                    synchronized (map) {
                        Breakpoint bp;
                        Iterator it = breakpoints.iterator();
                        while (it.hasNext()) {
                            bp = (Breakpoint)it.next();
                            this.breakpointsBeingEnabled.put(bp, bp.isEnabled());
                        }
                        if (this.rp == null) {
                            this.rp = new RequestProcessor("Enable Breakpoints RP", 1);
                        }
                        it = breakpoints.iterator();
                        while (it.hasNext()) {
                            bp = (Breakpoint)it.next();
                            this.rp.post((Runnable)new BreakpointEnabler(bp, (Boolean)value));
                        }
                    }
                }
                return;
            }
        }
        throw new UnknownTypeException(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener l) {
        Collection collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener l) {
        Collection collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireModelEvent(ModelEvent ev) {
        ArrayList listeners;
        Collection collection = this.modelListeners;
        synchronized (collection) {
            listeners = new ArrayList(this.modelListeners);
        }
        Iterator it = listeners.iterator();
        while (it.hasNext()) {
            ModelListener l = (ModelListener)it.next();
            l.modelChanged(ev);
        }
    }

    private class BreakpointEnabler
    implements Runnable {
        private Breakpoint bp;
        private boolean enable;

        public BreakpointEnabler(Breakpoint bp, boolean enable) {
            this.bp = bp;
            this.enable = enable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.enable) {
                this.bp.enable();
            } else {
                this.bp.disable();
            }
            Map map = BreakpointsTableModel.this.breakpointsBeingEnabled;
            synchronized (map) {
                BreakpointsTableModel.this.breakpointsBeingEnabled.remove(this.bp);
            }
            BreakpointsTableModel.this.fireModelEvent((ModelEvent)new ModelEvent.TableValueChanged((Object)BreakpointsTableModel.this, (Object)this.bp, "BreakpointEnabled"));
            String groupName = this.bp.getGroupName();
            if (groupName != null) {
                BreakpointsTableModel.this.fireModelEvent((ModelEvent)new ModelEvent.TableValueChanged((Object)BreakpointsTableModel.this, (Object)groupName, "BreakpointEnabled"));
            }
        }
    }
}

