/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.util.ArrayList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenProcessor;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.ExtUtilities;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCConstructor;
import org.netbeans.editor.ext.java.JCField;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JCMethod;
import org.netbeans.editor.ext.java.JCParameter;
import org.netbeans.editor.ext.java.JCResultItem;
import org.netbeans.editor.ext.java.JCType;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.java.NbJavaSyntaxSupport;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.FieldElement;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.Type;

public class JCExtension {
    public static boolean equals(JCClass cls1, ClassElement cls2) {
        return cls1.getFullName().equals(cls2.getName().getFullName());
    }

    public static boolean equals(JCType typ1, Type typ2) {
        int arrayDepth = 0;
        while (typ2.isArray()) {
            ++arrayDepth;
            typ2 = typ2.getElementType();
        }
        String fn = typ2.isPrimitive() ? typ2.getFullString() : typ2.getClassName().getFullName();
        return typ1.getArrayDepth() == arrayDepth && typ1.getClazz().getFullName().equals(fn);
    }

    public static boolean equals(JCField fld1, FieldElement fld2) {
        return fld1.getName().equals(fld2.getName().getFullName()) && JCExtension.equals(fld1.getType(), fld2.getType());
    }

    public static boolean equals(JCConstructor ctr1, ConstructorElement ctr2) {
        JCParameter[] parms1 = ctr1.getParameters();
        MethodParameter[] parms2 = ctr2.getParameters();
        if (parms2 == null || parms1.length != parms2.length) {
            return false;
        }
        for (int i = parms1.length - 1; i >= 0; --i) {
            if (JCExtension.equals(parms1[i].getType(), parms2[i].getType())) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(JCMethod mtd1, MethodElement mtd2) {
        return mtd1.getName().equals(mtd2.getName().getFullName()) && JCExtension.equals((JCConstructor)mtd1, (ConstructorElement)mtd2);
    }

    public static FieldElement findFieldElement(JCField fld, ClassElement ce) {
        FieldElement[] fes = ce.getFields();
        if (fes != null) {
            for (int i = 0; i < fes.length; ++i) {
                if (!JCExtension.equals(fld, fes[i])) continue;
                return fes[i];
            }
        }
        return null;
    }

    public static ConstructorElement findConstructorElement(JCConstructor ctr, ClassElement ce) {
        ConstructorElement[] ces = ce.getConstructors();
        if (ces != null) {
            for (int i = 0; i < ces.length; ++i) {
                if (!JCExtension.equals(ctr, ces[i])) continue;
                return ces[i];
            }
        }
        return null;
    }

    public static MethodElement findMethodElement(JCMethod mtd, ClassElement ce) {
        MethodElement[] mes = ce.getMethods();
        if (mes != null) {
            for (int i = 0; i < mes.length; ++i) {
                if (!JCExtension.equals(mtd, mes[i])) continue;
                return mes[i];
            }
        }
        return null;
    }

    public static ClassPath getFullClassPath(FileObject context) {
        ArrayList<ClassPath> l = new ArrayList<ClassPath>();
        ClassPath cp = ClassPath.getClassPath((FileObject)context, (String)"classpath/source");
        if (cp != null) {
            l.add(cp);
        }
        if ((cp = ClassPath.getClassPath((FileObject)context, (String)"classpath/compile")) != null) {
            l.add(cp);
        }
        if ((cp = ClassPath.getClassPath((FileObject)context, (String)"classpath/boot")) != null) {
            l.add(cp);
        }
        return ClassPathSupport.createProxyClassPath((ClassPath[])l.toArray(new ClassPath[l.size()]));
    }

    static JCClass findResultInnerClass(JCFinder finder, JCClass topClass, String innerClsName, Document doc) {
        if (topClass == null || innerClsName == null) {
            return null;
        }
        ClassElement ce = ClassElement.forName((String)topClass.getFullName(), (FileObject)NbEditorUtilities.getDataObject((Document)doc).getPrimaryFile());
        if (ce == null) {
            return null;
        }
        ClassElement[] innerClasses = ce.getClasses();
        if (innerClsName != null) {
            for (int i = 0; i < innerClasses.length; ++i) {
                JCClass innerCls;
                if (!innerClsName.equals(innerClasses[i].getName().getName()) && !innerClsName.equals(innerClasses[i].getName().getFullName()) || (innerCls = finder.getExactClass(innerClasses[i].getName().getFullName())) == null) continue;
                return innerCls;
            }
        }
        return null;
    }

    static int findEndOfMethod(JTextComponent textComp, int startPos) {
        return JCExtension.findEndOfMethod((BaseDocument)textComp.getDocument(), startPos);
    }

    static int findEndOfMethod(BaseDocument doc, int startPos) {
        ExtSyntaxSupport ssup = (ExtSyntaxSupport)doc.getSyntaxSupport();
        ClosingParenProcessor tp = new ClosingParenProcessor();
        try {
            ssup.tokenizeText((TokenProcessor)tp, startPos, doc.getLength(), false);
        }
        catch (BadLocationException ex) {
            // empty catch block
        }
        return tp.getClosingParenOffset();
    }

    private static Object findImportedItem(NbJavaSyntaxSupport nbJavaSup, CompletionQuery.Result result) {
        return JCExtension.findImportedItem(nbJavaSup, result, null);
    }

    private static Object findImportedItem(NbJavaSyntaxSupport nbJavaSup, CompletionQuery.Result result, String wordAtCaret) {
        nbJavaSup.refreshJavaImport();
        String sourcePkg = nbJavaSup.getPackage();
        for (int x = 0; x < result.getData().size(); ++x) {
            Object itemObj = result.getData().get(x);
            if (itemObj instanceof JCResultItem) {
                itemObj = ((JCResultItem)itemObj).getAssociatedObject();
            }
            if (!(itemObj instanceof JCClass)) continue;
            JCClass cls = (JCClass)itemObj;
            String itemPkg = cls.getPackageName();
            if (!nbJavaSup.isImported(cls) && !sourcePkg.equals(itemPkg) || wordAtCaret != null && !wordAtCaret.equals(cls.getName())) continue;
            Object itmx = result.getData().get(x);
            if (itmx instanceof JCResultItem) {
                itmx = ((JCResultItem)itmx).getAssociatedObject();
            }
            return itmx;
        }
        return null;
    }

    private static Object findResultInnerItem(NbJavaSyntaxSupport nbJavaSup, CompletionQuery.Result result, Document doc) {
        ClassElement ce;
        JCClass topClass = nbJavaSup.getTopClass();
        if (topClass != null && (ce = ClassElement.forName((String)topClass.getFullName(), (FileObject)NbEditorUtilities.getDataObject((Document)doc).getPrimaryFile())) != null) {
            ClassElement[] innerClasses = ce.getClasses();
            for (int i = 0; i < result.getData().size(); ++i) {
                JCField fld;
                int j;
                JCClass innerClass;
                JCClass clz;
                Object itmx = result.getData().get(i);
                if (itmx instanceof JCResultItem) {
                    itmx = ((JCResultItem)itmx).getAssociatedObject();
                }
                if (itmx instanceof JCClass) {
                    return JCExtension.findResultInnerClass(nbJavaSup.getFinder(), topClass, ((JCClass)itmx).getFullName(), doc);
                }
                if (itmx instanceof JCMethod) {
                    JCMethod mtd = (JCMethod)itmx;
                    clz = mtd.getClazz();
                    if (clz == null || (innerClass = JCExtension.findResultInnerClass(nbJavaSup.getFinder(), topClass, clz.getFullName(), doc)) == null) continue;
                    JCMethod[] methods = innerClass.getMethods();
                    for (j = 0; j < methods.length; ++j) {
                        if (!methods[j].equals(mtd)) continue;
                        return methods[j];
                    }
                }
                if (itmx instanceof JCConstructor) {
                    JCConstructor constructor = (JCConstructor)itmx;
                    clz = constructor.getClazz();
                    if (clz == null || (innerClass = JCExtension.findResultInnerClass(nbJavaSup.getFinder(), topClass, clz.getFullName(), doc)) == null) continue;
                    JCConstructor[] constructors = innerClass.getConstructors();
                    for (j = 0; j < constructors.length; ++j) {
                        if (!constructors[j].equals(constructor)) continue;
                        return constructors[j];
                    }
                    return innerClass;
                }
                if (!(itmx instanceof JCField) || (clz = (fld = (JCField)itmx).getClazz()) == null || (innerClass = JCExtension.findResultInnerClass(nbJavaSup.getFinder(), topClass, clz.getFullName(), doc)) == null) continue;
                JCField[] fields = innerClass.getFields();
                for (j = 0; j < fields.length; ++j) {
                    if (!fields[j].equals(fld)) continue;
                    return fields[j];
                }
            }
        }
        return null;
    }

    public static Object findItemAtCaretPos(JTextComponent target) {
        Object item = null;
        Completion completion = ExtUtilities.getCompletion((JTextComponent)target);
        SyntaxSupport sup = Utilities.getSyntaxSupport((JTextComponent)target);
        NbJavaSyntaxSupport nbJavaSup = (NbJavaSyntaxSupport)sup.get(NbJavaSyntaxSupport.class);
        if (completion != null) {
            if (completion.isPaneVisible()) {
                item = completion.getSelectedValue();
                if (item instanceof JCResultItem) {
                    item = ((JCResultItem)item).getAssociatedObject();
                }
                if (item != null) {
                    return item;
                }
            } else {
                try {
                    int dotPos = target.getCaret().getDot();
                    BaseDocument doc = (BaseDocument)target.getDocument();
                    int[] idFunBlk = NbEditorUtilities.getIdentifierAndMethodBlock((BaseDocument)doc, (int)dotPos);
                    if (idFunBlk == null || dotPos > 0 && doc.getChars(dotPos - 1, 1)[0] == '(' && dotPos == idFunBlk[0]) {
                        idFunBlk = new int[]{dotPos, dotPos};
                    }
                    for (int ind = idFunBlk.length - 1; ind >= 1; --ind) {
                        Object itmx;
                        CompletionQuery.Result resultx;
                        int endOfMethod;
                        CompletionQuery.Result result = completion.getQuery().query(target, idFunBlk[ind], sup);
                        if (result == null || result.getData().size() <= 0) continue;
                        Object itm = result.getData().get(0);
                        if (itm instanceof JCResultItem) {
                            itm = ((JCResultItem)itm).getAssociatedObject();
                        }
                        if ((itm instanceof JCConstructor || itm instanceof JCMethod) && result.getData().size() > 1 && (endOfMethod = JCExtension.findEndOfMethod(target, idFunBlk[ind])) > -1 && (resultx = completion.getQuery().query(target, endOfMethod, sup)) != null && resultx.getData().size() > 0) {
                            itmx = resultx.getData().get(0);
                            if (itmx instanceof JCResultItem) {
                                itmx = ((JCResultItem)itmx).getAssociatedObject();
                            }
                            return itmx;
                        }
                        Object innerClassItem = JCExtension.findResultInnerItem(nbJavaSup, result, (Document)doc);
                        if (innerClassItem != null) {
                            return innerClassItem;
                        }
                        Object importedItem = JCExtension.findImportedItem(nbJavaSup, result);
                        if (importedItem != null) {
                            return importedItem;
                        }
                        itmx = result.getData().get(0);
                        if (!(itmx instanceof JCResultItem)) continue;
                        return ((JCResultItem)itmx).getAssociatedObject();
                    }
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private static final class ClosingParenProcessor
    implements TokenProcessor {
        private int bufferStartOffset;
        private int level = 0;
        private int closingParenOffset = -1;

        private ClosingParenProcessor() {
        }

        public int eot(int offset) {
            return 0;
        }

        public void nextBuffer(char[] buffer, int offset, int len, int startPos, int preScan, boolean lastBuffer) {
            this.bufferStartOffset = startPos - offset;
        }

        public boolean token(TokenID tokenID, TokenContextPath tokenContextPath, int tokenBufferOffset, int tokenLength) {
            int offset = this.bufferStartOffset + tokenBufferOffset;
            switch (tokenID.getNumericID()) {
                case 53: {
                    ++this.level;
                    break;
                }
                case 54: {
                    if (this.level == 0) {
                        this.closingParenOffset = offset + 1;
                        return false;
                    }
                    --this.level;
                    break;
                }
                case 51: {
                    return false;
                }
            }
            return true;
        }

        public int getClosingParenOffset() {
            return this.closingParenOffset;
        }
    }
}

