/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.wizard;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.i18n.FactoryRegistry;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.wizard.SourceData;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

final class Util
extends org.netbeans.modules.i18n.Util {
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$loaders$DataObject$Container;

    Util() {
    }

    public static String getString(String key) {
        return NbBundle.getMessage((Class)Util.class, (String)key);
    }

    public static char getChar(String key) {
        return Util.getString(key).charAt(0);
    }

    public static Map createWizardSourceMap() {
        return new TreeMap(new DataObjectComparator());
    }

    public static Map createWizardSourceMap(Node[] activatedNodes) {
        Map sourceMap = Util.createWizardSourceMap();
        if (activatedNodes != null && activatedNodes.length > 0) {
            VisibilityQuery visQuery = VisibilityQuery.getDefault();
            for (int i = 0; i < activatedNodes.length; ++i) {
                DataObject dobj = (DataObject)activatedNodes[i].getCookie(class$org$openide$loaders$DataObject == null ? Util.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                if (dobj != null && !visQuery.isVisible(dobj.getPrimaryFile())) continue;
                DataObject.Container container = (DataObject.Container)activatedNodes[i].getCookie(class$org$openide$loaders$DataObject$Container == null ? Util.class$("org.openide.loaders.DataObject$Container") : class$org$openide$loaders$DataObject$Container);
                if (container != null) {
                    Iterator it = I18nUtil.getAcceptedDataObjects(container).iterator();
                    while (it.hasNext()) {
                        Util.addSource(sourceMap, (DataObject)it.next());
                    }
                }
                if (dobj == null || !FactoryRegistry.hasFactory(dobj.getClass())) continue;
                Util.addSource(sourceMap, dobj);
            }
        }
        return sourceMap;
    }

    public static void addSource(Map sourceMap, DataObject source) {
        if (sourceMap.containsKey(source)) {
            return;
        }
        DataFolder folder = source.getFolder();
        if (folder == null) {
            sourceMap.put(source, null);
            return;
        }
        DataObject[] children = folder.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof PropertiesDataObject)) continue;
            sourceMap.put(source, new SourceData(children[i]));
            return;
        }
        sourceMap.put(source, null);
    }

    static boolean wizardEnabled(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length == 0) {
            return false;
        }
        for (int i = 0; i < activatedNodes.length; ++i) {
            Node.Cookie container;
            DataObject dobj = null;
            Node node = activatedNodes[i];
            Node.Cookie o = node.getCookie(class$org$openide$loaders$DataObject == null ? Util.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
            if (o != null) {
                boolean isLocal;
                dobj = (DataObject)o;
                FileObject primaryFile = dobj.getPrimaryFile();
                try {
                    isLocal = !primaryFile.isVirtual() && primaryFile.isValid() && primaryFile.getURL().getProtocol().equals("file");
                }
                catch (FileStateInvalidException ex) {
                    isLocal = false;
                }
                if (!isLocal) {
                    return false;
                }
            }
            if ((container = node.getCookie(class$org$openide$loaders$DataObject$Container == null ? Util.class$("org.openide.loaders.DataObject$Container") : class$org$openide$loaders$DataObject$Container)) != null) continue;
            if (dobj == null) {
                return false;
            }
            if (FileOwnerQuery.getOwner((FileObject)dobj.getPrimaryFile()) != null) continue;
            return false;
        }
        return true;
    }

    private static class DataObjectComparator
    implements Comparator {
        private DataObjectComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof DataObject) || !(o2 instanceof DataObject)) {
                return 0;
            }
            DataObject d1 = (DataObject)o1;
            DataObject d2 = (DataObject)o2;
            if (d1 == d2) {
                return 0;
            }
            if (d1 == null) {
                return -1;
            }
            if (d2 == null) {
                return 1;
            }
            return d1.getPrimaryFile().getPath().compareTo(d2.getPrimaryFile().getPath());
        }

        public boolean equals(Object obj) {
            return this == obj;
        }
    }
}

