/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.i18n.HardCodedString;
import org.netbeans.modules.i18n.I18nSupport;
import org.netbeans.modules.i18n.wizard.I18nWizardDescriptor;
import org.netbeans.modules.i18n.wizard.ProgressWizardPanel;
import org.netbeans.modules.i18n.wizard.SourceData;
import org.netbeans.modules.i18n.wizard.SourceWizardPanel;
import org.netbeans.modules.i18n.wizard.Util;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class AdditionalWizardPanel
extends JPanel {
    private final Map sourceMap = Util.createWizardSourceMap();
    private final Set viewedSources = new HashSet(0);
    private JComponent additionalComponent = EMPTY_COMPONENT;
    private static final JLabel EMPTY_COMPONENT = new JLabel(Util.getString("TXT_HasNoAdditonal"));
    private JComboBox sourceCombo;
    private JLabel sourceLabel;

    private AdditionalWizardPanel() {
        this.initComponents();
        this.initA11Y();
        this.setComboModel(this.sourceMap);
    }

    private void initA11Y() {
        this.sourceLabel.setLabelFor(this.sourceCombo);
        this.sourceLabel.setDisplayedMnemonic(Util.getString("LBL_Source_Mnem").charAt(0));
        this.sourceCombo.getAccessibleContext().setAccessibleDescription(Util.getString("ACS_sourceCombo"));
    }

    private void setComboModel(Map sourceMap) {
        Object[] sources = sourceMap.keySet().toArray();
        ArrayList<Object> nonEmptySources = new ArrayList<Object>();
        for (int i = 0; i < sources.length; ++i) {
            if (!((SourceData)sourceMap.get(sources[i])).getSupport().hasAdditionalCustomizer()) continue;
            nonEmptySources.add(sources[i]);
        }
        this.sourceCombo.setModel(new DefaultComboBoxModel<Object>(nonEmptySources.toArray()));
        Object selected = this.sourceCombo.getSelectedItem();
        this.updateAdditionalComponent(selected);
    }

    Set getViewedSources() {
        return this.viewedSources;
    }

    Map getSourceMap() {
        return this.sourceMap;
    }

    void setSourceMap(Map sourceMap) {
        this.sourceMap.clear();
        this.sourceMap.putAll(sourceMap);
        this.setComboModel(sourceMap);
    }

    private void initComponents() {
        this.sourceLabel = new JLabel();
        this.sourceCombo = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.sourceLabel.setText(NbBundle.getBundle((Class)AdditionalWizardPanel.class).getString("LBL_Source"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.add((Component)this.sourceLabel, gridBagConstraints);
        this.sourceCombo.setRenderer(new SourceWizardPanel.DataObjectListCellRenderer());
        this.sourceCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdditionalWizardPanel.this.sourceComboActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 11, 0, 0);
        this.add((Component)this.sourceCombo, gridBagConstraints);
    }

    private void sourceComboActionPerformed(ActionEvent evt) {
        Object selected = this.sourceCombo.getSelectedItem();
        this.updateAdditionalComponent(selected);
    }

    private void updateAdditionalComponent(Object selected) {
        I18nSupport support = null;
        if (selected != null) {
            support = ((SourceData)this.sourceMap.get(selected)).getSupport();
        }
        this.remove(this.additionalComponent);
        if (support != null && support.hasAdditionalCustomizer()) {
            this.additionalComponent = support.getAdditionalCustomizer();
            this.viewedSources.add(selected);
        } else {
            this.additionalComponent = EMPTY_COMPONENT;
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.additionalComponent, gridBagConstraints);
        this.revalidate();
    }

    public static class Panel
    extends I18nWizardDescriptor.Panel {
        private final JLabel emptyLabel = new JLabel(Util.getString("TXT_HasNoAdditonal"));
        private transient AdditionalWizardPanel additionalPanel;

        Panel() {
            this.emptyLabel.setHorizontalAlignment(0);
            this.emptyLabel.setVerticalAlignment(0);
        }

        protected Component createComponent() {
            JPanel panel = new JPanel();
            panel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$AdditionalWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$AdditionalWizardPanel = AdditionalWizardPanel.class$("org.netbeans.modules.i18n.wizard.AdditionalWizardPanel")) : class$org$netbeans$modules$i18n$wizard$AdditionalWizardPanel)).getString("ACS_AdditionalWizardPanel"));
            panel.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(2));
            panel.setName(NbBundle.getBundle(this.getClass()).getString("TXT_ModifyAdditional"));
            panel.setPreferredSize(I18nWizardDescriptor.PREFERRED_DIMENSION);
            panel.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.fill = 1;
            panel.add((Component)this.getUI(), constraints);
            return panel;
        }

        public void readSettings(Object settings) {
            super.readSettings(settings);
            this.getUI().setSourceMap(this.getMap());
            JPanel panel = (JPanel)this.getComponent();
            if (Panel.hasAdditional(this.getMap())) {
                if (panel.isAncestorOf(this.emptyLabel)) {
                    panel.remove(this.emptyLabel);
                    GridBagConstraints constraints = new GridBagConstraints();
                    constraints.weightx = 1.0;
                    constraints.weighty = 1.0;
                    constraints.fill = 1;
                    panel.add((Component)this.getUI(), constraints);
                }
            } else if (panel.isAncestorOf(this.getUI())) {
                panel.remove(this.getUI());
                GridBagConstraints constraints = new GridBagConstraints();
                constraints.weightx = 1.0;
                constraints.weighty = 1.0;
                constraints.fill = 1;
                panel.add((Component)this.emptyLabel, constraints);
            }
        }

        public void storeSettings(Object settings) {
            super.storeSettings(settings);
            Map sourceMap = this.getUI().getSourceMap();
            Iterator it = this.getUI().getViewedSources().iterator();
            while (it.hasNext()) {
                SourceData sourceData = (SourceData)sourceMap.get(it.next());
                Object[] hcStrings = sourceData.getStringMap().keySet().toArray();
                for (int i = 0; i < hcStrings.length; ++i) {
                    sourceData.getStringMap().put(hcStrings[i], sourceData.getSupport().getDefaultI18nString((HardCodedString)hcStrings[i]));
                }
            }
            this.getMap().clear();
            this.getMap().putAll(sourceMap);
        }

        public void doLongTimeChanges() {
            ProgressWizardPanel progressPanel = new ProgressWizardPanel(true);
            this.showProgressPanel(progressPanel);
            progressPanel.setMainText(NbBundle.getBundle(this.getClass()).getString("LBL_AdditionalIn"));
            progressPanel.setMainProgress(0);
            Map sourceMap = ((AdditionalWizardPanel)this.getComponent()).getSourceMap();
            Iterator it = ((AdditionalWizardPanel)this.getComponent()).getViewedSources().iterator();
            int i = 0;
            while (it.hasNext()) {
                DataObject source = (DataObject)it.next();
                SourceData sourceData = (SourceData)sourceMap.get(source);
                ClassPath cp = ClassPath.getClassPath((FileObject)source.getPrimaryFile(), (String)"classpath/source");
                progressPanel.setMainText(NbBundle.getBundle(this.getClass()).getString("LBL_AdditionalIn") + " " + cp.getResourceName(source.getPrimaryFile(), '.', false));
                Object[] hcStrings = sourceData.getStringMap().keySet().toArray();
                int j = 0;
                while (i < hcStrings.length) {
                    sourceData.getStringMap().put(hcStrings[j], sourceData.getSupport().getDefaultI18nString((HardCodedString)hcStrings[j]));
                    ++j;
                }
                progressPanel.setMainProgress((int)((float)(i + 1) / (float)sourceMap.size() * 100.0f));
                ++i;
            }
        }

        private void showProgressPanel(ProgressWizardPanel progressPanel) {
            ((Container)this.getComponent()).remove(this.getUI());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.fill = 1;
            ((Container)this.getComponent()).add((Component)progressPanel, constraints);
            ((JComponent)this.getComponent()).revalidate();
            this.getComponent().repaint();
        }

        public void reset() {
            Container container = (Container)this.getComponent();
            if (!container.isAncestorOf(this.getUI())) {
                container.removeAll();
                GridBagConstraints constraints = new GridBagConstraints();
                constraints.weightx = 1.0;
                constraints.weighty = 1.0;
                constraints.fill = 1;
                container.add((Component)this.getUI(), constraints);
            }
        }

        public HelpCtx getHelp() {
            return new HelpCtx("internation.wizard");
        }

        private static boolean hasAdditional(Map sourceMap) {
            Iterator it = sourceMap.keySet().iterator();
            while (it.hasNext()) {
                SourceData sourceData = (SourceData)sourceMap.get(it.next());
                if (!sourceData.getSupport().hasAdditionalCustomizer()) continue;
                return true;
            }
            return false;
        }

        private synchronized AdditionalWizardPanel getUI() {
            if (this.additionalPanel == null) {
                this.additionalPanel = new AdditionalWizardPanel();
            }
            return this.additionalPanel;
        }
    }
}

