/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jmi.reflect.JmiException;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.beans.BeanPatternGenerator;
import org.netbeans.modules.beans.JMIUtils;
import org.netbeans.modules.beans.Pattern;
import org.netbeans.modules.beans.PatternAnalyser;
import org.netbeans.modules.beans.PatternNode;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.Utilities;

public final class EventSetPattern
extends Pattern {
    static final String[] WELL_KNOWN_LISTENERS;
    protected Method addListenerMethod = null;
    protected Method removeListenerMethod = null;
    private Type type;
    private boolean isUnicast = false;
    protected String name;
    static final /* synthetic */ boolean $assertionsDisabled;

    public EventSetPattern(PatternAnalyser patternAnalyser, Method addListenerMethod, Method removeListenerMethod) {
        super(patternAnalyser);
        if (addListenerMethod == null || removeListenerMethod == null) {
            throw new NullPointerException();
        }
        this.addListenerMethod = addListenerMethod;
        this.removeListenerMethod = removeListenerMethod;
        this.isUnicast = this.testUnicast();
        this.findEventSetType();
        this.name = this.findEventSetName();
    }

    private EventSetPattern(PatternAnalyser patternAnalyser) {
        super(patternAnalyser);
    }

    static EventSetPattern create(PatternAnalyser patternAnalyser, String type, int implementation, boolean fire, boolean passEvent, boolean isUnicast) {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        EventSetPattern esp = new EventSetPattern(patternAnalyser);
        esp.type = patternAnalyser.findType(type);
        if (esp.type == null || !(esp.type instanceof JavaClass)) {
            return null;
        }
        esp.name = Introspector.decapitalize(((JavaClass)esp.type).getSimpleName());
        esp.isUnicast = isUnicast;
        String listenerList = null;
        if (implementation == 1) {
            if (isUnicast) {
                BeanPatternGenerator.unicastListenerField(esp.getDeclaringClass(), esp.type, true);
            } else {
                BeanPatternGenerator.listenersArrayListField(esp.getDeclaringClass(), esp.type, true);
            }
        } else if (implementation == 2 && !isUnicast) {
            listenerList = BeanPatternGenerator.eventListenerListField(esp.getDeclaringClass(), esp.type, true).getName();
        }
        if (isUnicast) {
            esp.generateAddListenerMethod(BeanPatternGenerator.ucAddBody(esp.type, implementation), true);
            esp.generateRemoveListenerMethod(BeanPatternGenerator.ucRemoveBody(esp.type, implementation), true);
        } else {
            esp.generateAddListenerMethod(BeanPatternGenerator.mcAddBody(esp.type, implementation, listenerList), true);
            esp.generateRemoveListenerMethod(BeanPatternGenerator.mcRemoveBody(esp.type, implementation, listenerList), true);
        }
        if (fire) {
            JavaClass listener = (JavaClass)esp.type;
            List methods = JMIUtils.getMethods((ClassDefinition)listener);
            boolean isInterface = listener.isInterface();
            Iterator it = methods.iterator();
            while (it.hasNext()) {
                Method method = (Method)it.next();
                if ((method.getModifiers() & 1) == 0 && (!isInterface || (method.getModifiers() & 6) != 0)) continue;
                if (isUnicast) {
                    BeanPatternGenerator.unicastFireMethod(esp.getDeclaringClass(), esp.type, method, implementation, passEvent);
                    continue;
                }
                BeanPatternGenerator.fireMethod(esp.getDeclaringClass(), esp.type, method, implementation, listenerList, passEvent);
            }
        }
        return esp;
    }

    private Field getEstimatedListenerField() {
        Field f;
        if (this.isUnicast) {
            f = BeanPatternGenerator.unicastListenerField(this.getDeclaringClass(), this.getType(), false);
        } else {
            f = BeanPatternGenerator.listenersArrayListField(this.getDeclaringClass(), this.getType(), false);
            if (f == null) {
                f = BeanPatternGenerator.eventListenerListField(this.getDeclaringClass(), this.getType(), false);
            }
        }
        return f;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String name) throws IllegalArgumentException, JmiException {
        if (!Utilities.isJavaIdentifier((String)name) || name.indexOf("Listener") <= 0) {
            throw new IllegalArgumentException("Invalid event source name");
        }
        name = EventSetPattern.capitalizeFirstLetter(name);
        String addMethodID = "add" + name;
        String removeMethodID = "remove" + name;
        JMIUtils.beginTrans(true);
        boolean rollback = true;
        try {
            if (this.addListenerMethod.isValid() && this.removeListenerMethod.isValid()) {
                this.addListenerMethod.setName(addMethodID);
                this.removeListenerMethod.setName(removeMethodID);
                this.name = Introspector.decapitalize(name);
            }
            rollback = false;
        }
        finally {
            JMIUtils.endTrans(rollback);
        }
    }

    protected static boolean isValidName(String str) {
        if (!Utilities.isJavaIdentifier((String)str)) {
            return false;
        }
        return str.indexOf("Listener") > 0;
    }

    public boolean isUnicast() {
        return this.isUnicast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsUnicast(boolean b) throws JmiException {
        if (b == this.isUnicast) {
            return;
        }
        JMIUtils.beginTrans(true);
        boolean rollback = true;
        try {
            if (!this.addListenerMethod.isValid()) {
                return;
            }
            List exs = this.addListenerMethod.getExceptionNames();
            if (b) {
                JavaModelPackage jmodel = JavaMetamodel.getManager().getJavaExtent((Element)this.addListenerMethod);
                MultipartId tooManyId = jmodel.getMultipartId().createMultipartId("java.util.TooManyListenersException", null, null);
                exs.add(tooManyId);
            } else {
                JavaClass tooMany = this.patternAnalyser.findClassElement("java.util.TooManyListenersException");
                if (!$assertionsDisabled && tooMany == null) {
                    throw new AssertionError();
                }
                LinkedList<MultipartId> remove = new LinkedList<MultipartId>();
                Iterator it = exs.iterator();
                while (it.hasNext()) {
                    MultipartId exId = (MultipartId)it.next();
                    JavaClass ex = (JavaClass)exId.getElement();
                    if (!tooMany.isSubTypeOf((ClassDefinition)ex)) continue;
                    remove.add(exId);
                }
                exs.removeAll(remove);
            }
            this.isUnicast = b;
            rollback = false;
        }
        finally {
            JMIUtils.endTrans(rollback);
        }
    }

    public Method getAddListenerMethod() {
        return this.addListenerMethod;
    }

    public Method getRemoveListenerMethod() {
        return this.removeListenerMethod;
    }

    public Type getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setType(Type newType) throws JmiException {
        int state = 0;
        JMIUtils.beginTrans(true);
        boolean rollback = true;
        try {
            if (this.type.equals(newType) || !newType.isValid()) {
                return;
            }
            if (!(newType instanceof JavaClass) || !PatternAnalyser.isSubclass((ClassDefinition)((JavaClass)newType), (ClassDefinition)this.patternAnalyser.findClassElement("java.util.EventListener"))) {
                state = 1;
            } else {
                JavaModelPackage jmodel = (JavaModelPackage)this.addListenerMethod.refImmediatePackage();
                String newTypeName = ((JavaClass)newType).getSimpleName();
                List params = this.addListenerMethod.getParameters();
                params.clear();
                Parameter newParameter = jmodel.getParameter().createParameter();
                newParameter.setName("listener");
                newParameter.setType(newType);
                params.add(newParameter);
                params = this.removeListenerMethod.getParameters();
                params.clear();
                newParameter = jmodel.getParameter().createParameter();
                newParameter.setName("listener");
                newParameter.setType(newType);
                params.add(newParameter);
                String msg = MessageFormat.format(PatternNode.getString("FMT_ChangeEventSourceName"), EventSetPattern.capitalizeFirstLetter(newTypeName));
                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)msg, 0);
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd).equals(NotifyDescriptor.YES_OPTION)) {
                    this.setName(newTypeName);
                }
                this.type = newType;
            }
            rollback = false;
        }
        finally {
            JMIUtils.endTrans(rollback);
        }
        switch (state) {
            case 1: {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)PatternNode.getString("MSG_InvalidListenerInterface"), 0));
            }
        }
    }

    public Node.Cookie getCookie(Class cookieType) {
        return super.getCookie(cookieType);
    }

    public void destroy() throws JmiException {
        Field field;
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        if (this.addListenerMethod != null && this.addListenerMethod.isValid()) {
            this.addListenerMethod.refDelete();
        }
        if (this.removeListenerMethod != null && this.removeListenerMethod.isValid()) {
            this.removeListenerMethod.refDelete();
        }
        JavaClass declaringClass = this.getDeclaringClass();
        JavaClass listener = (JavaClass)this.type;
        boolean canDelete = false;
        if (listener != null) {
            List methods = JMIUtils.getMethods((ClassDefinition)listener);
            List sourceMethods = JMIUtils.getMethods((ClassDefinition)declaringClass);
            String typeName = listener.getSimpleName();
            Iterator it = methods.iterator();
            while (it.hasNext()) {
                Method lsnrMethod = (Method)it.next();
                String method = "fire" + Pattern.capitalizeFirstLetter(typeName) + Pattern.capitalizeFirstLetter(lsnrMethod.getName());
                if (!Modifier.isPublic(lsnrMethod.getModifiers())) continue;
                Iterator it2 = sourceMethods.iterator();
                while (it2.hasNext()) {
                    Method srcMethod = (Method)it2.next();
                    if (!srcMethod.isValid() || !srcMethod.getName().equals(method)) continue;
                    if (!canDelete) {
                        String mssg = MessageFormat.format(PatternNode.getString("FMT_DeleteFire"), new Object[0]);
                        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)mssg, 0);
                        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd).equals(NotifyDescriptor.NO_OPTION)) {
                            return;
                        }
                        canDelete = true;
                    }
                    srcMethod.refDelete();
                }
            }
        }
        if ((field = this.getEstimatedListenerField()) != null && field.isValid() && field.getReferences().isEmpty()) {
            field.refDelete();
        }
    }

    EventSetPattern(EventSetPattern x, EventSetPattern y) {
        super(y.patternAnalyser);
        this.addListenerMethod = y.addListenerMethod;
        this.removeListenerMethod = y.removeListenerMethod;
        this.isUnicast = y.isUnicast;
        this.type = y.type;
        this.name = y.name;
    }

    private void findEventSetType() {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        this.type = ((Parameter)this.addListenerMethod.getParameters().get(0)).getType();
    }

    private String findEventSetName() {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        String compound = this.addListenerMethod.getName().substring(3);
        this.name = Introspector.decapitalize(compound);
        return this.name;
    }

    private boolean testUnicast() {
        return this.findTooManyListenersException() != null;
    }

    JavaClass findTooManyListenersException() {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        JavaModelPackage model = JavaMetamodel.getManager().getJavaExtent((Element)this.addListenerMethod);
        Type t = model.getType().resolve("java.util.TooManyListenersException");
        if (t instanceof UnresolvedClass || !(t instanceof JavaClass)) {
            return null;
        }
        JavaClass tooMany = (JavaClass)t;
        List exs = this.addListenerMethod.getExceptions();
        Iterator it = exs.iterator();
        while (it.hasNext()) {
            JavaClass ex = (JavaClass)it.next();
            if (!ex.isSubTypeOf((ClassDefinition)tooMany)) continue;
            return ex;
        }
        return null;
    }

    void generateAddListenerMethod(String body, boolean javadoc) throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        JavaClass declaringClass = this.getDeclaringClass();
        if (declaringClass == null) {
            throw new IllegalStateException("Missing declaring class");
        }
        JavaModelPackage jmodel = JavaMetamodel.getManager().getJavaExtent((Element)declaringClass);
        Method newMethod = jmodel.getMethod().createMethod();
        int modifiers = 33;
        Parameter newParameter = jmodel.getParameter().createParameter();
        newParameter.setName("listener");
        newParameter.setType(this.type);
        newMethod.setName("add" + EventSetPattern.capitalizeFirstLetter(this.getName()));
        newMethod.setTypeName((TypeReference)jmodel.getMultipartId().createMultipartId("void", null, null));
        List params = newMethod.getParameters();
        params.add(newParameter);
        if (declaringClass.isInterface()) {
            modifiers &= 0xFFFFFFDF;
        } else if (body != null) {
            newMethod.setBodyText(body);
        }
        newMethod.setModifiers(modifiers);
        if (this.isUnicast) {
            MultipartId tooManyLsnrs = jmodel.getMultipartId().createMultipartId("java.util.TooManyListenersException", null, null);
            newMethod.getExceptionNames().add(tooManyLsnrs);
        }
        if (javadoc) {
            String comment = MessageFormat.format(PatternNode.getString("COMMENT_AddListenerMethod"), ((JavaClass)this.type).getSimpleName());
            newMethod.setJavadocText(comment);
        }
        declaringClass.getContents().add(newMethod);
        this.addListenerMethod = newMethod;
    }

    void generateRemoveListenerMethod(String body, boolean javadoc) throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        JavaClass declaringClass = this.getDeclaringClass();
        if (declaringClass == null) {
            throw new IllegalStateException("Missing declaring class");
        }
        JavaModelPackage jmodel = JavaMetamodel.getManager().getJavaExtent((Element)declaringClass);
        Method newMethod = jmodel.getMethod().createMethod();
        int modifiers = 33;
        Parameter newParameter = jmodel.getParameter().createParameter();
        newParameter.setName("listener");
        newParameter.setType(this.type);
        newMethod.setName("remove" + EventSetPattern.capitalizeFirstLetter(this.getName()));
        newMethod.setTypeName((TypeReference)jmodel.getMultipartId().createMultipartId("void", null, null));
        List params = newMethod.getParameters();
        params.add(newParameter);
        if (declaringClass.isInterface()) {
            modifiers &= 0xFFFFFFDF;
        } else if (body != null) {
            newMethod.setBodyText(body);
        }
        newMethod.setModifiers(modifiers);
        if (javadoc) {
            String comment = MessageFormat.format(PatternNode.getString("COMMENT_RemoveListenerMethod"), ((JavaClass)this.type).getSimpleName());
            newMethod.setJavadocText(comment);
        }
        declaringClass.getContents().add(newMethod);
        this.removeListenerMethod = newMethod;
    }

    void copyProperties(EventSetPattern src) throws JmiException {
        boolean changed;
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        boolean bl = changed = !src.getType().equals(this.getType()) || !src.getName().equals(this.getName()) || src.isUnicast() != this.isUnicast();
        if (src.getAddListenerMethod() != this.addListenerMethod) {
            this.addListenerMethod = src.getAddListenerMethod();
        }
        if (src.getRemoveListenerMethod() != this.removeListenerMethod) {
            this.removeListenerMethod = src.getRemoveListenerMethod();
        }
        if (changed) {
            this.isUnicast = this.testUnicast();
            this.findEventSetType();
            this.isUnicast = this.testUnicast();
            this.name = this.findEventSetName();
            this.firePropertyChange(new PropertyChangeEvent(this, null, null, null));
        }
    }

    static {
        $assertionsDisabled = !EventSetPattern.class.desiredAssertionStatus();
        WELL_KNOWN_LISTENERS = new String[]{"java.awt.event.ActionListener", "java.awt.event.ContainerListener", "java.awt.event.FocusListener", "java.awt.event.ItemListener", "java.awt.event.KeyListener", "java.awt.event.MouseListener", "java.awt.event.MouseMotionListener", "java.awt.event.WindowListener", "java.beans.PropertyChangeListener", "java.beans.VetoableChangeListener", "javax.swing.event.CaretListener", "javax.swing.event.ChangeListener", "javax.swing.event.DocumentListener", "javax.swing.event.HyperlinkListener", "javax.swing.event.MenuListener", "javax.swing.event.MouseInputListener", "javax.swing.event.PopupMenuListener", "javax.swing.event.TableColumnModelListener", "javax.swing.event.TableModelListener", "javax.swing.event.TreeModelListener", "javax.swing.event.UndoableEditListener"};
    }
}

