/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.lang.reflect.Modifier;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import javax.jmi.reflect.JmiException;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.beans.JMIUtils;
import org.netbeans.modules.beans.PatternNode;
import org.netbeans.modules.java.ui.nodes.SourceNodes;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

final class EventSetInheritanceAnalyser {
    static final /* synthetic */ boolean $assertionsDisabled;

    EventSetInheritanceAnalyser() {
    }

    static ClassMember detectPropertyChangeSupport(JavaClass clazz) throws JmiException {
        return EventSetInheritanceAnalyser.findSupport(clazz, "java.beans.PropertyChangeSupport");
    }

    static ClassMember detectVetoableChangeSupport(JavaClass clazz) throws JmiException {
        return EventSetInheritanceAnalyser.findSupport(clazz, "java.beans.VetoableChangeSupport");
    }

    private static ClassMember findSupport(JavaClass clazz, String supportName) throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        String propertyChangeField = supportName;
        if (clazz == null || "java.lang.Object".equals(clazz.getName())) {
            return null;
        }
        JavaClass superClass = clazz.getSuperClass();
        if (superClass == null || superClass instanceof UnresolvedClass) {
            return null;
        }
        List methods = JMIUtils.getMethods((ClassDefinition)superClass);
        Iterator it = methods.iterator();
        while (it.hasNext()) {
            Type returnType;
            Method method = (Method)it.next();
            if (Modifier.isPrivate(method.getModifiers()) || !method.getParameters().isEmpty() || !propertyChangeField.equals((returnType = method.getType()).getName())) continue;
            return method;
        }
        List fields = JMIUtils.getFields(superClass);
        Iterator it2 = fields.iterator();
        while (it2.hasNext()) {
            Field field = (Field)it2.next();
            if (Modifier.isPrivate(field.getModifiers()) || !propertyChangeField.equals(field.getType().getName())) continue;
            return field;
        }
        return EventSetInheritanceAnalyser.findSupport(superClass, supportName);
    }

    static String showInheritanceEventDialog(ClassMember me, String supportTypeName) throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        String supportName = EventSetInheritanceAnalyser.getInheritanceEventSupportName(me, supportTypeName);
        if (me != null) {
            Object[] msgfields = new Object[]{me.getDeclaringClass().getName(), supportTypeName};
            String msg = MessageFormat.format(PatternNode.getString("MSG_Inheritance_Found"), msgfields);
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)msg, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            if (nd.getValue().equals(NotifyDescriptor.YES_OPTION)) {
                return supportName;
            }
        }
        return null;
    }

    static String getInheritanceEventSupportName(ClassMember me, String supportTypeName) throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        Format format = SourceNodes.createElementFormat((String)"{n}({p})");
        String supportName = null;
        if (me != null) {
            supportName = me instanceof Method ? format.format(me) : me.getName();
        }
        return supportName;
    }

    static {
        $assertionsDisabled = !EventSetInheritanceAnalyser.class.desiredAssertionStatus();
    }
}

