/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.j2ee.weblogic9.ui.wizard.WLInstantiatingIterator;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ServerPropertiesPanel
extends JPanel
implements WizardDescriptor.Panel {
    private static final String PROP_ERROR_MESSAGE = "WizardPanel_errorMessage";
    private transient WizardDescriptor wizardDescriptor;
    private transient WLInstantiatingIterator instantiatingIterator;
    private JLabel domainPathLabel;
    private JLabel hostLabel;
    private JLabel portLabel;
    private JLabel userNameLabel;
    private JLabel passwordLabel;
    private JPasswordField passwordField;
    private JTextField domainPathField;
    private JTextField hostField;
    private JTextField portField;
    private JTextField usernameField;
    private JPanel formattingPanel;
    private JComboBox serverTypeCombo;
    private JComboBox localInstancesCombo;
    private JLabel localInstanceLabel;
    private JLabel serverTypeLabel;
    private Vector listeners = new Vector();

    public ServerPropertiesPanel(String[] steps, int index, ChangeListener listener, WLInstantiatingIterator instantiatingIterator) {
        this.instantiatingIterator = instantiatingIterator;
        this.putClientProperty("WizardPanel_contentData", steps);
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(index));
        this.addChangeListener(listener);
        this.setName(steps[index]);
        this.init();
    }

    public HelpCtx getHelp() {
        return new HelpCtx("j2eeplugins_registering_app_server_weblogic_properties");
    }

    public Component getComponent() {
        return this;
    }

    public boolean isValid() {
        this.wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)"");
        if (this.serverTypeCombo.getSelectedItem().equals(NbBundle.getMessage(ServerPropertiesPanel.class, (String)"SERVER_TYPE_LOCAL")) && !this.isValidDomainRoot(this.domainPathField.getText())) {
            this.wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(ServerPropertiesPanel.class, (String)"ERR_INVALID_DOMAIN_ROOT"));
            return false;
        }
        if (this.hostField.getText().trim().equals("")) {
            this.wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(ServerPropertiesPanel.class, (String)"ERR_INVALID_HOST"));
        }
        if (!this.portField.getText().trim().matches("[0-9]+")) {
            this.wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(ServerPropertiesPanel.class, (String)"ERR_INVALID_PORT"));
        }
        this.instantiatingIterator.setDomainRoot(this.domainPathField.getText());
        this.instantiatingIterator.setHost(this.hostField.getText());
        this.instantiatingIterator.setPort(this.portField.getText());
        this.instantiatingIterator.setUsername(this.usernameField.getText());
        this.instantiatingIterator.setPassword(new String(this.passwordField.getPassword()));
        this.instantiatingIterator.setIsLocal(this.serverTypeCombo.getSelectedItem().equals(NbBundle.getMessage(ServerPropertiesPanel.class, (String)"SERVER_TYPE_LOCAL")) ? "true" : "false");
        return true;
    }

    private boolean isValidDomainRoot(String path) {
        String[] children = new String[]{"servers", "config", "config/config.xml", "init-info/domain-info.xml"};
        boolean is90 = this.hasChildren(path, children);
        String[] children90b = new String[]{"servers", "config", "config/config.xml", "domain-info.xml"};
        boolean is90b = this.hasChildren(path, children90b);
        return is90 || is90b;
    }

    private boolean hasChildren(String parent, String[] children) {
        if (parent == null) {
            return false;
        }
        if (children == null) {
            return true;
        }
        for (int i = 0; i < children.length; ++i) {
            if (new File(parent + File.separator + children[i]).exists()) continue;
            return false;
        }
        return true;
    }

    private void init() {
        this.domainPathLabel = new JLabel();
        this.domainPathField = new JTextField();
        this.hostLabel = new JLabel();
        this.hostField = new JTextField();
        this.portLabel = new JLabel();
        this.portField = new JTextField();
        this.userNameLabel = new JLabel();
        this.usernameField = new JTextField();
        this.passwordLabel = new JLabel();
        this.passwordField = new JPasswordField();
        this.formattingPanel = new JPanel();
        this.serverTypeCombo = new JComboBox<Object>(new Object[]{NbBundle.getMessage(ServerPropertiesPanel.class, (String)"SERVER_TYPE_LOCAL")});
        this.localInstanceLabel = new JLabel();
        this.localInstancesCombo = new JComboBox(new InstancesModel(this.getServerInstances()));
        this.serverTypeLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.localInstanceLabel.setLabelFor(this.localInstancesCombo);
        this.localInstanceLabel.setText(NbBundle.getMessage(ServerPropertiesPanel.class, (String)"LBL_LOCAL_INSTANCE"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.localInstanceLabel, gridBagConstraints);
        this.localInstancesCombo.addActionListener(new InstanceSelectionListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 5, 0);
        this.add((Component)this.localInstancesCombo, gridBagConstraints);
        this.localInstancesCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerPropertiesPanel.class, (String)"ACSD_ServerPropertiesPanel_localInstancesCombo"));
        this.domainPathLabel.setLabelFor(this.domainPathField);
        this.domainPathLabel.setText(NbBundle.getMessage(ServerPropertiesPanel.class, (String)"LBL_DOMAIN_LOCATION"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.domainPathLabel, gridBagConstraints);
        this.domainPathField.setColumns(20);
        this.domainPathField.setText("");
        this.domainPathField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 5, 0);
        this.add((Component)this.domainPathField, gridBagConstraints);
        this.domainPathField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerPropertiesPanel.class, (String)"ACSD_ServerPropertiesPanel_domainPathField"));
        this.hostLabel.setLabelFor(this.hostField);
        this.hostLabel.setText(NbBundle.getMessage(ServerPropertiesPanel.class, (String)"LBL_HOST"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.hostLabel, gridBagConstraints);
        this.hostField.setColumns(20);
        this.hostField.setText("");
        this.hostField.addKeyListener(new KeyListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 5, 0);
        this.add((Component)this.hostField, gridBagConstraints);
        this.hostField.setEditable(false);
        this.hostField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerPropertiesPanel.class, (String)"ACSD_ServerPropertiesPanel_hostField"));
        this.portLabel.setLabelFor(this.portField);
        this.portLabel.setText(NbBundle.getMessage(ServerPropertiesPanel.class, (String)"LBL_PORT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.portLabel, gridBagConstraints);
        this.portField.setColumns(20);
        this.portField.setText("");
        this.portField.addKeyListener(new KeyListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 5, 0);
        this.add((Component)this.portField, gridBagConstraints);
        this.portField.setEditable(false);
        this.portField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerPropertiesPanel.class, (String)"ACSD_ServerPropertiesPanel_portField"));
        this.userNameLabel.setLabelFor(this.usernameField);
        Mnemonics.setLocalizedText((JLabel)this.userNameLabel, (String)NbBundle.getMessage(ServerPropertiesPanel.class, (String)"LBL_USERNAME"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.userNameLabel, gridBagConstraints);
        this.usernameField.setColumns(20);
        this.usernameField.setText("");
        this.usernameField.addKeyListener(new KeyListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 5, 0);
        this.add((Component)this.usernameField, gridBagConstraints);
        this.usernameField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerPropertiesPanel.class, (String)"ACSD_ServerPropertiesPanel_usernameField"));
        this.passwordLabel.setLabelFor(this.passwordField);
        Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)NbBundle.getMessage(ServerPropertiesPanel.class, (String)"LBL_PASSWORD"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.passwordLabel, gridBagConstraints);
        this.passwordField.setColumns(20);
        this.passwordField.addKeyListener(new KeyListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 5, 0);
        this.add((Component)this.passwordField, gridBagConstraints);
        this.passwordField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerPropertiesPanel.class, (String)"ACSD_ServerPropertiesPanel_passwordField"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.formattingPanel, gridBagConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getRegisteredDomains(String serverRoot) {
        Vector<String> result = new Vector<String>();
        if (serverRoot == null) {
            return new String[0];
        }
        String domainListFile = "/common/nodemanager/nodemanager.domains";
        File file = new File(serverRoot + domainListFile);
        BufferedReader lnr = null;
        try {
            String line;
            lnr = new LineNumberReader(new InputStreamReader(new FileInputStream(file)));
            while ((line = ((LineNumberReader)lnr).readLine()) != null) {
                if (line.startsWith("#")) continue;
                String path = line.split("=")[1].replaceAll("\\\\\\\\", "/").replaceAll("\\\\:", ":");
                result.add(path);
            }
        }
        catch (FileNotFoundException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        finally {
            try {
                if (lnr != null) {
                    lnr.close();
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getServerInstances() {
        Vector<Instance> result = new Vector<Instance>();
        String[] domains = this.getRegisteredDomains(this.instantiatingIterator.getServerRoot());
        for (int i = 0; i < domains.length; ++i) {
            String configPath = domains[i] + "/config/config.xml";
            InputStream inputStream = null;
            Document document = null;
            try {
                inputStream = new FileInputStream(new File(configPath));
                document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
                Element root = document.getDocumentElement();
                NodeList children = root.getChildNodes();
                for (int j = 0; j < children.getLength(); ++j) {
                    Node child = children.item(j);
                    if (!child.getNodeName().matches("(?:[a-z]+\\:)?server")) continue;
                    NodeList nl = child.getChildNodes();
                    String name = "";
                    String port = "";
                    String host = "";
                    for (int k = 0; k < nl.getLength(); ++k) {
                        Node ch = nl.item(k);
                        if (ch.getNodeName().matches("(?:[a-z]+\\:)?name")) {
                            name = ch.getFirstChild().getNodeValue();
                        }
                        if (ch.getNodeName().matches("(?:[a-z]+\\:)?listen-port")) {
                            port = ch.getFirstChild().getNodeValue();
                        }
                        if (!ch.getNodeName().matches("(?:[a-z]+\\:)?listen-address") || !ch.hasChildNodes()) continue;
                        host = ch.getFirstChild().getNodeValue();
                    }
                    if (name == null || name.equals("")) continue;
                    port = port == null || port.equals("") ? "7001" : port;
                    host = host == null || host.equals("") ? "localhost" : host;
                    result.add(new Instance(name, host, port, domains[i]));
                }
                continue;
            }
            catch (FileNotFoundException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                continue;
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                continue;
            }
            catch (ParserConfigurationException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                continue;
            }
            catch (SAXException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                continue;
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
        }
        return result;
    }

    public void updateInstancesList() {
        this.localInstancesCombo.setModel(new InstancesModel(this.getServerInstances()));
        this.updateInstanceInfo();
    }

    private void updateInstanceInfo() {
        Instance instance = (Instance)this.localInstancesCombo.getSelectedItem();
        if (instance != null) {
            this.domainPathField.setText(instance.getDomainPath());
            this.hostField.setText(instance.getHost());
            this.portField.setText(instance.getPort());
        }
    }

    public void readSettings(Object object) {
        this.wizardDescriptor = (WizardDescriptor)object;
    }

    public void storeSettings(Object object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener listener) {
        if (this.listeners != null) {
            Vector vector = this.listeners;
            synchronized (vector) {
                this.listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener listener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.add(listener);
        }
    }

    private void fireChangeEvent() {
        ChangeEvent event = new ChangeEvent(this);
        this.fireChangeEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeEvent(ChangeEvent event) {
        Vector targetListeners;
        Vector vector = this.listeners;
        synchronized (vector) {
            targetListeners = (Vector)this.listeners.clone();
        }
        for (int i = 0; i < targetListeners.size(); ++i) {
            ChangeListener listener = (ChangeListener)targetListeners.elementAt(i);
            listener.stateChanged(event);
        }
    }

    private static class Instance {
        private String name;
        private String host;
        private String port;
        private String domainPath;

        public Instance(String name, String host, String port, String domainPath) {
            this.name = name;
            this.host = host;
            this.port = port;
            this.domainPath = domainPath;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public String getPort() {
            return this.port;
        }

        public void setPort(String port) {
            this.port = port;
        }

        public String getDomainPath() {
            return this.domainPath;
        }

        public void setDomainPath(String domainPath) {
            this.domainPath = domainPath;
        }

        public String toString() {
            return this.name + " [" + this.host + ":" + this.port + "]";
        }
    }

    private static class InstancesModel
    extends AbstractListModel
    implements ComboBoxModel {
        private Vector instances;
        private int selectedIndex = 0;

        public InstancesModel(Vector instances) {
            this.instances = instances;
            this.selectedIndex = 0;
        }

        public void setSelectedItem(Object item) {
            this.selectedIndex = this.instances.indexOf(item);
        }

        public Object getElementAt(int index) {
            return this.instances.elementAt(index);
        }

        public int getSize() {
            return this.instances.size();
        }

        public Object getSelectedItem() {
            if (this.instances.size() == 0) {
                return null;
            }
            return this.instances.elementAt(this.selectedIndex);
        }
    }

    private class InstanceSelectionListener
    implements ActionListener {
        private InstanceSelectionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ServerPropertiesPanel.this.updateInstanceInfo();
        }
    }

    private class ServerTypeActionListener
    implements ActionListener {
        private ServerTypeActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (ServerPropertiesPanel.this.serverTypeCombo.getSelectedItem().equals(NbBundle.getMessage(ServerPropertiesPanel.class, (String)"SERVER_TYPE_LOCAL"))) {
                Instance instance = (Instance)ServerPropertiesPanel.this.localInstancesCombo.getSelectedItem();
                ServerPropertiesPanel.this.localInstancesCombo.setEnabled(true);
                ServerPropertiesPanel.this.domainPathField.setEnabled(true);
                ServerPropertiesPanel.this.domainPathField.setEditable(false);
                ServerPropertiesPanel.this.hostField.setEnabled(true);
                ServerPropertiesPanel.this.hostField.setEditable(false);
                ServerPropertiesPanel.this.hostField.setText(instance.getHost());
                ServerPropertiesPanel.this.portField.setEnabled(true);
                ServerPropertiesPanel.this.portField.setEditable(false);
                ServerPropertiesPanel.this.portField.setText(instance.getPort());
            } else {
                ServerPropertiesPanel.this.localInstancesCombo.setEnabled(false);
                ServerPropertiesPanel.this.domainPathField.setEnabled(false);
                ServerPropertiesPanel.this.domainPathField.setEditable(false);
                ServerPropertiesPanel.this.hostField.setEnabled(true);
                ServerPropertiesPanel.this.hostField.setEditable(true);
                ServerPropertiesPanel.this.portField.setEnabled(true);
                ServerPropertiesPanel.this.portField.setEditable(true);
            }
            ServerPropertiesPanel.this.isValid();
        }
    }

    private class KeyListener
    extends KeyAdapter {
        private KeyListener() {
        }

        public void keyTyped(KeyEvent event) {
            ServerPropertiesPanel.this.fireChangeEvent();
        }

        public void keyReleased(KeyEvent event) {
            ServerPropertiesPanel.this.fireChangeEvent();
        }
    }
}

