/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.config;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import org.netbeans.modules.j2ee.weblogic9.config.WLDeploymentConfiguration;
import org.netbeans.modules.j2ee.weblogic9.config.gen.WeblogicEjbJar;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class EjbDeploymentConfiguration
extends WLDeploymentConfiguration {
    private File file;
    private WeblogicEjbJar weblogicEjbJar;

    public EjbDeploymentConfiguration(DeployableObject deployableObject) {
        super(deployableObject);
    }

    public void init(File file) {
        this.file = file;
        this.getWeblogicEjbJar();
        if (this.dataObject == null) {
            try {
                this.dataObject = DataObject.find((FileObject)FileUtil.toFileObject((File)file));
            }
            catch (DataObjectNotFoundException donfe) {
                ErrorManager.getDefault().notify((Throwable)donfe);
            }
        }
    }

    public synchronized WeblogicEjbJar getWeblogicEjbJar() {
        if (this.weblogicEjbJar == null) {
            try {
                if (this.file.exists()) {
                    try {
                        this.weblogicEjbJar = WeblogicEjbJar.createGraph(this.file);
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify((Throwable)ioe);
                    }
                    catch (RuntimeException re) {}
                } else {
                    this.weblogicEjbJar = this.genereateWeblogicEjbJar();
                    this.writefile(this.file, this.weblogicEjbJar);
                }
            }
            catch (ConfigurationException ce) {
                ErrorManager.getDefault().notify((Throwable)ce);
            }
        }
        return this.weblogicEjbJar;
    }

    public void save(OutputStream os) throws ConfigurationException {
        WeblogicEjbJar weblogicEjbJar = this.getWeblogicEjbJar();
        if (weblogicEjbJar == null) {
            throw new ConfigurationException("Cannot read configuration, it is probably in an inconsistent state.");
        }
        try {
            weblogicEjbJar.write(os);
        }
        catch (IOException ioe) {
            throw new ConfigurationException(ioe.getLocalizedMessage());
        }
    }

    private WeblogicEjbJar genereateWeblogicEjbJar() {
        return new WeblogicEjbJar();
    }
}

