/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WLPluginProperties {
    private static final boolean verboseRegistration = System.getProperty("netbeans.weblogic.registration") != null;
    public static final String SERVER_ROOT_ATTR = "serverRoot";
    public static final String DOMAIN_ROOT_ATTR = "domainRoot";
    public static final String IS_LOCAL_ATTR = "isLocal";
    public static final String HOST_ATTR = "host";
    public static final String PORT_ATTR = "port";
    public static final String DEBUGGER_PORT_ATTR = "debuggerPort";
    private static WLPluginProperties pluginProperties = null;
    private String installLocation;
    private static final String INSTALL_ROOT_KEY = "installRoot";
    private FileObject propertiesFile = null;
    public static final String DOMAIN_LIST = "common/nodemanager/nodemanager.domains";
    private static Collection fileColl = new ArrayList();
    private static final String J2SE_PLATFORM_VERSION_15 = "1.5";
    private static final String J2SE_PLATFORM_VERSION_16 = "1.6";

    public static WLPluginProperties getInstance() {
        if (pluginProperties == null) {
            pluginProperties = new WLPluginProperties();
        }
        return pluginProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private WLPluginProperties() {
        InputStream inStream = null;
        try {
            try {
                this.propertiesFile = this.getPropertiesFile();
                if (null != this.propertiesFile) {
                    inStream = this.propertiesFile.getInputStream();
                }
                this.loadPluginProperties(inStream);
                if (null == inStream) return;
            }
            catch (FileNotFoundException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                return;
            }
            catch (IOException e2) {
                ErrorManager.getDefault().notify(1, (Throwable)e2);
                return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.loadPluginProperties(inStream);
                if (null != inStream) {
                    inStream.close();
                }
            }
            inStream.close();
            return;
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
    }

    void loadPluginProperties(InputStream inStream) {
        String loc;
        Properties inProps = new Properties();
        if (null != inStream) {
            try {
                inProps.load(inStream);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        if ((loc = inProps.getProperty(INSTALL_ROOT_KEY)) != null) {
            this.setInstallLocation(loc);
        }
    }

    private FileObject getPropertiesFile() throws IOException {
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        FileObject dir = fs.findResource("J2EE");
        FileObject retVal = null;
        if (null != dir && null == (retVal = dir.getFileObject("weblogic", "properties"))) {
            retVal = dir.createData("weblogic", "properties");
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProperties() {
        block11: {
            Properties outProp = new Properties();
            String installRoot = this.getInstallLocation();
            if (installRoot != null) {
                outProp.setProperty(INSTALL_ROOT_KEY, installRoot);
            }
            FileLock l = null;
            OutputStream outStream = null;
            try {
                if (null == this.propertiesFile) break block11;
                try {
                    l = this.propertiesFile.lock();
                    outStream = this.propertiesFile.getOutputStream(l);
                    if (null != outStream) {
                        outProp.store(outStream, "");
                    }
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
                finally {
                    if (null != outStream) {
                        outStream.close();
                    }
                    if (null != l) {
                        l.releaseLock();
                    }
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
    }

    public static boolean domainListExists(File candidate) {
        return null != candidate && candidate.exists() && candidate.canRead() && candidate.isDirectory() && new File(candidate.getPath() + File.separator + DOMAIN_LIST).exists();
    }

    public static boolean isGoodServerLocation(File candidate) {
        return null != candidate && candidate.exists() && candidate.canRead() && candidate.isDirectory() && WLPluginProperties.hasRequiredChildren(candidate, fileColl);
    }

    public static boolean isSupportedVersion(File serverRoot) {
        List<File> registryFiles = WLPluginProperties.findRegistryFiles(serverRoot);
        for (File registryFile : registryFiles) {
            if (!WLPluginProperties.testRegistryFile(serverRoot, registryFile)) continue;
            return true;
        }
        return false;
    }

    private static List<File> findRegistryFiles(File serverRoot) {
        LinkedList<File> registryList = new LinkedList<File>();
        List<String> beaHomesList = WLPluginProperties.findBeaHomes();
        for (String beaHome : beaHomesList) {
            File registryFile = new File(beaHome + File.separator + "registry.xml");
            registryList.add(registryFile);
        }
        return registryList;
    }

    private static boolean testRegistryFile(File serverRoot, File registryFile) {
        block3: {
            try {
                InputSource input = new InputSource(new BufferedInputStream(new FileInputStream(registryFile)));
                Document doc = XMLUtil.parse((InputSource)input, (boolean)false, (boolean)false, null, null);
                NodeList releaseNodes = doc.getElementsByTagName("release");
                for (int i = 0; i < releaseNodes.getLength(); ++i) {
                    Node releaseNode = releaseNodes.item(i);
                    NamedNodeMap releaseNodeAttributes = releaseNode.getAttributes();
                    String level = releaseNodeAttributes.getNamedItem("level").getNodeValue();
                    String installDir = releaseNodeAttributes.getNamedItem("InstallDir").getNodeValue();
                    String installDirCanonical = new File(installDir).getCanonicalPath();
                    if (level == null || !level.startsWith("9.") || !installDirCanonical.equals(serverRoot.getCanonicalPath())) continue;
                    return true;
                }
            }
            catch (Exception ex) {
                if (!verboseRegistration) break block3;
                String msg = NbBundle.getMessage(WLPluginProperties.class, (String)"ERR_READING_REGISTRY_FILE", (Object)registryFile.getPath());
                ErrorManager.getDefault().annotate((Throwable)ex, msg);
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> findBeaHomes() {
        LinkedList<String> beaHomesList = new LinkedList<String>();
        String dir = "";
        if (Utilities.isUnix()) {
            dir = System.getProperty("user.home", "");
        } else if (Utilities.isWindows()) {
            String systemDrive = System.getenv("SystemDrive");
            if (systemDrive == null) {
                systemDrive = "C:";
            }
            dir = systemDrive;
        }
        File beaHomeList = new File(dir + File.separator + "bea" + File.separator + "beahomelist");
        try {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(beaHomeList));
                String list = br.readLine();
                if (list != null) {
                    StringTokenizer st = new StringTokenizer(list, ";");
                    while (st.hasMoreTokens()) {
                        beaHomesList.add(st.nextToken());
                    }
                }
            }
            finally {
                if (br != null) {
                    br.close();
                }
            }
        }
        catch (Exception ex) {
            String msg = NbBundle.getMessage(WLPluginProperties.class, (String)"ERR_READING_BEAHOMELIST", (Object)beaHomeList.getPath());
            ErrorManager.getDefault().annotate((Throwable)ex, msg);
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return beaHomesList;
    }

    private static boolean hasRequiredChildren(File candidate, Collection requiredChildren) {
        if (null == candidate) {
            return false;
        }
        String[] children = candidate.list();
        if (null == children) {
            return false;
        }
        if (null == requiredChildren) {
            return true;
        }
        for (String next : requiredChildren) {
            File test = new File(candidate.getPath() + File.separator + next);
            if (test.exists()) continue;
            return false;
        }
        return true;
    }

    public boolean isCurrentServerLocationValid() {
        if (this.getInstallLocation() != null) {
            return WLPluginProperties.isGoodServerLocation(new File(this.getInstallLocation()));
        }
        return false;
    }

    public void setInstallLocation(String installLocation) {
        if (installLocation.endsWith("/") || installLocation.endsWith("\\")) {
            installLocation = installLocation.substring(0, installLocation.length() - 1);
        }
        this.installLocation = installLocation;
    }

    public String getInstallLocation() {
        return this.installLocation;
    }

    public static boolean runningOnCorrectJdk() {
        SpecificationVersion defPlatVersion = JavaPlatformManager.getDefault().getDefaultPlatform().getSpecification().getVersion();
        return J2SE_PLATFORM_VERSION_15.equals(defPlatVersion.toString()) || J2SE_PLATFORM_VERSION_16.equals(defPlatVersion.toString());
    }

    static {
        fileColl.add("common");
        fileColl.add("javelin");
        fileColl.add("uninstall");
        fileColl.add("common/bin");
        fileColl.add("server/lib/weblogic.jar");
    }
}

