/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.project.ui.BrowseFolders;
import org.netbeans.modules.project.ui.PhysicalView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class SimpleTargetChooserPanelGUI
extends JPanel
implements ActionListener,
DocumentListener {
    private static final Dimension PREF_DIM;
    private static final String NEW_FILE_PREFIX;
    private final ListCellRenderer CELL_RENDERER = new GroupCellRenderer();
    private Project project;
    private String expectedExtension;
    private final List listeners = new ArrayList();
    private SourceGroup[] folders;
    private boolean isFolder;
    private JPanel bottomPanelContainer;
    private JButton browseButton;
    private JTextField documentNameTextField;
    private JTextField fileTextField;
    private JTextField folderTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JComboBox locationComboBox;
    private JLabel locationLabel;
    private JTextField projectTextField;
    private JSeparator targetSeparator;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SimpleTargetChooserPanelGUI(Project project, SourceGroup[] folders, Component bottomPanel, boolean isFolder) {
        this.project = project;
        this.folders = folders;
        this.isFolder = isFolder;
        this.initComponents();
        this.locationComboBox.setRenderer(this.CELL_RENDERER);
        if (bottomPanel != null) {
            this.bottomPanelContainer.add(bottomPanel, "Center");
        }
        this.initValues(null, null);
        this.browseButton.addActionListener(this);
        this.locationComboBox.addActionListener(this);
        this.documentNameTextField.getDocument().addDocumentListener(this);
        this.folderTextField.getDocument().addDocumentListener(this);
        this.setName(NbBundle.getMessage((Class)SimpleTargetChooserPanelGUI.class, (String)"LBL_SimpleTargetChooserPanel_Name"));
    }

    public void initValues(FileObject template, FileObject preselectedFolder) {
        this.initValues(template, preselectedFolder, null);
    }

    public void initValues(FileObject template, FileObject preselectedFolder, String documentName) {
        if (!$assertionsDisabled && this.project == null) {
            throw new AssertionError();
        }
        this.projectTextField.setText(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        Sources sources = ProjectUtils.getSources((Project)this.project);
        this.folders = sources.getSourceGroups("generic");
        if (this.folders.length < 2) {
            this.locationLabel.setVisible(false);
            this.locationComboBox.setVisible(false);
        } else {
            this.locationLabel.setVisible(true);
            this.locationComboBox.setVisible(true);
        }
        this.locationComboBox.setModel(new DefaultComboBoxModel<SourceGroup>(this.folders));
        SourceGroup preselectedGroup = this.getPreselectedGroup(this.folders, preselectedFolder);
        this.locationComboBox.setSelectedItem(preselectedGroup);
        this.folderTextField.setText(this.getRelativeNativeName(preselectedGroup.getRootFolder(), preselectedFolder));
        String ext = template == null ? "" : template.getExt();
        this.expectedExtension = ext.length() == 0 ? "" : "." + ext;
        String displayName = null;
        try {
            if (template != null) {
                DataObject templateDo = DataObject.find((FileObject)template);
                displayName = templateDo.getNodeDelegate().getDisplayName();
            }
        }
        catch (DataObjectNotFoundException ex) {
            displayName = template.getName();
        }
        this.putClientProperty("NewFileWizard_Title", displayName);
        if (template != null) {
            if (documentName == null) {
                documentName = NEW_FILE_PREFIX + template.getName();
            }
            this.documentNameTextField.setText(documentName);
            this.documentNameTextField.selectAll();
        }
        if (this.isFolder) {
            this.jLabel3.setText(NbBundle.getMessage((Class)SimpleTargetChooserPanelGUI.class, (String)"LBL_TargetChooser_FolderName_Label"));
            this.jLabel3.setDisplayedMnemonic(NbBundle.getMessage((Class)SimpleTargetChooserPanelGUI.class, (String)"MNE_TargetChooser_FolderName_Label").charAt(0));
            this.jLabel2.setText(NbBundle.getMessage((Class)SimpleTargetChooserPanelGUI.class, (String)"LBL_TargetChooser_ParentFolder_Label"));
            this.jLabel2.setDisplayedMnemonic(NbBundle.getMessage((Class)SimpleTargetChooserPanelGUI.class, (String)"MNE_TargetChooser_ParentFolder_Label").charAt(0));
            this.jLabel4.setText(NbBundle.getMessage((Class)SimpleTargetChooserPanelGUI.class, (String)"LBL_TargetChooser_CreatedFolder_Label"));
            this.jLabel4.setDisplayedMnemonic(NbBundle.getMessage((Class)SimpleTargetChooserPanelGUI.class, (String)"MNE_TargetChooser_CreatedFolder_Label").charAt(0));
        } else {
            this.jLabel3.setText(NbBundle.getMessage((Class)SimpleTargetChooserPanelGUI.class, (String)"LBL_TargetChooser_FileName_Label"));
            this.jLabel2.setText(NbBundle.getMessage((Class)SimpleTargetChooserPanelGUI.class, (String)"LBL_TargetChooser_Folder_Label"));
            this.jLabel4.setText(NbBundle.getMessage((Class)SimpleTargetChooserPanelGUI.class, (String)"LBL_TargetChooser_CreatedFile_Label"));
            this.jLabel3.setDisplayedMnemonic(NbBundle.getMessage((Class)SimpleTargetChooserPanelGUI.class, (String)"MNE_TargetChooser_FileName_Label").charAt(0));
            this.jLabel2.setDisplayedMnemonic(NbBundle.getMessage((Class)SimpleTargetChooserPanelGUI.class, (String)"MNE_TargetChooser_Folder_Label").charAt(0));
            this.jLabel4.setDisplayedMnemonic(NbBundle.getMessage((Class)SimpleTargetChooserPanelGUI.class, (String)"MNE_TargetChooser_CreatedFile_Label").charAt(0));
        }
    }

    public SourceGroup getTargetGroup() {
        return (SourceGroup)this.locationComboBox.getSelectedItem();
    }

    public String getTargetFolder() {
        String folderName = this.folderTextField.getText().trim();
        if (folderName.length() == 0) {
            return null;
        }
        return folderName.replace(File.separatorChar, '/');
    }

    public String getTargetName() {
        String text = this.documentNameTextField.getText().trim();
        if (text.length() == 0) {
            return null;
        }
        return text;
    }

    public Dimension getPreferredSize() {
        return PREF_DIM;
    }

    public synchronized void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList templist;
        ChangeEvent e = new ChangeEvent(this);
        SimpleTargetChooserPanelGUI simpleTargetChooserPanelGUI = this;
        synchronized (simpleTargetChooserPanelGUI) {
            templist = new ArrayList(this.listeners);
        }
        Iterator it = templist.iterator();
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(e);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.documentNameTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.projectTextField = new JTextField();
        this.locationLabel = new JLabel();
        this.locationComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.folderTextField = new JTextField();
        this.browseButton = new JButton();
        this.jLabel4 = new JLabel();
        this.fileTextField = new JTextField();
        this.targetSeparator = new JSeparator();
        this.bottomPanelContainer = new JPanel();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)SimpleTargetChooserPanelGUI.class).getString("AD_SimpleTargetChooserPanelGUI"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel3.setDisplayedMnemonic(NbBundle.getMessage((Class)SimpleTargetChooserPanelGUI.class, (String)"MNE_TargetChooser_FileName_Label").charAt(0));
        this.jLabel3.setLabelFor(this.documentNameTextField);
        this.jLabel3.setText(NbBundle.getMessage((Class)SimpleTargetChooserPanelGUI.class, (String)"LBL_TargetChooser_FileName_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.documentNameTextField, gridBagConstraints);
        this.documentNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)SimpleTargetChooserPanelGUI.class).getString("AD_documentNameTextField"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 24, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel1.setDisplayedMnemonic(NbBundle.getMessage((Class)SimpleTargetChooserPanelGUI.class, (String)"MNE_TargetChooser_Project_Label").charAt(0));
        this.jLabel1.setText(NbBundle.getMessage((Class)SimpleTargetChooserPanelGUI.class, (String)"LBL_TargetChooser_Project_Label"));
        this.jLabel1.setLabelFor(this.projectTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.projectTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.projectTextField, gridBagConstraints);
        this.projectTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)SimpleTargetChooserPanelGUI.class).getString("AD_projectTextField"));
        this.locationLabel.setDisplayedMnemonic(NbBundle.getMessage((Class)SimpleTargetChooserPanelGUI.class, (String)"MNE_TargetChooser_Location_Label").charAt(0));
        this.locationLabel.setLabelFor(this.locationComboBox);
        this.locationLabel.setText(NbBundle.getMessage((Class)SimpleTargetChooserPanelGUI.class, (String)"LBL_TargetChooser_Location_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.locationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 5, 0);
        this.add((Component)this.locationComboBox, gridBagConstraints);
        this.locationComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)SimpleTargetChooserPanelGUI.class).getString("AD_locationComboBox"));
        this.jLabel2.setDisplayedMnemonic(NbBundle.getMessage((Class)SimpleTargetChooserPanelGUI.class, (String)"MNE_TargetChooser_ParentFolder_Label").charAt(0));
        this.jLabel2.setLabelFor(this.folderTextField);
        this.jLabel2.setText(NbBundle.getMessage((Class)SimpleTargetChooserPanelGUI.class, (String)"LBL_TargetChooser_Folder_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.folderTextField, gridBagConstraints);
        this.folderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)SimpleTargetChooserPanelGUI.class).getString("AD_folderTextField"));
        this.browseButton.setMnemonic(NbBundle.getMessage((Class)SimpleTargetChooserPanelGUI.class, (String)"MNE_TargetChooser_Browse_Button").charAt(0));
        this.browseButton.setText(NbBundle.getMessage((Class)SimpleTargetChooserPanelGUI.class, (String)"LBL_TargetChooser_Browse_Button"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.browseButton, gridBagConstraints);
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)SimpleTargetChooserPanelGUI.class).getString("AD_browseButton"));
        this.jLabel4.setDisplayedMnemonic(NbBundle.getMessage((Class)SimpleTargetChooserPanelGUI.class, (String)"MNE_TargetChooser_CreatedFile_Label").charAt(0));
        this.jLabel4.setText(NbBundle.getMessage((Class)SimpleTargetChooserPanelGUI.class, (String)"LBL_TargetChooser_CreatedFile_Label"));
        this.jLabel4.setLabelFor(this.fileTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.fileTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.fileTextField, gridBagConstraints);
        this.fileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)SimpleTargetChooserPanelGUI.class).getString("AD_fileTextField"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.targetSeparator, gridBagConstraints);
        this.bottomPanelContainer.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.bottomPanelContainer, gridBagConstraints);
    }

    private SourceGroup getPreselectedGroup(SourceGroup[] groups, FileObject folder) {
        for (int i = 0; folder != null && i < groups.length; ++i) {
            if (!FileUtil.isParentOf((FileObject)groups[i].getRootFolder(), (FileObject)folder) && !groups[i].getRootFolder().equals(folder)) continue;
            return groups[i];
        }
        return groups[0];
    }

    private String getRelativeNativeName(FileObject root, FileObject folder) {
        if (root == null) {
            throw new NullPointerException("null root passed to getRelativeNativeName");
        }
        String path = folder == null ? "" : FileUtil.getRelativePath((FileObject)root, (FileObject)folder);
        return path == null ? "" : path.replace('/', File.separatorChar);
    }

    private void updateCreatedFolder() {
        FileObject root = ((SourceGroup)this.locationComboBox.getSelectedItem()).getRootFolder();
        String folderName = this.folderTextField.getText().trim();
        String documentName = this.documentNameTextField.getText().trim();
        String createdFileName = FileUtil.getFileDisplayName((FileObject)root) + (folderName.startsWith("/") || folderName.startsWith(File.separator) ? "" : "/") + folderName + (folderName.endsWith("/") || folderName.endsWith(File.separator) || folderName.length() == 0 ? "" : "/") + documentName + this.expectedExtension;
        this.fileTextField.setText(createdFileName.replace('/', File.separatorChar));
        this.fireChange();
    }

    public void actionPerformed(ActionEvent e) {
        if (this.browseButton == e.getSource()) {
            FileObject fo = null;
            SourceGroup group = (SourceGroup)this.locationComboBox.getSelectedItem();
            fo = BrowseFolders.showDialog(new SourceGroup[]{group}, this.project, this.folderTextField.getText().replace(File.separatorChar, '/'));
            if (fo != null && fo.isFolder()) {
                String relPath = FileUtil.getRelativePath((FileObject)group.getRootFolder(), (FileObject)fo);
                this.folderTextField.setText(relPath.replace('/', File.separatorChar));
            }
        } else if (this.locationComboBox == e.getSource()) {
            this.updateCreatedFolder();
        }
    }

    public void changedUpdate(DocumentEvent e) {
        this.updateCreatedFolder();
    }

    public void insertUpdate(DocumentEvent e) {
        this.updateCreatedFolder();
    }

    public void removeUpdate(DocumentEvent e) {
        this.updateCreatedFolder();
    }

    static {
        $assertionsDisabled = !SimpleTargetChooserPanelGUI.class.desiredAssertionStatus();
        PREF_DIM = new Dimension(500, 340);
        NEW_FILE_PREFIX = NbBundle.getMessage((Class)SimpleTargetChooserPanelGUI.class, (String)"LBL_SimpleTargetChooserPanelGUI_NewFilePrefix");
    }

    private class GroupCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public GroupCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof SourceGroup) {
                String groupDisplayName;
                SourceGroup group = (SourceGroup)value;
                String projectDisplayName = ProjectUtils.getInformation((Project)SimpleTargetChooserPanelGUI.this.project).getDisplayName();
                if (projectDisplayName.equals(groupDisplayName = group.getDisplayName())) {
                    this.setText(groupDisplayName);
                } else {
                    this.setText(MessageFormat.format(PhysicalView.GroupNode.GROUP_NAME_PATTERN, groupDisplayName, projectDisplayName, group.getRootFolder().getName()));
                }
                this.setIcon(group.getIcon(false));
            } else {
                this.setText(value.toString());
                this.setIcon(null);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }
}

