/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import javax.swing.Action;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.PhysicalView;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderLookup;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.xml.XMLUtil;
import org.openidex.search.SearchInfo;
import org.openidex.search.SearchInfoFactory;

public class ProjectsRootNode
extends AbstractNode {
    static final int PHYSICAL_VIEW = 0;
    static final int LOGICAL_VIEW = 1;
    private static final String ICON_BASE = "org/netbeans/modules/project/ui/resources/projectsRootNode";
    private static final String ACTIONS_FOLDER = "ProjectsTabActions";
    private ResourceBundle bundle;
    private final int type;
    static /* synthetic */ Class class$org$netbeans$api$project$Project;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$netbeans$spi$project$ui$LogicalViewProvider;
    static /* synthetic */ Class class$org$netbeans$modules$project$ui$PhysicalView$PathFinder;

    public ProjectsRootNode(int type) {
        super((Children)new ProjectChildren(type));
        this.setIconBase(ICON_BASE);
        this.type = type;
    }

    public String getName() {
        return "OpenProjects";
    }

    public String getDisplayName() {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle((Class)ProjectsRootNode.class);
        }
        return this.bundle.getString("LBL_OpenProjectsNode_Name");
    }

    public boolean canRename() {
        return false;
    }

    public Node.Handle getHandle() {
        return new Handle(this.type);
    }

    public Action[] getActions(boolean context) {
        if (context || this.type == 0) {
            return new Action[0];
        }
        ArrayList<Action> actions = new ArrayList<Action>();
        DataFolder actionsFolder = DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().findResource(ACTIONS_FOLDER));
        Iterator instances = new FolderLookup((DataObject.Container)actionsFolder).getLookup().lookup(new Lookup.Template(Object.class)).allInstances().iterator();
        while (instances.hasNext()) {
            Object o = instances.next();
            if (o instanceof Action) {
                actions.add((Action)o);
                continue;
            }
            if (!(o instanceof JSeparator)) continue;
            actions.add(null);
        }
        return actions.toArray(new Action[actions.size()]);
    }

    Node findNode(FileObject target) {
        ProjectChildren ch = (ProjectChildren)this.getChildren();
        if (ch.type == 1) {
            int lookOnlyInOwnerProject;
            Node[] nodes = ch.getNodes(true);
            Project ownerProject = FileOwnerQuery.getOwner((FileObject)target);
            int n = lookOnlyInOwnerProject = ownerProject != null ? 0 : 1;
            while (lookOnlyInOwnerProject < 2) {
                for (int i = 0; i < nodes.length; ++i) {
                    Node selectedNode;
                    Project p = (Project)nodes[i].getLookup().lookup(class$org$netbeans$api$project$Project == null ? ProjectsRootNode.class$("org.netbeans.api.project.Project") : class$org$netbeans$api$project$Project);
                    if (!$assertionsDisabled && p == null) {
                        throw new AssertionError((Object)("Should have had a Project in lookup of " + nodes[i]));
                    }
                    if (lookOnlyInOwnerProject == 0 && p != ownerProject) continue;
                    LogicalViewProvider lvp = (LogicalViewProvider)p.getLookup().lookup(class$org$netbeans$spi$project$ui$LogicalViewProvider == null ? ProjectsRootNode.class$("org.netbeans.spi.project.ui.LogicalViewProvider") : class$org$netbeans$spi$project$ui$LogicalViewProvider);
                    if (lvp == null || (selectedNode = lvp.findPath(nodes[i], (Object)target)) == null) continue;
                    return selectedNode;
                }
                ++lookOnlyInOwnerProject;
            }
            return null;
        }
        if (ch.type == 0) {
            Node[] nodes = ch.getNodes(true);
            for (int i = 0; i < nodes.length; ++i) {
                Node n;
                PhysicalView.PathFinder pf = (PhysicalView.PathFinder)nodes[i].getLookup().lookup(class$org$netbeans$modules$project$ui$PhysicalView$PathFinder == null ? ProjectsRootNode.class$("org.netbeans.modules.project.ui.PhysicalView$PathFinder") : class$org$netbeans$modules$project$ui$PhysicalView$PathFinder);
                if (pf == null || (n = pf.findPath(nodes[i], target)) == null) continue;
                return n;
            }
            return null;
        }
        return null;
    }

    static SearchInfo alwaysSearchableSearchInfo(SearchInfo i) {
        return new AlwaysSearchableSearchInfo(i);
    }

    static {
        $assertionsDisabled = !ProjectsRootNode.class.desiredAssertionStatus();
    }

    private static final class AlwaysSearchableSearchInfo
    implements SearchInfo {
        private final SearchInfo delegate;

        public AlwaysSearchableSearchInfo(SearchInfo delegate) {
            this.delegate = delegate;
        }

        public boolean canSearch() {
            return true;
        }

        public Iterator objectsToSearch() {
            return this.delegate.objectsToSearch();
        }
    }

    private static final class BadgingNode
    extends FilterNode
    implements PropertyChangeListener {
        private static String badgedNamePattern = NbBundle.getMessage((Class)(class$org$netbeans$modules$project$ui$ProjectsRootNode == null ? (class$org$netbeans$modules$project$ui$ProjectsRootNode = ProjectsRootNode.class$("org.netbeans.modules.project.ui.ProjectsRootNode")) : class$org$netbeans$modules$project$ui$ProjectsRootNode), (String)"LBL_MainProject_BadgedNamePattern");

        public BadgingNode(Node n, boolean addSearchInfo) {
            super(n, null, (Lookup)(addSearchInfo ? new ProxyLookup(new Lookup[]{n.getLookup(), Lookups.singleton((Object)ProjectsRootNode.alwaysSearchableSearchInfo(SearchInfoFactory.createSearchInfoBySubnodes((Node)n)))}) : n.getLookup()));
            OpenProjectList.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)OpenProjectList.getDefault()));
        }

        public String getDisplayName() {
            String original = super.getDisplayName();
            return this.isMain() ? MessageFormat.format(badgedNamePattern, original) : original;
        }

        public String getHtmlDisplayName() {
            String htmlName = this.getOriginal().getHtmlDisplayName();
            String dispName = null;
            if (this.isMain() && htmlName == null) {
                dispName = super.getDisplayName();
                try {
                    dispName = XMLUtil.toElementContent((String)dispName);
                }
                catch (CharConversionException charConversionException) {
                    // empty catch block
                }
            }
            return this.isMain() ? "<b>" + (htmlName == null ? dispName : htmlName) + "</b>" : htmlName;
        }

        public void propertyChange(PropertyChangeEvent e) {
            if ("MainProject".equals(e.getPropertyName())) {
                this.fireDisplayNameChange(null, null);
            }
        }

        private boolean isMain() {
            Project p = (Project)this.getLookup().lookup(class$org$netbeans$api$project$Project == null ? (class$org$netbeans$api$project$Project = ProjectsRootNode.class$("org.netbeans.api.project.Project")) : class$org$netbeans$api$project$Project);
            return p != null && OpenProjectList.getDefault().isMainProject(p);
        }
    }

    static class ProjectChildren
    extends Children.Keys
    implements ChangeListener,
    PropertyChangeListener {
        private Map sources2projects = new WeakHashMap();
        int type;

        public ProjectChildren(int type) {
            this.type = type;
            OpenProjectList.getDefault().addPropertyChangeListener(this);
        }

        public void addNotify() {
            this.setKeys(this.getKeys());
        }

        public void removeNotify() {
            Iterator it = this.sources2projects.keySet().iterator();
            while (it.hasNext()) {
                Sources sources = (Sources)it.next();
                sources.removeChangeListener((ChangeListener)this);
            }
            this.sources2projects.clear();
            this.setKeys(Collections.EMPTY_LIST);
        }

        protected Node[] createNodes(Object key) {
            Sources sources;
            Project project = (Project)key;
            LogicalViewProvider lvp = (LogicalViewProvider)project.getLookup().lookup(class$org$netbeans$spi$project$ui$LogicalViewProvider == null ? (class$org$netbeans$spi$project$ui$LogicalViewProvider = ProjectsRootNode.class$("org.netbeans.spi.project.ui.LogicalViewProvider")) : class$org$netbeans$spi$project$ui$LogicalViewProvider);
            Node[] nodes = null;
            if (this.type == 0) {
                sources = ProjectUtils.getSources((Project)project);
                sources.removeChangeListener((ChangeListener)this);
                sources.addChangeListener((ChangeListener)this);
                this.sources2projects.put(sources, new WeakReference<Project>(project));
                nodes = PhysicalView.createNodesForProject(project);
            } else if (lvp == null) {
                ErrorManager.getDefault().log(16, "Warning - project " + ProjectUtils.getInformation((Project)project).getName() + " failed to supply a LogicalViewProvider in its lookup");
                sources = ProjectUtils.getSources((Project)project);
                sources.removeChangeListener((ChangeListener)this);
                sources.addChangeListener((ChangeListener)this);
                nodes = PhysicalView.createNodesForProject(project);
                nodes = nodes.length > 0 ? new Node[]{nodes[0]} : new Node[]{Node.EMPTY};
            } else {
                nodes = new Node[]{lvp.createLogicalView()};
                if (nodes[0].getLookup().lookup(class$org$netbeans$api$project$Project == null ? (class$org$netbeans$api$project$Project = ProjectsRootNode.class$("org.netbeans.api.project.Project")) : class$org$netbeans$api$project$Project) != project) {
                    ErrorManager.getDefault().log(16, "Warning - project " + ProjectUtils.getInformation((Project)project).getName() + " failed to supply itself in the lookup of the root node of its own logical view");
                }
            }
            Node[] badgedNodes = new Node[nodes.length];
            for (int i = 0; i < nodes.length; ++i) {
                badgedNodes[i] = this.type == 0 && !PhysicalView.isProjectDirNode(nodes[i]) ? nodes[i] : new BadgingNode(nodes[i], this.type == 1);
            }
            return badgedNodes;
        }

        public void propertyChange(PropertyChangeEvent e) {
            if ("OpenProjects".equals(e.getPropertyName())) {
                this.setKeys(this.getKeys());
            }
        }

        public void stateChanged(ChangeEvent e) {
            WeakReference projectRef = (WeakReference)this.sources2projects.get(e.getSource());
            if (projectRef == null) {
                return;
            }
            final Project project = (Project)projectRef.get();
            if (project == null) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProjectChildren.this.refreshKey(project);
                }
            });
        }

        public Collection getKeys() {
            List<Project> projects = Arrays.asList(OpenProjectList.getDefault().getOpenProjects());
            Collections.sort(projects, OpenProjectList.PROJECT_BY_DISPLAYNAME);
            return projects;
        }
    }

    private static class Handle
    implements Node.Handle {
        private static final long serialVersionUID = 78374332058L;
        private int viewType;

        public Handle(int viewType) {
            this.viewType = viewType;
        }

        public Node getNode() {
            return new ProjectsRootNode(this.viewType);
        }
    }
}

