/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.openide.ErrorManager;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.util.Enumerations;

final class MemoryFileSystem
extends AbstractFileSystem
implements AbstractFileSystem.Info,
AbstractFileSystem.Change,
AbstractFileSystem.List,
AbstractFileSystem.Attr {
    private static final ErrorManager ERR = ErrorManager.getDefault().getInstance(MemoryFileSystem.class.getName());
    private static final boolean LOGGABLE = ERR.isLoggable(1);
    private Date created = new Date();
    private Map entries = this.initEntry();

    public MemoryFileSystem() {
        this.attr = this;
        this.list = this;
        this.change = this;
        this.info = this;
        try {
            this.setSystemName("MemoryFileSystem" + String.valueOf(System.identityHashCode(this)));
        }
        catch (PropertyVetoException ex) {
            ex.printStackTrace();
        }
    }

    public MemoryFileSystem(String[] resources) {
        this();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < resources.length; ++i) {
            sb.append(resources[i]);
            this.getOrCreateEntry((String)resources[i]).data = (byte[])(resources[i].endsWith("/") ? null : new byte[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry getOrCreateEntry(String n) {
        if (n.length() > 0 && n.charAt(0) == '/') {
            n = n.substring(1);
        }
        boolean isValidEntry = this.isValidEntry(n);
        Map map = this.entries;
        synchronized (map) {
            Entry x = (Entry)this.entries.get(n);
            if (x == null || !isValidEntry) {
                x = new Entry(n);
                this.entries.put(n, x);
            }
            return x;
        }
    }

    private boolean isValidEntry(String n) {
        return this.isValidEntry(n, null);
    }

    private boolean isValidEntry(String n, Boolean expectedResult) {
        Reference ref;
        boolean retval = false;
        if (n.length() > 0 && n.charAt(0) == '/') {
            n = n.substring(1);
        }
        Entry x = (Entry)this.entries.get(n);
        FileObject fo = null;
        if (x != null && (ref = this.findReference(n)) != null) {
            fo = (FileObject)ref.get();
            boolean bl = retval = fo != null ? fo.isValid() : true;
        }
        if (LOGGABLE && expectedResult != null && retval != expectedResult) {
            MemoryFileSystem.logMessage("entry: " + x + " isValidReference.fo: " + (fo == null ? "null" : (fo.isValid() ? "valid" : "invalid")));
        }
        return retval;
    }

    public String getDisplayName() {
        return "MemoryFileSystem";
    }

    public boolean isReadOnly() {
        return false;
    }

    public Enumeration attributes(String name) {
        return this.isValidEntry(name) ? Collections.enumeration(this.getOrCreateEntry((String)name).attrs.keySet()) : Enumerations.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] children(String f) {
        if (f.length() > 0 && f.charAt(0) == '/') {
            f = f.substring(1);
        }
        if (f.length() > 0 && !f.endsWith("/")) {
            f = f + "/";
        }
        HashSet<String> l = new HashSet<String>();
        Map map = this.entries;
        synchronized (map) {
            Iterator it = this.entries.keySet().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                if (!name.startsWith(f) && f.trim().length() != 0) continue;
                int i = name.indexOf(47, f.length());
                String child = null;
                child = i > 0 ? name.substring(f.length(), i) : name.substring(f.length());
                if (child.trim().length() <= 0) continue;
                l.add(child);
            }
            return l.toArray(new String[0]);
        }
    }

    public void createData(String name) throws IOException {
        if (this.isValidEntry(name, Boolean.FALSE)) {
            StringBuffer message = new StringBuffer();
            message.append("File already exists: ").append(name);
            throw new IOException(message.toString());
        }
        this.getOrCreateEntry((String)name).data = new byte[0];
    }

    public void createFolder(String name) throws IOException {
        if (this.isValidEntry(name, Boolean.FALSE)) {
            StringBuffer message = new StringBuffer();
            message.append("Folder already exists: ").append(name);
            throw new IOException(message.toString());
        }
        this.getOrCreateEntry((String)name).data = null;
    }

    public void delete(String name) throws IOException {
        if (this.entries.remove(name) == null) {
            throw new IOException("No file to delete: " + name);
        }
    }

    public void deleteAttributes(String name) {
    }

    public boolean folder(String name) {
        return this.getOrCreateEntry((String)name).data == null;
    }

    public InputStream inputStream(String name) throws FileNotFoundException {
        byte[] arr = this.getOrCreateEntry((String)name).data;
        if (arr == null) {
            arr = new byte[]{};
        }
        return new ByteArrayInputStream(arr);
    }

    public Date lastModified(String name) {
        Date d = this.getOrCreateEntry((String)name).last;
        return d == null ? this.created : d;
    }

    public void lock(String name) throws IOException {
    }

    public void markUnimportant(String name) {
    }

    public String mimeType(String name) {
        return (String)this.getOrCreateEntry((String)name).attrs.get("mimeType");
    }

    public OutputStream outputStream(String name) throws IOException {
        class Out
        extends ByteArrayOutputStream {
            private final /* synthetic */ String val$name;

            Out(String string) {
                this.val$name = string;
            }

            public void close() throws IOException {
                super.close();
                ((MemoryFileSystem)MemoryFileSystem.this).getOrCreateEntry((String)this.val$name).data = this.toByteArray();
                ((MemoryFileSystem)MemoryFileSystem.this).getOrCreateEntry((String)this.val$name).last = new Date();
            }
        }
        return new Out(name);
    }

    public Object readAttribute(String name, String attrName) {
        return this.isValidEntry(name) ? this.getOrCreateEntry((String)name).attrs.get(attrName) : null;
    }

    public boolean readOnly(String name) {
        return false;
    }

    public void rename(String oldName, String newName) throws IOException {
        if (!this.isValidEntry(oldName)) {
            throw new IOException("The file to rename does not exist.");
        }
        if (this.isValidEntry(newName)) {
            throw new IOException("Cannot rename to existing file");
        }
        if (newName.length() > 0 && newName.charAt(0) == '/') {
            newName = newName.substring(1);
        }
        Entry e = this.getOrCreateEntry(oldName);
        this.entries.remove(oldName);
        this.entries.put(newName, e);
    }

    public void renameAttributes(String oldName, String newName) {
    }

    public long size(String name) {
        byte[] d = this.getOrCreateEntry((String)name).data;
        return d == null ? 0L : (long)d.length;
    }

    public void unlock(String name) {
    }

    public void writeAttribute(String name, String attrName, Object value) throws IOException {
        this.getOrCreateEntry((String)name).attrs.put(attrName, value);
    }

    private Map initEntry() {
        return Collections.synchronizedMap(!LOGGABLE ? new Hashtable() : new Hashtable(){

            public Object get(Object key) {
                Object retval = super.get(key);
                MemoryFileSystem.logMessage("called: GET key: " + key + " result: " + retval);
                return retval;
            }

            public Object put(Object key, Object value) {
                Object retval = super.put(key, value);
                MemoryFileSystem.logMessage("called: PUT key: " + key + " value: " + value + " result: " + retval);
                return retval;
            }

            public Object remove(Object key) {
                Object retval = super.remove(key);
                MemoryFileSystem.logMessage("called: REMOVE key: " + key + " result: " + retval);
                return retval;
            }
        });
    }

    private static void logMessage(String message) {
        if (LOGGABLE) {
            StringBuffer sb = new StringBuffer();
            sb.append(" -> ").append(message);
            ERR.log(1, sb.toString());
        }
    }

    static final class Entry {
        public HashMap attrs = new HashMap();
        public byte[] data;
        public Date last;
        private final String entryName;

        Entry(String entryName) {
            this.entryName = entryName;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(" [").append(this.entryName);
            sb.append(" -> ").append(super.toString());
            sb.append("] ");
            return sb.toString();
        }
    }
}

