/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tools.generator;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.netbeans.modules.xml.tools.generator.ElementBindings;
import org.netbeans.modules.xml.tools.generator.GenerateSupportUtils;
import org.netbeans.modules.xml.tools.generator.ParsletBindings;
import org.netbeans.modules.xml.tools.generator.SAXGeneratorAbstractPanel;
import org.netbeans.modules.xml.tools.generator.Util;
import org.netbeans.modules.xml.tools.generator.ValidatingTextField;
import org.openide.src.Identifier;
import org.openide.src.Type;
import org.openide.util.Utilities;

public final class SAXGeneratorParsletPanel
extends SAXGeneratorAbstractPanel {
    private static final long serialVersionUID = 6038099487791703339L;
    private TableModel tableModel;
    private static final int ELEMENT_COLUMN = 0;
    private static final int METHOD_COLUMN = 1;
    private static final int TYPE_COLUMN = 2;
    private static final int COLUMNS = 3;
    private static final String NO_METHOD = "[none]";
    private final String[] COLUMN_NAMES = new String[]{Util.THIS.getString("SAXGeneratorParsletPanel.table.column1"), Util.THIS.getString("SAXGeneratorParsletPanel.table.column2"), Util.THIS.getString("SAXGeneratorParsletPanel.table.column3")};
    private final ValidatingTextField.Validator TYPE_VALIDATOR = new ValidatingTextField.Validator(){

        public boolean isValid(String value) {
            boolean ret = GenerateSupportUtils.isValidReturnType(value);
            SAXGeneratorParsletPanel.this.setValid(ret);
            return ret;
        }

        public String getReason() {
            return Util.THIS.getString("MSG_parslet_err_1");
        }
    };
    private final ValidatingTextField.Validator METHOD_VALIDATOR = new ValidatingTextField.Validator(){

        public boolean isValid(String value) {
            boolean ret = SAXGeneratorParsletPanel.NO_METHOD.equals(value) || Utilities.isJavaIdentifier((String)value);
            SAXGeneratorParsletPanel.this.setValid(ret);
            return ret;
        }

        public String getReason() {
            return Util.THIS.getString("MSG_parslet_err_2");
        }
    };
    private JTable table;
    private JTextArea descTextArea;
    private JScrollPane tableScrollPane;
    static /* synthetic */ Class class$java$lang$String;

    private void initComponents() {
        this.descTextArea = new JTextArea();
        this.tableScrollPane = new JScrollPane();
        this.table = new JTable();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(480, 350));
        this.setName(Util.THIS.getString("SAXGeneratorParsletPanel.Form.name"));
        this.descTextArea.setWrapStyleWord(true);
        this.descTextArea.setLineWrap(true);
        this.descTextArea.setEditable(false);
        this.descTextArea.setForeground(new Color(102, 102, 153));
        this.descTextArea.setFont(UIManager.getFont("Label.font"));
        this.descTextArea.setText(ResourceBundle.getBundle("org/netbeans/modules/xml/tools/generator/Bundle").getString("DESC_saxw_convertors"));
        this.descTextArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        this.descTextArea.setEnabled(false);
        this.descTextArea.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.descTextArea, gridBagConstraints);
        this.table.setModel(this.tableModel);
        this.tableScrollPane.setViewportView(this.table);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.tableScrollPane, gridBagConstraints);
    }

    private void initModels() {
        this.tableModel = new ParsletsTableModel();
    }

    protected void initView() {
        this.initModels();
        this.initComponents();
        this.table = new ParsletsTable();
        this.table.setModel(this.tableModel);
        this.tableScrollPane.setViewportView(this.table);
        this.initAccessibility();
    }

    protected void updateView() {
    }

    protected void updateModel() {
    }

    public void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_SAXGeneratorParsletPanel"));
        this.table.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_ParsletsTable"));
        this.table.getAccessibleContext().setAccessibleName(Util.THIS.getString("ACSN_ParsletsTable"));
    }

    private class ParsletsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 3516749023312029787L;

        private ParsletsTableModel() {
        }

        public String getColumnName(int col) {
            return SAXGeneratorParsletPanel.this.COLUMN_NAMES[col];
        }

        public int getRowCount() {
            if (SAXGeneratorParsletPanel.this.model == null) {
                return 0;
            }
            return SAXGeneratorParsletPanel.this.model.getElementBindings().size();
        }

        public int getColumnCount() {
            return 3;
        }

        public Object getValueAt(int row, int column) {
            ElementBindings.Entry entry = SAXGeneratorParsletPanel.this.model.getElementBindings().getEntry(row);
            ParsletBindings parslets = SAXGeneratorParsletPanel.this.model.getParsletBindings();
            String parslet = entry.getParslet();
            switch (column) {
                case 0: {
                    return entry.getElement();
                }
                case 2: {
                    if (parslet == null) {
                        return (class$java$lang$String == null ? (class$java$lang$String = SAXGeneratorParsletPanel.class$("java.lang.String")) : class$java$lang$String).getName();
                    }
                    return parslets.getReturnType(parslet).toString();
                }
                case 1: {
                    if (parslet == null) {
                        return SAXGeneratorParsletPanel.NO_METHOD;
                    }
                    return parslet;
                }
            }
            return null;
        }

        public void setValueAt(Object value, int row, int col) {
            if (col == 2 ? !SAXGeneratorParsletPanel.this.TYPE_VALIDATOR.isValid((String)value) : col == 1 && !SAXGeneratorParsletPanel.this.METHOD_VALIDATOR.isValid((String)value)) {
                return;
            }
            ElementBindings binds = SAXGeneratorParsletPanel.this.model.getElementBindings();
            ElementBindings.Entry entry = binds.getEntry(row);
            String currentParslet = entry.getParslet();
            ParsletBindings parslets = SAXGeneratorParsletPanel.this.model.getParsletBindings();
            ParsletBindings.Entry parsletEntry = parslets.getEntry(currentParslet);
            switch (col) {
                case 2: {
                    if (currentParslet == null) break;
                    if (binds.getParsletUsageCount(currentParslet) > 1) {
                        if (!Util.THIS.isLoggable()) break;
                        Util.THIS.debug("Cannot change");
                        break;
                    }
                    Type returnType = Type.createClass((Identifier)Identifier.create((String)((String)value)));
                    parsletEntry.setReturnType(returnType);
                    break;
                }
                case 1: {
                    String identifier = (String)value;
                    String oldReturnType = parslets.getReturnType(currentParslet).toString();
                    if (binds.getParsletUsageCount(currentParslet) == 1) {
                        parslets.remove(currentParslet);
                    }
                    if (!SAXGeneratorParsletPanel.NO_METHOD.equals(identifier)) {
                        entry.setParslet(identifier);
                        if (parslets.getEntry(identifier) == null) {
                            parslets.put(identifier, oldReturnType);
                            break;
                        }
                        this.fireTableRowsUpdated(row, row);
                        break;
                    }
                    entry.setParslet(null);
                    this.fireTableRowsUpdated(row, row);
                }
            }
        }

        public boolean isCellEditable(int row, int col) {
            return col != 0;
        }
    }

    private class ParsletsTable
    extends JTable {
        private static final long serialVersionUID = 1076091649418718319L;

        public ParsletsTable() {
            this.getTableHeader().setReorderingAllowed(false);
            this.setRowHeight(Util.getTextCellHeight(this));
        }

        public TableCellEditor getCellEditor(int row, int column) {
            switch (column) {
                case 1: {
                    Vector all = new Vector(SAXGeneratorParsletPanel.this.model.getParsletBindings().keySet());
                    JComboBox editor = new JComboBox(all);
                    editor.addItem(SAXGeneratorParsletPanel.NO_METHOD);
                    ValidatingTextField methodInput = new ValidatingTextField();
                    methodInput.setValidator(SAXGeneratorParsletPanel.this.METHOD_VALIDATOR);
                    editor.setEditor(methodInput);
                    editor.setEditable(true);
                    return new DefaultCellEditor(editor);
                }
                case 2: {
                    String[] vals = new String[]{"int", "boolean", "long", "java.util.Date", "java.net.URL", "java.lang.String", "java.lang.String[]"};
                    JComboBox<String> type_editor = new JComboBox<String>(vals);
                    ValidatingTextField typeInput = new ValidatingTextField();
                    typeInput.setValidator(SAXGeneratorParsletPanel.this.TYPE_VALIDATOR);
                    type_editor.setEditor(typeInput);
                    type_editor.setEditable(true);
                    return new DefaultCellEditor(type_editor);
                }
            }
            return super.getCellEditor(row, column);
        }
    }
}

