/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.platform.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.java.platform.InstallerRegistry;
import org.netbeans.spi.java.platform.CustomPlatformInstall;
import org.netbeans.spi.java.platform.GeneralPlatformInstall;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

class SelectorPanel
extends JPanel
implements ItemListener {
    private Map installersByButtonModels = new IdentityHashMap();
    private ButtonGroup group;
    private Panel firer;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SelectorPanel(Panel firer) {
        this.firer = firer;
        this.initComponents();
        this.postInitComponents();
        this.setName(NbBundle.getMessage((Class)SelectorPanel.class, (String)"TXT_SelectPlatformTypeTitle"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)SelectorPanel.class, (String)"AD_SelectPlatformType"));
    }

    private void postInitComponents() {
        InstallerRegistry regs = InstallerRegistry.getDefault();
        List installers = regs.getAllInstallers();
        this.group = new ButtonGroup();
        JLabel label = new JLabel(NbBundle.getMessage((Class)SelectorPanel.class, (String)"TXT_SelectPlatform"));
        label.setDisplayedMnemonic(NbBundle.getMessage((Class)SelectorPanel.class, (String)"AD_SelectPlatform").charAt(0));
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = -1;
        c.gridx = -1;
        c.gridheight = 1;
        c.gridwidth = 0;
        c.fill = 2;
        c.anchor = 18;
        c.weightx = 1.0;
        c.insets = new Insets(12, 12, 6, 12);
        ((GridBagLayout)this.getLayout()).setConstraints(label, c);
        this.add(label);
        Iterator it = installers.iterator();
        int i = 0;
        while (it.hasNext()) {
            GeneralPlatformInstall pi = (GeneralPlatformInstall)it.next();
            JRadioButton button = new JRadioButton(pi.getDisplayName());
            if (i == 0) {
                label.setLabelFor(button);
            }
            button.addItemListener(this);
            this.installersByButtonModels.put(button.getModel(), pi);
            this.group.add(button);
            c = new GridBagConstraints();
            c.gridy = -1;
            c.gridx = -1;
            c.gridheight = 1;
            c.gridwidth = 0;
            c.fill = 2;
            c.anchor = 18;
            c.weightx = 1.0;
            c.insets = new Insets(6, 18, it.hasNext() ? 0 : 12, 12);
            ((GridBagLayout)this.getLayout()).setConstraints(button, c);
            this.add(button);
            ++i;
        }
        JPanel pad = new JPanel();
        c = new GridBagConstraints();
        c.gridy = -1;
        c.gridx = -1;
        c.gridheight = 1;
        c.gridwidth = 0;
        c.fill = 1;
        c.anchor = 18;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(12, 0, 0, 12);
        ((GridBagLayout)this.getLayout()).setConstraints(pad, c);
        this.add(pad);
    }

    private void readSettings() {
        if (this.group.getSelection() == null) {
            Enumeration<AbstractButton> buttonEnum = this.group.getElements();
            if (!$assertionsDisabled && !buttonEnum.hasMoreElements()) {
                throw new AssertionError();
            }
            ((JRadioButton)buttonEnum.nextElement()).setSelected(true);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        this.firer.fireChange();
    }

    boolean selectInstaller(GeneralPlatformInstall install) {
        if (!$assertionsDisabled && install == null) {
            throw new AssertionError();
        }
        Iterator it = this.installersByButtonModels.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (!entry.getValue().equals(install)) continue;
            ButtonModel model = (ButtonModel)entry.getKey();
            model.setSelected(true);
            return true;
        }
        return false;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
    }

    static {
        $assertionsDisabled = !SelectorPanel.class.desiredAssertionStatus();
    }

    public static class Panel
    implements WizardDescriptor.Panel {
        private List listeners;
        private SelectorPanel component;
        static final /* synthetic */ boolean $assertionsDisabled;

        public synchronized void removeChangeListener(ChangeListener l) {
            if (!$assertionsDisabled && l == null) {
                throw new AssertionError();
            }
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(l);
        }

        public synchronized void addChangeListener(ChangeListener l) {
            if (!$assertionsDisabled && l == null) {
                throw new AssertionError();
            }
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(l);
        }

        public void readSettings(Object settings) {
            ((SelectorPanel)this.getComponent()).readSettings();
        }

        public void storeSettings(Object settings) {
        }

        public HelpCtx getHelp() {
            return new HelpCtx(class$org$netbeans$modules$java$platform$wizard$SelectorPanel == null ? (class$org$netbeans$modules$java$platform$wizard$SelectorPanel = SelectorPanel.class$("org.netbeans.modules.java.platform.wizard.SelectorPanel")) : class$org$netbeans$modules$java$platform$wizard$SelectorPanel);
        }

        public boolean isValid() {
            return this.component != null;
        }

        public Component getComponent() {
            if (this.component == null) {
                this.component = new SelectorPanel(this);
            }
            return this.component;
        }

        public GeneralPlatformInstall getInstaller() {
            SelectorPanel c = (SelectorPanel)this.getComponent();
            ButtonModel bm = c.group.getSelection();
            if (bm != null) {
                return (GeneralPlatformInstall)c.installersByButtonModels.get(bm);
            }
            return null;
        }

        public WizardDescriptor.InstantiatingIterator getInstallerIterator() {
            GeneralPlatformInstall platformInstall = this.getInstaller();
            if (platformInstall instanceof CustomPlatformInstall) {
                return ((CustomPlatformInstall)platformInstall).createIterator();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireChange() {
            ChangeListener[] _listeners;
            Panel panel = this;
            synchronized (panel) {
                if (this.listeners == null) {
                    return;
                }
                _listeners = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
            }
            ChangeEvent event = new ChangeEvent(this);
            for (int i = 0; i < _listeners.length; ++i) {
                _listeners[i].stateChanged(event);
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$java$platform$wizard$SelectorPanel == null ? (class$org$netbeans$modules$java$platform$wizard$SelectorPanel = SelectorPanel.class$("org.netbeans.modules.java.platform.wizard.SelectorPanel")) : class$org$netbeans$modules$java$platform$wizard$SelectorPanel).desiredAssertionStatus();
        }
    }
}

