/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.platform.ui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.java.platform.wizard.PlatformInstallIterator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class PlatformsCustomizer
extends JPanel
implements PropertyChangeListener,
VetoableChangeListener,
ExplorerManager.Provider {
    private static final String TEMPLATE = "Templates/Services/Platforms/org-netbeans-api-java-Platform/javaplatform.xml";
    private static final String STORAGE = "Services/Platforms/org-netbeans-api-java-Platform";
    private PlatformCategoriesChildren children;
    private ExplorerManager manager;
    private final JavaPlatform initialPlatform;
    private JButton addButton;
    private JPanel cards;
    private JPanel clientArea;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel messageArea;
    private JTextField platformHome;
    private JTextField platformName;
    private BeanTreeView platforms;
    private JButton removeButton;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PlatformsCustomizer(JavaPlatform initialPlatform) {
        this.initialPlatform = initialPlatform == null ? JavaPlatformManager.getDefault().getDefaultPlatform() : initialPlatform;
        this.initComponents();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedNodes".equals(evt.getPropertyName())) {
            Node[] nodes = (Node[])evt.getNewValue();
            if (nodes.length != 1) {
                this.selectPlatform(null);
            } else {
                this.selectPlatform(nodes[0]);
            }
        }
    }

    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        Node[] nodes;
        if ("selectedNodes".equals(evt.getPropertyName()) && (nodes = (Node[])evt.getNewValue()).length > 1) {
            throw new PropertyVetoException("Invalid length", evt);
        }
    }

    public synchronized ExplorerManager getExplorerManager() {
        if (this.manager == null) {
            this.manager = new ExplorerManager();
            this.manager.setRootContext((Node)new AbstractNode((Children)this.getChildren()));
            this.manager.addPropertyChangeListener((PropertyChangeListener)this);
            this.manager.addVetoableChangeListener((VetoableChangeListener)this);
        }
        return this.manager;
    }

    public void addNotify() {
        super.addNotify();
        this.expandPlatforms(this.initialPlatform);
    }

    private void initComponents() {
        this.jPanel3 = new JPanel();
        this.platforms = new PlatformsView();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.cards = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.platformName = new JTextField();
        this.jLabel2 = new JLabel();
        this.platformHome = new JTextField();
        this.clientArea = new JPanel();
        this.messageArea = new JPanel();
        this.jLabel3 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/java/platform/ui/Bundle").getString("AD_PlatformsCustomizer"));
        this.platforms.setBorder((Border)new EtchedBorder());
        this.platforms.setPreferredSize(new Dimension(200, 334));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 12, 12, 6);
        this.add((Component)this.platforms, gridBagConstraints);
        this.platforms.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/java/platform/ui/Bundle").getString("AN_PlatformsCustomizerPlatforms"));
        this.platforms.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/java/platform/ui/Bundle").getString("AD_PlatformsCustomizerPlatforms"));
        this.addButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/java/platform/ui/Bundle").getString("MNE_AddPlatform").charAt(0));
        this.addButton.setText(ResourceBundle.getBundle("org/netbeans/modules/java/platform/ui/Bundle").getString("CTL_AddPlatform"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlatformsCustomizer.this.addNewPlatform(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 6);
        this.add((Component)this.addButton, gridBagConstraints);
        this.addButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/java/platform/ui/Bundle").getString("AD_AddPlatform"));
        this.removeButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/java/platform/ui/Bundle").getString("MNE_Remove").charAt(0));
        this.removeButton.setText(ResourceBundle.getBundle("org/netbeans/modules/java/platform/ui/Bundle").getString("CTL_Remove"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlatformsCustomizer.this.removePlatform(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.add((Component)this.removeButton, gridBagConstraints);
        this.removeButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/java/platform/ui/Bundle").getString("AD_Remove"));
        this.cards.setLayout(new CardLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/java/platform/ui/Bundle").getString("MNE_PlatformName").charAt(0));
        this.jLabel1.setLabelFor(this.platformName);
        this.jLabel1.setText(ResourceBundle.getBundle("org/netbeans/modules/java/platform/ui/Bundle").getString("CTL_PlatformName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.platformName.setColumns(25);
        this.platformName.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.platformName, gridBagConstraints);
        this.platformName.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/java/platform/ui/Bundle").getString("AD_PlatformName"));
        this.jLabel2.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/java/platform/ui/Bundle").getString("MNE_PlatformHome").charAt(0));
        this.jLabel2.setLabelFor(this.platformHome);
        this.jLabel2.setText(ResourceBundle.getBundle("org/netbeans/modules/java/platform/ui/Bundle").getString("CTL_PlatformHome"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 12, 0);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.platformHome.setColumns(25);
        this.platformHome.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 12, 0);
        this.jPanel1.add((Component)this.platformHome, gridBagConstraints);
        this.platformHome.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/java/platform/ui/Bundle").getString("AD_PlatformHome"));
        this.clientArea.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.clientArea, gridBagConstraints);
        this.cards.add((Component)this.jPanel1, "card2");
        this.messageArea.setLayout(new GridBagLayout());
        this.cards.add((Component)this.messageArea, "card3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 6, 12, 12);
        this.add((Component)this.cards, gridBagConstraints);
        this.jLabel3.setLabelFor((Component)this.platforms);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)ResourceBundle.getBundle("org/netbeans/modules/java/platform/ui/Bundle").getString("TXT_PlatformsList"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.add((Component)this.jLabel3, gridBagConstraints);
    }

    private void removePlatform(ActionEvent evt) {
        Node[] nodes = this.getExplorerManager().getSelectedNodes();
        if (nodes.length != 1) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Illegal number of selected nodes");
            }
            return;
        }
        DataObject dobj = (DataObject)nodes[0].getLookup().lookup(DataObject.class);
        if (dobj == null) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)("Can not find platform definition for node: " + nodes[0].getDisplayName()));
            }
            return;
        }
        try {
            dobj.delete();
            this.getChildren().refreshPlatforms();
            this.expandPlatforms(null);
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNewPlatform(ActionEvent evt) {
        try {
            WizardDescriptor wiz = new WizardDescriptor((WizardDescriptor.Iterator)PlatformInstallIterator.create());
            DataObject template = DataObject.find((FileObject)Repository.getDefault().getDefaultFileSystem().findResource(TEMPLATE));
            wiz.putProperty("targetTemplate", (Object)template);
            DataFolder folder = DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().findResource(STORAGE));
            wiz.putProperty("targetFolder", (Object)folder);
            wiz.putProperty("WizardPanel_autoWizardStyle", (Object)Boolean.TRUE);
            wiz.putProperty("WizardPanel_contentDisplayed", (Object)Boolean.TRUE);
            wiz.putProperty("WizardPanel_contentNumbered", (Object)Boolean.TRUE);
            wiz.setTitle(NbBundle.getMessage((Class)PlatformsCustomizer.class, (String)"CTL_AddPlatformTitle"));
            wiz.setTitleFormat(new MessageFormat("{0}"));
            Dialog dlg = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wiz);
            try {
                dlg.setVisible(true);
                if (wiz.getValue() == WizardDescriptor.FINISH_OPTION) {
                    this.getChildren().refreshPlatforms();
                    Set result = wiz.getInstantiatedObjects();
                    this.expandPlatforms(result.size() == 0 ? null : (JavaPlatform)result.iterator().next());
                }
            }
            finally {
                dlg.dispose();
            }
        }
        catch (DataObjectNotFoundException dfne) {
            ErrorManager.getDefault().notify((Throwable)dfne);
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
        }
    }

    private synchronized PlatformCategoriesChildren getChildren() {
        if (this.children == null) {
            this.children = new PlatformCategoriesChildren();
        }
        return this.children;
    }

    private void selectPlatform(Node pNode) {
        Component component;
        this.clientArea.removeAll();
        this.messageArea.removeAll();
        this.removeButton.setEnabled(false);
        if (pNode == null) {
            ((CardLayout)this.cards.getLayout()).last(this.cards);
            return;
        }
        JPanel target = this.messageArea;
        JavaPlatform platform = (JavaPlatform)pNode.getLookup().lookup(JavaPlatform.class);
        if (platform != null) {
            this.removeButton.setEnabled(PlatformsCustomizer.isDefaultPLatform(platform));
            if (platform.getInstallFolders().size() != 0) {
                File file;
                this.platformName.setText(pNode.getDisplayName());
                Iterator it = platform.getInstallFolders().iterator();
                if (it.hasNext() && (file = FileUtil.toFile((FileObject)((FileObject)it.next()))) != null) {
                    this.platformHome.setText(file.getAbsolutePath());
                }
                target = this.clientArea;
            }
        }
        if (pNode.hasCustomizer() && (component = pNode.getCustomizer()) != null) {
            PlatformsCustomizer.addComponent(target, component);
        }
        target.revalidate();
        CardLayout cl = (CardLayout)this.cards.getLayout();
        if (target == this.clientArea) {
            cl.first(this.cards);
        } else {
            cl.last(this.cards);
        }
    }

    private static void addComponent(Container container, Component component) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = -1;
        c.gridx = -1;
        c.gridwidth = 0;
        c.gridheight = 0;
        c.fill = 1;
        c.anchor = 18;
        c.weighty = 1.0;
        c.weightx = 1.0;
        ((GridBagLayout)container.getLayout()).setConstraints(component, c);
        container.add(component);
    }

    private static boolean isDefaultPLatform(JavaPlatform platform) {
        JavaPlatform defaultPlatform = JavaPlatformManager.getDefault().getDefaultPlatform();
        return defaultPlatform != null && !defaultPlatform.equals(platform);
    }

    private void expandPlatforms(JavaPlatform platform) {
        ExplorerManager mgr = this.getExplorerManager();
        Node node = mgr.getRootContext();
        PlatformsCustomizer.expandAllNodes(this.platforms, node, mgr, platform);
    }

    private static void expandAllNodes(BeanTreeView btv, Node node, ExplorerManager mgr, JavaPlatform platform) {
        btv.expandNode(node);
        Children ch = node.getChildren();
        if (ch == Children.LEAF) {
            if (platform != null && platform.equals(node.getLookup().lookup(JavaPlatform.class))) {
                try {
                    mgr.setSelectedNodes(new Node[]{node});
                }
                catch (PropertyVetoException e) {
                    // empty catch block
                }
            }
            return;
        }
        Node[] nodes = ch.getNodes(true);
        for (int i = 0; i < nodes.length; ++i) {
            PlatformsCustomizer.expandAllNodes(btv, nodes[i], mgr, platform);
        }
    }

    static {
        $assertionsDisabled = !PlatformsCustomizer.class.desiredAssertionStatus();
    }

    private static class PlatformNodeComparator
    implements Comparator {
        private PlatformNodeComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof Node) || !(o2 instanceof Node)) {
                throw new IllegalArgumentException();
            }
            String dn1 = ((Node)o1).getDisplayName();
            String dn2 = ((Node)o2).getDisplayName();
            return dn1.compareTo(dn2);
        }
    }

    private static class PlatformCategoriesChildren
    extends Children.Keys {
        private PlatformCategoriesChildren() {
        }

        protected void addNotify() {
            super.addNotify();
            this.refreshPlatforms();
        }

        protected void removeNotify() {
            super.removeNotify();
        }

        protected Node[] createNodes(Object key) {
            if (key instanceof PlatformCategoriesDescriptor) {
                PlatformCategoriesDescriptor desc = (PlatformCategoriesDescriptor)key;
                return new Node[]{new PlatformCategoryNode(desc)};
            }
            if (key instanceof Node) {
                return new Node[]{new FilterNode((Node)key, Children.LEAF)};
            }
            return new Node[0];
        }

        private void refreshPlatforms() {
            FileObject storage = Repository.getDefault().getDefaultFileSystem().findResource(PlatformsCustomizer.STORAGE);
            if (storage != null) {
                HashMap<String, PlatformCategoriesDescriptor> categories = new HashMap<String, PlatformCategoriesDescriptor>();
                FileObject[] children = storage.getChildren();
                for (int i = 0; i < children.length; ++i) {
                    try {
                        DataObject dobj = DataObject.find((FileObject)children[i]);
                        Node node = dobj.getNodeDelegate();
                        JavaPlatform platform = (JavaPlatform)node.getLookup().lookup(class$org$netbeans$api$java$platform$JavaPlatform == null ? PlatformsCustomizer.class$("org.netbeans.api.java.platform.JavaPlatform") : class$org$netbeans$api$java$platform$JavaPlatform);
                        if (platform != null) {
                            String platformType = platform.getSpecification().getName();
                            if (platformType != null) {
                                PlatformCategoriesDescriptor platforms = (PlatformCategoriesDescriptor)categories.get(platformType = platformType.toUpperCase(Locale.ENGLISH));
                                if (platforms == null) {
                                    platforms = new PlatformCategoriesDescriptor(platformType);
                                    categories.put(platformType, platforms);
                                }
                                platforms.add(node);
                                continue;
                            }
                            ErrorManager.getDefault().log("Platform: " + platform.getDisplayName() + " has invalid specification.");
                            continue;
                        }
                        ErrorManager.getDefault().log("Platform node for : " + node.getDisplayName() + " has no platform in its lookup.");
                        continue;
                    }
                    catch (DataObjectNotFoundException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                }
                ArrayList keys = new ArrayList(categories.values());
                Collections.sort(keys);
                this.setKeys(keys);
            }
        }
    }

    private static class PlatformCategoryNode
    extends AbstractNode {
        private final PlatformCategoriesDescriptor desc;
        private Node iconDelegate;

        public PlatformCategoryNode(PlatformCategoriesDescriptor desc) {
            super((Children)new PlatformsChildren(desc.getPlatform()));
            this.desc = desc;
            this.iconDelegate = DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot()).getNodeDelegate();
        }

        public String getName() {
            return this.desc.getName();
        }

        public String getDisplayName() {
            return this.getName();
        }

        public Image getIcon(int type) {
            return this.iconDelegate.getIcon(type);
        }

        public Image getOpenedIcon(int type) {
            return this.iconDelegate.getOpenedIcon(type);
        }
    }

    private static class PlatformsChildren
    extends Children.Keys {
        private List platforms;

        public PlatformsChildren(List platforms) {
            this.platforms = platforms;
        }

        protected void addNotify() {
            super.addNotify();
            this.setKeys(this.platforms);
        }

        protected void removeNotify() {
            super.removeNotify();
            this.setKeys(new Object[0]);
        }

        protected Node[] createNodes(Object key) {
            return new Node[]{new FilterNode((Node)key, Children.LEAF)};
        }
    }

    private static class PlatformCategoriesDescriptor
    implements Comparable {
        private final String categoryName;
        private final List platforms;
        private boolean changed = false;
        static final /* synthetic */ boolean $assertionsDisabled;

        public PlatformCategoriesDescriptor(String categoryName) {
            if (!$assertionsDisabled && categoryName == null) {
                throw new AssertionError();
            }
            this.categoryName = categoryName;
            this.platforms = new ArrayList();
        }

        public String getName() {
            return this.categoryName;
        }

        public List getPlatform() {
            if (this.changed) {
                Collections.sort(this.platforms, new PlatformNodeComparator());
                this.changed = false;
            }
            return Collections.unmodifiableList(this.platforms);
        }

        public void add(Node node) {
            this.platforms.add(node);
            this.changed = true;
        }

        public int hashCode() {
            return this.categoryName.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof PlatformCategoriesDescriptor) {
                PlatformCategoriesDescriptor desc = (PlatformCategoriesDescriptor)other;
                return this.categoryName.equals(desc.categoryName) && this.platforms.size() == desc.platforms.size();
            }
            return false;
        }

        public int compareTo(Object other) {
            if (!(other instanceof PlatformCategoriesDescriptor)) {
                throw new IllegalArgumentException();
            }
            PlatformCategoriesDescriptor desc = (PlatformCategoriesDescriptor)other;
            return this.categoryName.compareTo(desc.categoryName);
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$java$platform$ui$PlatformsCustomizer == null ? (class$org$netbeans$modules$java$platform$ui$PlatformsCustomizer = PlatformsCustomizer.class$("org.netbeans.modules.java.platform.ui.PlatformsCustomizer")) : class$org$netbeans$modules$java$platform$ui$PlatformsCustomizer).desiredAssertionStatus();
        }
    }

    private static class PlatformsView
    extends BeanTreeView {
        public PlatformsView() {
            this.setPopupAllowed(false);
            this.setDefaultActionAllowed(false);
            this.setRootVisible(false);
            this.tree.setEditable(false);
            this.tree.setShowsRootHandles(false);
        }
    }
}

