/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.fromdb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.persistence.dd.JavaPersistenceQLKeywords;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityMember;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.ChangeSupport;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.PersistenceGenerator;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.SourceGroupSupport;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.Table;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableClosure;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SelectedTables {
    private final PersistenceGenerator persistenceGen;
    private final Map<Table, String> table2ClassName = new HashMap<Table, String>();
    private final Map<Table, Set<Problem>> table2Problems = new TreeMap<Table, Set<Problem>>();
    private final ChangeListener tableClosureListener = new TableClosureListener();
    private final ChangeSupport changeSupport = new ChangeSupport(this);
    private TableClosure tableClosure;
    private SourceGroup location;
    private String packageName;
    private FileObject targetFolder;
    private Set<Table> validatedTables = Collections.emptySet();

    public SelectedTables(PersistenceGenerator persistenceGen, TableClosure tableClosure, SourceGroup location, String packageName) throws IOException {
        assert (persistenceGen != null);
        this.persistenceGen = persistenceGen;
        this.setTableClosureAndTargetFolder(tableClosure, location, packageName);
    }

    public void setTableClosureAndTargetFolder(TableClosure tableClosure, SourceGroup location, String packageName) throws IOException {
        assert (tableClosure != null);
        boolean tableClosureChanged = this.changeTableClosure(tableClosure);
        boolean targetFolderChanged = this.changeTargetFolder(location, packageName);
        if (tableClosureChanged || targetFolderChanged) {
            this.revalidateTables();
        }
    }

    public void setTargetFolder(SourceGroup location, String packageName) throws IOException {
        if (this.changeTargetFolder(location, packageName)) {
            this.revalidateTables();
        }
    }

    private boolean changeTableClosure(TableClosure tableClosure) {
        if (!tableClosure.equals(this.tableClosure)) {
            if (this.tableClosure != null) {
                this.tableClosure.removeChangeListener(this.tableClosureListener);
            }
            this.tableClosure = tableClosure;
            this.table2ClassName.clear();
            this.tableClosure.addChangeListener(this.tableClosureListener);
            return true;
        }
        return false;
    }

    private boolean changeTargetFolder(SourceGroup location, String packageName) throws IOException {
        if (!Utilities.compareObjects((Object)location, (Object)this.location) || !Utilities.compareObjects((Object)packageName, (Object)this.packageName)) {
            this.location = location;
            this.packageName = packageName;
            this.targetFolder = location != null && packageName != null ? SourceGroupSupport.getFolderForPackage(location, packageName, false) : null;
            return true;
        }
        return false;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    private void revalidateTables() {
        this.validatedTables = Collections.emptySet();
        this.table2Problems.clear();
        this.validateTables();
    }

    private void validateTables() {
        HashSet<Table> addedTables = new HashSet<Table>(this.tableClosure.getSelectedTables());
        addedTables.removeAll(this.validatedTables);
        HashSet<Table> removedTables = new HashSet<Table>(this.validatedTables);
        removedTables.removeAll(this.tableClosure.getSelectedTables());
        for (Table table : removedTables) {
            this.table2Problems.remove(table);
        }
        for (Table table : addedTables) {
            this.putProblems(table, this.validateClassName(this.getClassName(table)));
        }
        this.validatedTables = new HashSet<Table>(this.tableClosure.getSelectedTables());
        this.changeSupport.fireChange();
    }

    public List<Table> getTables() {
        ArrayList<Table> result = new ArrayList<Table>(this.tableClosure.getSelectedTables());
        Collections.sort(result);
        return result;
    }

    public String getClassName(Table table) {
        assert (table != null);
        String className = this.table2ClassName.get(table);
        if (className == null) {
            className = EntityMember.makeClassName(table.getName());
            className = this.persistenceGen.generateEntityName(className);
        }
        return className;
    }

    public void setClassName(Table table, String className) {
        assert (table != null);
        assert (className != null);
        this.table2ClassName.put(table, className);
        this.putProblems(table, this.validateClassName(className));
        this.changeSupport.fireChange();
    }

    private void putProblems(Table table, Set<Problem> problems) {
        if (problems.isEmpty()) {
            this.table2Problems.remove(table);
        } else {
            this.table2Problems.put(table, problems);
        }
    }

    private Set<Problem> validateClassName(String className) {
        EnumSet<Problem> problems = EnumSet.noneOf(Problem.class);
        if (!Utilities.isJavaIdentifier((String)className)) {
            problems.add(Problem.NO_JAVA_IDENTIFIER);
        }
        if (JavaPersistenceQLKeywords.isKeyword(className)) {
            problems.add(Problem.JPA_QL_IDENTIFIER);
        }
        if (this.targetFolder != null && this.targetFolder.getFileObject(className, "java") != null) {
            problems.add(Problem.ALREADY_EXISTS);
        }
        return problems;
    }

    public void ensureUniqueClassNames() {
        Set<Table> tables = this.tableClosure.getSelectedTables();
        if (this.targetFolder != null) {
            for (Table t : tables) {
                String className = this.getClassName(t);
                boolean existingFile = this.targetFolder.getFileObject(className, "java") != null;
                if (!existingFile) continue;
                this.setClassName(t, className + '1');
            }
        }
    }

    public String getFirstProblemDisplayName() {
        Map.Entry<Table, Set<Problem>> firstProblemEntry = this.getFirstProblemEntry();
        if (firstProblemEntry == null) {
            return null;
        }
        return this.getProblemDisplayNameForTable(firstProblemEntry.getKey(), firstProblemEntry.getValue());
    }

    private Map.Entry<Table, Set<Problem>> getFirstProblemEntry() {
        Set<Map.Entry<Table, Set<Problem>>> problemEntries = this.table2Problems.entrySet();
        if (problemEntries.isEmpty()) {
            return null;
        }
        return problemEntries.iterator().next();
    }

    private String getProblemDisplayNameForTable(Table table, Set<Problem> problems) {
        Problem problem = problems.iterator().next();
        return SelectedTables.getProblemDisplayName(problem, this.getClassName(table));
    }

    String getProblemDisplayNameForTable(Table table) {
        Set<Problem> problems = this.table2Problems.get(table);
        return problems != null ? this.getProblemDisplayNameForTable(table, problems) : null;
    }

    boolean hasProblem(Table table) {
        return this.table2Problems.containsKey(table);
    }

    Problem getFirstProblem() {
        Map.Entry<Table, Set<Problem>> firstProblemEntry = this.getFirstProblemEntry();
        if (firstProblemEntry == null) {
            return null;
        }
        Set<Problem> problems = firstProblemEntry.getValue();
        return problems.iterator().next();
    }

    private static String getProblemDisplayName(Problem problem, String className) {
        switch (problem) {
            case NO_JAVA_IDENTIFIER: {
                return NbBundle.getMessage(SelectedTables.class, (String)"ERR_NoJavaIdentifier", (Object)className);
            }
            case JPA_QL_IDENTIFIER: {
                return NbBundle.getMessage(SelectedTables.class, (String)"ERR_ReservedQLKeyword", (Object)className);
            }
            case ALREADY_EXISTS: {
                return NbBundle.getMessage(SelectedTables.class, (String)"ERR_AlreadyExists", (Object)className);
            }
        }
        assert (false) : (Object)((Object)problem) + " should be handled in getProblemDisplayName()";
        return null;
    }

    private final class TableClosureListener
    implements ChangeListener {
        private TableClosureListener() {
        }

        public void stateChanged(ChangeEvent event) {
            SelectedTables.this.validateTables();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Problem {
        NO_JAVA_IDENTIFIER,
        JPA_QL_IDENTIFIER,
        ALREADY_EXISTS;

    }
}

