/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.fromdb;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.ChangeSupport;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.PersistenceGenerator;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.RelatedCMPHelper;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.RelatedCMPWizard;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.SelectedTables;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.SourceGroupSupport;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.SourceGroupUISupport;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableClosure;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableSource;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableUISupport;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanel;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class EntityClassesPanel
extends JPanel {
    private JTextComponent packageComboBoxEditor;
    private PersistenceGenerator persistenceGen;
    private Project project;
    private boolean cmp;
    private String tableSourceName;
    private SelectedTables selectedTables;
    private ChangeSupport changeSupport = new ChangeSupport(this);
    private PersistenceUnit persistenceUnit;
    private JLabel classNamesLabel;
    private JScrollPane classNamesScrollPane;
    private JTable classNamesTable;
    private JCheckBox cmpFieldsInInterfaceCheckBox;
    private JButton createPUButton;
    private JLabel createPUWarningLabel;
    private JCheckBox generateFinderMethodsCheckBox;
    private JComboBox locationComboBox;
    private JLabel locationLabel;
    private JComboBox packageComboBox;
    private JLabel packageLabel;
    private JLabel projectLabel;
    private JTextField projectTextField;
    private JPanel spacerPanel;
    private JLabel specifyNamesLabel;

    public EntityClassesPanel() {
        this.initComponents();
        this.classNamesTable.getParent().setBackground(this.classNamesTable.getBackground());
        this.classNamesTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.packageComboBoxEditor = (JTextComponent)this.packageComboBox.getEditor().getEditorComponent();
        Document packageComboBoxDocument = this.packageComboBoxEditor.getDocument();
        packageComboBoxDocument.addDocumentListener(new DocumentListener(){

            public void removeUpdate(DocumentEvent e) {
                EntityClassesPanel.this.packageChanged();
            }

            public void insertUpdate(DocumentEvent e) {
                EntityClassesPanel.this.packageChanged();
            }

            public void changedUpdate(DocumentEvent e) {
                EntityClassesPanel.this.packageChanged();
            }
        });
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void initialize(PersistenceGenerator persistenceGen, Project project, boolean cmp, FileObject targetFolder) {
        SourceGroup targetSourceGroup;
        this.persistenceGen = persistenceGen;
        this.project = project;
        this.cmp = cmp;
        this.projectTextField.setText(ProjectUtils.getInformation((Project)project).getDisplayName());
        SourceGroup[] sourceGroups = SourceGroupSupport.getJavaSourceGroups(project);
        SourceGroupUISupport.connect(this.locationComboBox, sourceGroups);
        this.packageComboBox.setRenderer(PackageView.listRenderer());
        this.updatePackageComboBox();
        if (targetFolder != null && (targetSourceGroup = SourceGroupSupport.getFolderSourceGroup(sourceGroups, targetFolder)) != null) {
            this.locationComboBox.setSelectedItem(targetSourceGroup);
            String targetPackage = SourceGroupSupport.getPackageForFolder(targetSourceGroup, targetFolder);
            if (targetPackage != null) {
                this.packageComboBoxEditor.setText(targetPackage);
            }
        }
        if (!cmp) {
            Mnemonics.setLocalizedText((AbstractButton)this.generateFinderMethodsCheckBox, (String)NbBundle.getMessage(EntityClassesPanel.class, (String)"TXT_GenerateNamedQueryAnnotations"));
            this.cmpFieldsInInterfaceCheckBox.setVisible(false);
        }
        if (cmp) {
            this.classNamesLabel.setVisible(false);
            this.classNamesScrollPane.setVisible(false);
            this.spacerPanel.setVisible(false);
            Mnemonics.setLocalizedText((JLabel)this.specifyNamesLabel, (String)NbBundle.getMessage(EntityClassesPanel.class, (String)"LBL_SpecifyBeansLocation"));
        }
        this.updatePersistenceUnitButton();
    }

    public void update(TableClosure tableClosure, String tableSourceName) {
        try {
            if (this.selectedTables == null) {
                this.selectedTables = new SelectedTables(this.persistenceGen, tableClosure, this.getLocationValue(), this.getPackageName());
                this.selectedTables.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent event) {
                        EntityClassesPanel.this.changeSupport.fireChange();
                    }
                });
            } else {
                this.selectedTables.setTableClosureAndTargetFolder(tableClosure, this.getLocationValue(), this.getPackageName());
            }
            this.selectedTables.ensureUniqueClassNames();
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        TableUISupport.connectClassNames(this.classNamesTable, this.selectedTables);
        this.tableSourceName = tableSourceName;
    }

    public SelectedTables getSelectedTables() {
        return this.selectedTables;
    }

    public SourceGroup getLocationValue() {
        return (SourceGroup)this.locationComboBox.getSelectedItem();
    }

    public String getPackageName() {
        return this.packageComboBoxEditor.getText();
    }

    public boolean getCmpFieldsInInterface() {
        return this.cmpFieldsInInterfaceCheckBox.isSelected();
    }

    public boolean getGenerateFinderMethods() {
        return this.generateFinderMethodsCheckBox.isSelected();
    }

    public PersistenceUnit getPersistenceUnit() {
        return this.persistenceUnit;
    }

    private void locationChanged() {
        this.updatePackageComboBox();
        this.updateSelectedTables();
        this.changeSupport.fireChange();
    }

    private void packageChanged() {
        this.updateSelectedTables();
        this.changeSupport.fireChange();
    }

    private void updatePackageComboBox() {
        SourceGroup sourceGroup = (SourceGroup)this.locationComboBox.getSelectedItem();
        if (sourceGroup != null) {
            ComboBoxModel model = PackageView.createListView((SourceGroup)sourceGroup);
            if (model.getSelectedItem() != null && model.getSelectedItem().toString().startsWith("META-INF") && model.getSize() > 1) {
                model.setSelectedItem(model.getElementAt(1));
            }
            this.packageComboBox.setModel(model);
        }
    }

    private void updatePersistenceUnitButton() {
        boolean showWarning = !this.cmp && !ProviderUtil.persistenceExists(this.project) && this.getPersistenceUnit() == null;
        this.createPUButton.setVisible(showWarning);
        String warning = " ";
        if (showWarning) {
            warning = NbBundle.getMessage(EntityClassesPanel.class, (String)"ERR_NoPersistenceUnit");
        }
        this.createPUWarningLabel.setText(warning);
        this.createPUWarningLabel.setToolTipText(warning);
    }

    private void updateSelectedTables() {
        if (this.selectedTables != null) {
            try {
                this.selectedTables.setTargetFolder(this.getLocationValue(), this.getPackageName());
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    public void doLayout() {
        Dimension size = this.createPUWarningLabel.getPreferredSize();
        size.width = this.getWidth();
        this.createPUWarningLabel.setPreferredSize(size);
        super.doLayout();
    }

    private void initComponents() {
        this.specifyNamesLabel = new JLabel();
        this.classNamesLabel = new JLabel();
        this.classNamesScrollPane = new JScrollPane();
        this.classNamesTable = new JTable();
        this.projectLabel = new JLabel();
        this.projectTextField = new JTextField();
        this.locationLabel = new JLabel();
        this.locationComboBox = new JComboBox();
        this.packageLabel = new JLabel();
        this.packageComboBox = new JComboBox();
        this.createPUButton = new JButton();
        this.generateFinderMethodsCheckBox = new JCheckBox();
        this.cmpFieldsInInterfaceCheckBox = new JCheckBox();
        this.spacerPanel = new JPanel();
        this.createPUWarningLabel = new JLabel();
        this.setName(NbBundle.getMessage(EntityClassesPanel.class, (String)"LBL_EntityClasses"));
        Mnemonics.setLocalizedText((JLabel)this.specifyNamesLabel, (String)NbBundle.getMessage(EntityClassesPanel.class, (String)"LBL_SpecifyEntityClassNames"));
        Mnemonics.setLocalizedText((JLabel)this.classNamesLabel, (String)NbBundle.getMessage(EntityClassesPanel.class, (String)"LBL_ClassNames"));
        this.classNamesScrollPane.setViewportView(this.classNamesTable);
        Mnemonics.setLocalizedText((JLabel)this.projectLabel, (String)NbBundle.getMessage(EntityClassesPanel.class, (String)"LBL_Project"));
        this.projectTextField.setEditable(false);
        Mnemonics.setLocalizedText((JLabel)this.locationLabel, (String)NbBundle.getMessage(EntityClassesPanel.class, (String)"LBL_SrcLocation"));
        this.locationComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EntityClassesPanel.this.locationComboBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.packageLabel, (String)NbBundle.getMessage(EntityClassesPanel.class, (String)"LBL_Package"));
        this.packageComboBox.setEditable(true);
        Mnemonics.setLocalizedText((AbstractButton)this.createPUButton, (String)NbBundle.getMessage(EntityClassesPanel.class, (String)"LBL_CreatePersistenceUnit"));
        this.createPUButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EntityClassesPanel.this.createPUButtonActionPerformed(evt);
            }
        });
        this.generateFinderMethodsCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.generateFinderMethodsCheckBox, (String)NbBundle.getMessage(EntityClassesPanel.class, (String)"TXT_GenerateFinderMethods"));
        this.generateFinderMethodsCheckBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.generateFinderMethodsCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.cmpFieldsInInterfaceCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cmpFieldsInInterfaceCheckBox, (String)NbBundle.getMessage(EntityClassesPanel.class, (String)"TXT_AddFieldsToInterface"));
        this.cmpFieldsInInterfaceCheckBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.cmpFieldsInInterfaceCheckBox.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout spacerPanelLayout = new GroupLayout((Container)this.spacerPanel);
        this.spacerPanel.setLayout((LayoutManager)spacerPanelLayout);
        spacerPanelLayout.setHorizontalGroup((GroupLayout.Group)spacerPanelLayout.createParallelGroup(1).add(0, 388, Short.MAX_VALUE));
        spacerPanelLayout.setVerticalGroup((GroupLayout.Group)spacerPanelLayout.createParallelGroup(1).add(0, 9, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((JLabel)this.createPUWarningLabel, (String)" ");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.specifyNamesLabel).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.classNamesLabel).add((Component)this.projectLabel).add((Component)this.locationLabel).add((Component)this.packageLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.spacerPanel, -1, -1, Short.MAX_VALUE).add((Component)this.packageComboBox, 0, 388, Short.MAX_VALUE).add((Component)this.locationComboBox, 0, 388, Short.MAX_VALUE).add(2, (Component)this.projectTextField, -1, 388, Short.MAX_VALUE).add((Component)this.classNamesScrollPane, -1, 388, Short.MAX_VALUE))).add((Component)this.cmpFieldsInInterfaceCheckBox).add((Component)this.generateFinderMethodsCheckBox).add((Component)this.createPUButton).add((Component)this.createPUWarningLabel, -1, 388, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.specifyNamesLabel).add(11, 11, 11).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.classNamesLabel).add((Component)this.classNamesScrollPane, -1, 81, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.spacerPanel, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.projectTextField, -2, -1, -2).add((Component)this.projectLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.locationComboBox, -2, -1, -2).add((Component)this.locationLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.packageComboBox, -2, -1, -2).add((Component)this.packageLabel)).add(21, 21, 21).add((Component)this.generateFinderMethodsCheckBox).addPreferredGap(0).add((Component)this.cmpFieldsInInterfaceCheckBox).add(21, 21, 21).add((Component)this.createPUWarningLabel).addPreferredGap(0).add((Component)this.createPUButton)));
    }

    private void locationComboBoxActionPerformed(ActionEvent evt) {
        this.locationChanged();
    }

    private void createPUButtonActionPerformed(ActionEvent evt) {
        this.persistenceUnit = Util.buildPersistenceUnitUsingWizard(this.project, this.tableSourceName, PersistenceUnitWizardPanel.TableGeneration.NONE);
        if (this.persistenceUnit != null) {
            this.updatePersistenceUnitButton();
            this.changeSupport.fireChange();
        }
    }

    public static final class WizardPanel
    implements WizardDescriptor.Panel,
    ChangeListener {
        private EntityClassesPanel component;
        private boolean componentInitialized;
        private WizardDescriptor wizardDescriptor;
        private Project project;
        private boolean cmp;
        private ChangeSupport changeSupport = new ChangeSupport(this);

        public Component getComponent() {
            return this.getTypedComponent();
        }

        private EntityClassesPanel getTypedComponent() {
            if (this.component == null) {
                this.component = new EntityClassesPanel();
                this.component.addChangeListener(this);
            }
            return this.component;
        }

        public void removeChangeListener(ChangeListener listener) {
            this.changeSupport.removeChangeListener(listener);
        }

        public void addChangeListener(ChangeListener listener) {
            this.changeSupport.addChangeListener(listener);
        }

        public HelpCtx getHelp() {
            if (this.cmp) {
                return new HelpCtx("org.netbeans.modules.j2ee.ejbcore.ejb.wizard.cmp." + EntityClassesPanel.class.getSimpleName());
            }
            return new HelpCtx(EntityClassesPanel.class);
        }

        public void readSettings(Object settings) {
            TableSource.Type tableSourceType;
            this.wizardDescriptor = (WizardDescriptor)settings;
            RelatedCMPHelper helper = RelatedCMPWizard.getHelper(this.wizardDescriptor);
            if (!this.componentInitialized) {
                this.componentInitialized = true;
                PersistenceGenerator persistenceGen = helper.getPersistenceGenerator();
                this.project = Templates.getProject((WizardDescriptor)this.wizardDescriptor);
                this.cmp = RelatedCMPWizard.isCMP(this.wizardDescriptor);
                FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)this.wizardDescriptor);
                this.getTypedComponent().initialize(persistenceGen, this.project, this.cmp, targetFolder);
            }
            TableSource tableSource = helper.getTableSource();
            String tableSourceName = null;
            if (tableSource != null && ((tableSourceType = tableSource.getType()) == TableSource.Type.DATA_SOURCE || tableSourceType == TableSource.Type.CONNECTION)) {
                tableSourceName = tableSource.getName();
            }
            this.getTypedComponent().update(helper.getTableClosure(), tableSourceName);
        }

        public boolean isValid() {
            String problem;
            SourceGroup sourceGroup = this.getTypedComponent().getLocationValue();
            if (sourceGroup == null) {
                this.setErrorMessage(NbBundle.getMessage(EntityClassesPanel.class, (String)"ERR_JavaTargetChooser_SelectSourceGroup"));
                return false;
            }
            String packageName = this.getTypedComponent().getPackageName();
            if (packageName.trim().equals("")) {
                this.setErrorMessage(NbBundle.getMessage(EntityClassesPanel.class, (String)"ERR_JavaTargetChooser_CantUseDefaultPackage"));
                return false;
            }
            if (!SourceGroupSupport.isValidPackageName(packageName)) {
                this.setErrorMessage(NbBundle.getMessage(EntityClassesPanel.class, (String)"ERR_JavaTargetChooser_InvalidPackage"));
                return false;
            }
            if (!SourceGroupSupport.isFolderWritable(sourceGroup, packageName)) {
                this.setErrorMessage(NbBundle.getMessage(EntityClassesPanel.class, (String)"ERR_JavaTargetChooser_UnwritablePackage"));
                return false;
            }
            SelectedTables selectedTables = this.getTypedComponent().getSelectedTables();
            if (selectedTables != null && (problem = selectedTables.getFirstProblemDisplayName()) != null) {
                this.setErrorMessage(problem);
                return false;
            }
            this.setErrorMessage(" ");
            return true;
        }

        public void storeSettings(Object settings) {
            Object buttonPressed = ((WizardDescriptor)settings).getValue();
            if (buttonPressed.equals(WizardDescriptor.NEXT_OPTION) || buttonPressed.equals(WizardDescriptor.FINISH_OPTION)) {
                RelatedCMPHelper helper = RelatedCMPWizard.getHelper(this.wizardDescriptor);
                helper.setSelectedTables(this.getTypedComponent().getSelectedTables());
                helper.setLocation(this.getTypedComponent().getLocationValue());
                helper.setPackageName(this.getTypedComponent().getPackageName());
                helper.setCmpFieldsInInterface(this.getTypedComponent().getCmpFieldsInInterface());
                helper.setGenerateFinderMethods(this.getTypedComponent().getGenerateFinderMethods());
                helper.setPersistenceUnit(this.getTypedComponent().getPersistenceUnit());
            }
        }

        public void stateChanged(ChangeEvent event) {
            this.changeSupport.fireChange(event);
        }

        private void setErrorMessage(String errorMessage) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)errorMessage);
        }
    }
}

