/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.provider;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Provider {
    public static final String TABLE_GENERATION_CREATE = "tableGenerationCreate";
    public static final String TABLE_GENERATION_DROPCREATE = "tableGenerationDropCreate";
    public static final String TABLE_GENERATTION_UNKOWN = "tableGenerationUnknown";
    private final String providerClass;
    private final Set vendorSpecificProperties;

    protected Provider(String providerClass) {
        assert (null != providerClass && !"".equals(providerClass.trim())) : "Provider class must be given!";
        this.providerClass = providerClass;
        this.vendorSpecificProperties = this.initPropertyNames();
    }

    public abstract String getDisplayName();

    public final String getProviderClass() {
        return this.providerClass;
    }

    private Set initPropertyNames() {
        HashSet<String> result = new HashSet<String>();
        result.add(this.getJdbcDriver());
        result.add(this.getJdbcUsername());
        result.add(this.getJdbcUrl());
        result.add(this.getJdbcPassword());
        result.add(this.getTableGenerationPropertyName());
        for (String propertyName : this.getUnresolvedVendorSpecificProperties().keySet()) {
            result.add(propertyName);
        }
        return result;
    }

    public Set getPropertyNames() {
        return this.vendorSpecificProperties;
    }

    public final Property getTableGenerationProperty(String strategy) {
        if ("".equals(this.getTableGenerationPropertyName())) {
            return null;
        }
        Property result = new Property();
        result.setName(this.getTableGenerationPropertyName());
        if (TABLE_GENERATION_CREATE.equals(strategy)) {
            result.setValue(this.getTableGenerationCreateValue());
        } else if (TABLE_GENERATION_DROPCREATE.equals(strategy)) {
            result.setValue(this.getTableGenerationDropCreateValue());
        } else {
            return null;
        }
        return result;
    }

    public final String getDefaultJtaDatasource() {
        return "jdbc/__default";
    }

    public abstract String getJdbcUrl();

    public abstract String getJdbcDriver();

    public abstract String getJdbcUsername();

    public abstract String getJdbcPassword();

    public abstract String getTableGenerationPropertyName();

    public abstract String getTableGenerationCreateValue();

    public abstract String getTableGenerationDropCreateValue();

    public abstract Map getUnresolvedVendorSpecificProperties();

    public abstract Map getDefaultVendorSpecificProperties();

    public final Map<String, String> getConnectionPropertiesMap(DatabaseConnection connection) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(this.getJdbcDriver(), connection != null ? connection.getDriverClass() : "");
        result.put(this.getJdbcUrl(), connection != null ? connection.getDatabaseURL() : "");
        result.put(this.getJdbcUsername(), connection != null ? connection.getUser() : "");
        result.put(this.getJdbcPassword(), connection != null && connection.getPassword() != null ? connection.getPassword() : "");
        return result;
    }

    public final boolean supportsTableGeneration() {
        return this.getTableGenerationPropertyName() != null && !"".equals(this.getTableGenerationPropertyName().trim());
    }

    public String toString() {
        return this.getDisplayName();
    }

    public int hashCode() {
        return this.providerClass.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Provider)) {
            return false;
        }
        Provider that = (Provider)obj;
        return this.getClass().equals(that.getClass()) && this.providerClass.equals(that.providerClass);
    }
}

