/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.editor.completion.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.modules.dbschema.DBException;
import org.netbeans.modules.dbschema.DBIdentifier;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.jdbcimpl.ConnectionProvider;
import org.netbeans.modules.dbschema.jdbcimpl.SchemaElementImpl;
import org.netbeans.modules.j2ee.persistence.editor.completion.db.Catalog;
import org.netbeans.modules.j2ee.persistence.editor.completion.db.DBMetaDataProvider;
import org.openide.ErrorManager;

public class Schema {
    private DBMetaDataProvider provider;
    private Catalog catalog;
    private String name;
    private Set tableNames;
    private ConnectionProvider cp;
    private SchemaElementImpl schemaElementImpl;
    private SchemaElement schemaElement;

    Schema(DBMetaDataProvider provider, Catalog catalog, String name) {
        this.provider = provider;
        this.catalog = catalog;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public synchronized String[] getTableNames() throws SQLException {
        if (this.tableNames == null) {
            this.tableNames = this.getTableNamesByType("TABLE");
        }
        return this.tableNames.toArray(new String[this.tableNames.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableElement getTable(String tableName) throws SQLException {
        DBIdentifier tableId;
        TableElement tableElement;
        SchemaElement schemaElement;
        Schema schema = this;
        synchronized (schema) {
            schemaElement = this.schemaElement;
        }
        if (schemaElement == null) {
            this.cp = new ConnectionProvider(this.provider.getConnection(), this.provider.getDriverClass());
            this.cp.setSchema(this.name);
            this.schemaElementImpl = new SchemaElementImpl(this.cp);
            try {
                this.schemaElementImpl.setName(DBIdentifier.create((String)"foo"));
            }
            catch (DBException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            schemaElement = new SchemaElement((SchemaElement.Impl)this.schemaElementImpl);
            Schema e = this;
            synchronized (e) {
                this.schemaElement = schemaElement;
            }
        }
        if ((tableElement = schemaElement.getTable(tableId = DBIdentifier.create((String)tableName))) == null) {
            LinkedList<String> tableList = new LinkedList<String>();
            tableList.add(tableName);
            LinkedList viewList = new LinkedList();
            this.schemaElementImpl.initTables(this.cp, tableList, viewList, false);
            tableElement = schemaElement.getTable(tableId);
        }
        return tableElement;
    }

    public synchronized void refresh() {
        this.schemaElement = null;
        this.tableNames = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getTableNamesByType(String type) throws SQLException {
        TreeSet<String> result = new TreeSet<String>();
        ResultSet rs = this.provider.getMetaData().getTables(this.catalog.getName(), this.name, "%", new String[]{type});
        try {
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                result.add(tableName);
            }
        }
        finally {
            rs.close();
        }
        return result;
    }

    public String toString() {
        return "Schema[catalog=" + this.catalog + ",name='" + this.name + "']";
    }
}

