/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.editor.completion.db;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.api.explorer.MetaDataListener;
import org.netbeans.modules.j2ee.persistence.editor.completion.db.Catalog;
import org.netbeans.modules.j2ee.persistence.editor.completion.db.Schema;
import org.openide.ErrorManager;

public class DBMetaDataProvider {
    private static final Map CONN_TO_PROVIDER = new WeakHashMap();
    private final Reference conn;
    private final String driverClass;
    private Map catalogs;

    public static synchronized DBMetaDataProvider get(Connection conn, String driverClass) {
        assert (conn != null);
        DBMetaDataProvider provider = (DBMetaDataProvider)CONN_TO_PROVIDER.get(conn);
        if (provider == null) {
            provider = new DBMetaDataProvider(conn, driverClass);
            CONN_TO_PROVIDER.put(conn, provider);
        }
        return provider;
    }

    public static MetaDataListener createMetaDataListener() {
        return new MetaDataListenerImpl();
    }

    public DBMetaDataProvider(Connection conn, String driverClass) {
        this.conn = new WeakReference<Connection>(conn);
        this.driverClass = driverClass;
    }

    public String getDefaultCatalog() throws SQLException {
        return this.getConnection().getCatalog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Catalog[] getCatalogs() throws SQLException {
        if (this.catalogs == null) {
            this.catalogs = new TreeMap(new CatalogComparator());
            ResultSet rs = this.getMetaData().getCatalogs();
            try {
                while (rs.next()) {
                    String catalogName = rs.getString("TABLE_CAT");
                    Catalog catalog = new Catalog(this, catalogName);
                    this.catalogs.put(catalogName, catalog);
                }
            }
            finally {
                rs.close();
            }
            if (this.catalogs.size() <= 0) {
                Catalog defaultCatalog = new Catalog(this, null);
                this.catalogs.put(null, defaultCatalog);
            }
        }
        return this.catalogs.values().toArray(new Catalog[this.catalogs.size()]);
    }

    public synchronized Catalog getCatalog(String name) throws SQLException {
        if (this.catalogs == null) {
            this.getCatalogs();
        }
        return (Catalog)this.catalogs.get(name);
    }

    Connection getConnection() {
        return (Connection)this.conn.get();
    }

    String getDriverClass() {
        return this.driverClass;
    }

    DatabaseMetaData getMetaData() throws SQLException {
        return this.getConnection().getMetaData();
    }

    public String toString() {
        return "DBMetadataProvider[conn=" + this.getConnection() + "]";
    }

    private static final class MetaDataListenerImpl
    implements MetaDataListener {
        public void tablesChanged(DatabaseConnection dbconn) {
            try {
                Schema schema = this.getSchema(dbconn);
                if (schema != null) {
                    schema.refresh();
                }
            }
            catch (SQLException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }

        public void tableChanged(DatabaseConnection dbconn, String tableName) {
            this.tablesChanged(dbconn);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Schema getSchema(DatabaseConnection dbconn) throws SQLException {
            DBMetaDataProvider provider;
            Connection conn = dbconn.getJDBCConnection();
            if (conn == null) {
                return null;
            }
            MetaDataListenerImpl metaDataListenerImpl = this;
            synchronized (metaDataListenerImpl) {
                provider = (DBMetaDataProvider)CONN_TO_PROVIDER.get(conn);
            }
            if (provider == null) {
                return null;
            }
            Catalog catalog = provider.getCatalog(conn.getCatalog());
            if (catalog == null) {
                return null;
            }
            return catalog.getSchema(dbconn.getSchema());
        }
    }

    private static final class CatalogComparator
    implements Comparator {
        private CatalogComparator() {
        }

        public boolean equals(Object that) {
            return that instanceof CatalogComparator;
        }

        public int compare(Object o1, Object o2) {
            String name1 = (String)o1;
            String name2 = (String)o2;
            if (name1 == null) {
                return name2 == null ? 0 : -1;
            }
            return name2 == null ? 1 : name1.compareTo(name2);
        }
    }
}

