/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.dd.orm;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.j2ee.metadata.NNModelBuilder;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.Entity;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.EntityMappings;
import org.netbeans.modules.schema2beans.BaseBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORMNNListener
extends NNModelBuilder {
    private Map<String, String> nn2modelMapping;
    private EntityMappings entityMappings;
    private ClassPath cp;
    private static final Collection<String> primaryAnnotations = Arrays.asList("javax.persistence.Entity", "javax.persistence.MappedSuperclass", "javax.persistence.Embeddable");

    public ORMNNListener(EntityMappings nnEntityMappings, ClassPath cp) {
        super((BaseBean)nnEntityMappings);
        this.entityMappings = nnEntityMappings;
        this.cp = cp;
        this.initNN2ModelMapping();
    }

    public ClassPath getClassPath() {
        return this.cp;
    }

    public Map<String, String> getAnnotation2ModelMapping() {
        return this.nn2modelMapping;
    }

    public void classRemoved(String fqn) {
        Entity entityToRemove = this.findEntityForClass(fqn);
        this.entityMappings.removeEntity(entityToRemove);
    }

    public Collection<String> getPrimaryAnnotations() {
        return primaryAnnotations;
    }

    private void initNN2ModelMapping() {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> imaps = new HashMap<String, String>();
        imaps.put("javax.persistence.Table", "/Table");
        imaps.put("javax.persistence.SecondaryTable", "/SecondaryTable");
        HashMap<String, String> imapsGeneric = new HashMap<String, String>();
        imapsGeneric.put("javax.persistence.OneToOne", "/Attributes/OneToOne#Name=$MEMBER");
        imapsGeneric.put("javax.persistence.OneToMany", "/Attributes/OneToMany#Name=$MEMBER");
        imapsGeneric.put("javax.persistence.ManyToMany", "/Attributes/ManyToMany#Name=$MEMBER");
        imapsGeneric.put("javax.persistence.ManyToOne", "/Attributes/ManyToOne#Name=$MEMBER");
        imapsGeneric.put("javax.persistence.Id", "/Attributes/Id#Name=$MEMBER");
        imapsGeneric.put("javax.persistence.EmbeddedId", "/Attributes/EmbeddedId#Name=$MEMBER");
        imapsGeneric.put("javax.persistence.Transient", "/Attributes/Transient#Name=$MEMBER");
        imapsGeneric.put("javax.persistence.IdClass", "/IdClass#!value=class2");
        String ENTITY_MAPPING = "Entity#Class2=$JAVACLASS";
        map.put("javax.persistence.Entity", ENTITY_MAPPING);
        this.generateItemsMappings(ENTITY_MAPPING, ENTITY_MAPPING, map, imaps);
        this.generateItemsMappings(ENTITY_MAPPING, ENTITY_MAPPING, map, imapsGeneric);
        String MS_MAPPING = "MappedSuperclass#Class2=$JAVACLASS";
        map.put("javax.persistence.MappedSuperclass", MS_MAPPING);
        this.generateItemsMappings(MS_MAPPING, MS_MAPPING, map, imapsGeneric);
        String EMBEDABLE_MAPPING = "Embeddable#Class2=$JAVACLASS";
        map.put("javax.persistence.Embeddable", EMBEDABLE_MAPPING);
        this.generateItemsMappings(EMBEDABLE_MAPPING, EMBEDABLE_MAPPING, map, imaps);
        this.generateItemsMappings(EMBEDABLE_MAPPING, EMBEDABLE_MAPPING, map, imapsGeneric);
        this.nn2modelMapping = Collections.unmodifiableMap(map);
    }

    private void generateItemsMappings(String condition, String mappingPrefix, Map<String, String> mappings, Map<String, String> items) {
        for (String key : items.keySet()) {
            String value = items.get(key);
            mappings.put(key + "?" + condition, mappingPrefix + value);
        }
    }

    private void dumpMappings() {
        System.out.println("ORM NN model builder mappings:\n==============================\n");
        for (String key : this.getAnnotation2ModelMapping().keySet()) {
            String val = this.getAnnotation2ModelMapping().get(key);
            System.out.println(key + " -> " + val);
        }
    }

    private Entity findEntityForClass(String fqn) {
        if (fqn != null) {
            Entity[] entities = this.entityMappings.getEntity();
            for (int i = 0; i < entities.length; ++i) {
                if (!fqn.equals(entities[i].getClass2())) continue;
                return entities[i];
            }
        }
        return null;
    }
}

