/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.multiview;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.core.spi.multiview.CloseOperationHandler;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.netbeans.modules.xml.multiview.DesignMultiViewDesc;
import org.netbeans.modules.xml.multiview.Utils;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataSynchronizer;
import org.netbeans.modules.xml.multiview.XmlMultiViewElement;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.UndoRedo;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class XmlMultiViewEditorSupport
extends DataEditorSupport
implements Serializable,
EditCookie,
OpenCookie,
EditorCookie.Observable,
PrintCookie {
    private XmlMultiViewDataObject dObj;
    private DocumentListener docListener;
    private int xmlMultiViewIndex;
    private TopComponent mvtc;
    private int lastOpenView = 0;
    private TopComponentsListener topComponentsListener;
    private MultiViewDescription[] multiViewDescriptions;
    private DocumentSynchronizer documentSynchronizer;
    private int loading = 0;
    private FileLock saveLock;
    private static final String PROPERTY_MODIFICATION_LISTENER = "modificationListener";
    private boolean suppressXmlView = false;
    static /* synthetic */ Class class$org$openide$text$CloneableEditorSupport;

    public XmlMultiViewEditorSupport() {
        super(null, null);
    }

    public XmlMultiViewEditorSupport(XmlMultiViewDataObject dObj) {
        super((DataObject)dObj, (CloneableEditorSupport.Env)new XmlEnv(dObj));
        this.dObj = dObj;
        this.documentSynchronizer = new DocumentSynchronizer(dObj);
        this.setMIMEType("text/xml");
        this.docListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                this.doUpdate();
            }

            public void insertUpdate(DocumentEvent e) {
                this.doUpdate();
            }

            public void removeUpdate(DocumentEvent e) {
                this.doUpdate();
            }

            private void doUpdate() {
                if (XmlMultiViewEditorSupport.this.saveLock == null) {
                    XmlMultiViewEditorSupport.this.documentSynchronizer.requestUpdateData();
                }
            }
        };
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                StyledDocument document;
                if ("document".equals(evt.getPropertyName()) && (document = XmlMultiViewEditorSupport.this.getDocument()) != null) {
                    document.addDocumentListener(XmlMultiViewEditorSupport.this.docListener);
                }
            }
        });
    }

    UndoRedo getUndoRedo0() {
        return super.getUndoRedo();
    }

    public XmlEnv getXmlEnv() {
        return (XmlEnv)this.env;
    }

    protected CloneableEditor createCloneableEditor() {
        return super.createCloneableEditor();
    }

    public InputStream getInputStream() throws IOException {
        return super.getInputStream();
    }

    protected Task reloadDocument() {
        FileLock reloadLock;
        ++this.loading;
        this.documentSynchronizer.reloadingStarted();
        try {
            reloadLock = this.dObj.waitForLock();
            this.dObj.getDataCache().loadData(this.dObj.getPrimaryFile(), reloadLock);
        }
        catch (IOException e) {
            reloadLock = null;
            ErrorManager.getDefault().notify((Throwable)e);
        }
        final Task reloadDocumentTask = XmlMultiViewEditorSupport.super.reloadDocument();
        final FileLock lock = reloadLock;
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    if (!reloadDocumentTask.isFinished()) {
                        reloadDocumentTask.waitFinished(5000L);
                    }
                }
                catch (InterruptedException e) {
                    ErrorManager.getDefault().annotate((Throwable)e, NbBundle.getMessage((Class)(class$org$netbeans$modules$xml$multiview$XmlMultiViewEditorSupport == null ? (class$org$netbeans$modules$xml$multiview$XmlMultiViewEditorSupport = XmlMultiViewEditorSupport.class$("org.netbeans.modules.xml.multiview.XmlMultiViewEditorSupport")) : class$org$netbeans$modules$xml$multiview$XmlMultiViewEditorSupport), (String)"CANNOT_UPDATE_LOCKED_DATA_OBJECT"));
                }
                finally {
                    if (lock != null) {
                        lock.releaseLock();
                    }
                    XmlMultiViewEditorSupport.this.documentSynchronizer.reloadingFinished();
                    XmlMultiViewEditorSupport.this.loading--;
                }
            }
        });
        return reloadDocumentTask;
    }

    protected void loadFromStreamToKit(StyledDocument doc, InputStream stream, EditorKit kit) throws IOException, BadLocationException {
        kit.read(new InputStreamReader(stream, this.dObj.getEncodingHelper().getEncoding()), (Document)doc, 0);
    }

    protected void saveFromKitToStream(StyledDocument doc, EditorKit kit, OutputStream stream) throws IOException, BadLocationException {
        kit.write(new OutputStreamWriter(stream, this.dObj.getEncodingHelper().getEncoding()), (Document)doc, 0, doc.getLength());
    }

    public StyledDocument openDocument() throws IOException {
        this.dObj.getDataCache().getStringData();
        return super.openDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDocument() throws IOException {
        if (this.loading > 0) {
            return;
        }
        FileLock dataLock = ((XmlMultiViewDataObject)this.getDataObject()).waitForLock();
        try {
            ((XmlMultiViewDataObject)this.getDataObject()).getDataCache().saveData(dataLock);
        }
        finally {
            dataLock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveDocument(FileLock dataLock) throws IOException {
        if (this.saveLock != dataLock) {
            this.saveLock = dataLock;
            this.documentSynchronizer.reloadModel();
            try {
                this.doSaveDocument();
                this.dObj.getDataCache().resetFileTime();
            }
            finally {
                this.saveLock = null;
            }
        }
    }

    private void doSaveDocument() throws IOException {
        final StyledDocument doc = this.getDocument();
        String enc = EncodingUtil.detectEncoding((Document)doc);
        if (enc == null) {
            enc = "UTF8";
        }
        try {
            new OutputStreamWriter((OutputStream)new ByteArrayOutputStream(1), enc);
            if (!this.checkCharsetConversion(enc)) {
                return;
            }
            super.saveDocument();
            this.getDataObject().setModified(false);
        }
        catch (UnsupportedEncodingException ex) {
            String message = NbBundle.getMessage((Class)XmlMultiViewEditorSupport.class, (String)"TEXT_SAVE_AS_UTF", (Object)enc);
            NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)message);
            Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
            if (res.equals(NotifyDescriptor.YES_OPTION)) {
                try {
                    int MAX_PROLOG = 1000;
                    int maxPrologLen = Math.min(1000, doc.getLength());
                    final char[] prolog = doc.getText(0, maxPrologLen).toCharArray();
                    int prologLen = 0;
                    if (prolog[0] == '<' && prolog[1] == '?' && prolog[2] == 'x') {
                        for (int i = 3; i < maxPrologLen; ++i) {
                            if (prolog[i] != '?' || prolog[i + 1] != '>') continue;
                            prologLen = i + 1;
                            break;
                        }
                    }
                    final int passPrologLen = prologLen;
                    Runnable edit = new Runnable(){

                        public void run() {
                            block2: {
                                try {
                                    doc.remove(0, passPrologLen + 1);
                                    doc.insertString(0, "<?xml version='1.0' encoding='UTF-8' ?> \n<!-- was: " + new String(prolog, 0, passPrologLen + 1) + " -->", null);
                                }
                                catch (BadLocationException e) {
                                    if (System.getProperty("netbeans.debug.exceptions") == null) break block2;
                                    e.printStackTrace();
                                }
                            }
                        }
                    };
                    NbDocument.runAtomic((StyledDocument)doc, (Runnable)edit);
                    super.saveDocument();
                    this.getDataObject().setModified(false);
                    ((XmlMultiViewDataObject)this.getDataObject()).getDataCache().reloadData();
                }
                catch (BadLocationException lex) {
                    ErrorManager.getDefault().notify((Throwable)lex);
                }
            }
            return;
        }
    }

    private boolean checkCharsetConversion(String encoding) {
        boolean value = true;
        try {
            CharsetEncoder coder = Charset.forName(encoding).newEncoder();
            if (!coder.canEncode(this.getDocument().getText(0, this.getDocument().getLength()))) {
                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage((Class)XmlMultiViewEditorSupport.class, (String)"MSG_BadCharConversion", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), encoding}), 0, 2);
                nd.setValue(NotifyDescriptor.NO_OPTION);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                if (nd.getValue() != NotifyDescriptor.YES_OPTION) {
                    value = false;
                }
            }
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return value;
    }

    protected CloneableTopComponent createCloneableTopComponent() {
        MultiViewDescription[] descs = this.getMultiViewDescriptions();
        CloneableTopComponent mvtc = MultiViewFactory.createCloneableMultiView((MultiViewDescription[])descs, (MultiViewDescription)descs[0], (CloseOperationHandler)new MyCloseHandler(this.dObj));
        Mode editorMode = WindowManager.getDefault().findMode("editor");
        if (editorMode != null) {
            editorMode.dockInto((TopComponent)mvtc);
        }
        this.mvtc = mvtc;
        return mvtc;
    }

    public MultiViewDescription[] getMultiViewDescriptions() {
        if (this.multiViewDescriptions == null) {
            if (this.suppressXmlView) {
                this.multiViewDescriptions = this.dObj.getMultiViewDesc();
                this.xmlMultiViewIndex = 0;
            } else {
                DesignMultiViewDesc[] customDesc = this.dObj.getMultiViewDesc();
                XmlViewDesc xmlDesc = new XmlViewDesc(this.dObj);
                this.multiViewDescriptions = new MultiViewDescription[customDesc.length + 1];
                System.arraycopy(customDesc, 0, this.multiViewDescriptions, 0, customDesc.length);
                this.multiViewDescriptions[customDesc.length] = xmlDesc;
                this.xmlMultiViewIndex = customDesc.length;
            }
        }
        return this.multiViewDescriptions;
    }

    public void setSuppressXmlView(boolean suppressXmlView) {
        this.suppressXmlView = suppressXmlView;
        this.multiViewDescriptions = null;
    }

    public void edit() {
        this.openView(-1);
    }

    void openView(final int index) {
        Utils.runInAwtDispatchThread(new Runnable(){

            public void run() {
                CloneableTopComponent mvtc = XmlMultiViewEditorSupport.this.openCloneableTopComponent();
                MultiViewHandler handler = MultiViews.findMultiViewHandler((TopComponent)mvtc);
                handler.requestVisible(handler.getPerspectives()[index < 0 ? XmlMultiViewEditorSupport.this.xmlMultiViewIndex : index]);
                mvtc.requestActive();
            }
        });
        try {
            this.openDocument();
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    public void open() {
        this.openView(this.lastOpenView);
    }

    void goToXmlPerspective() {
        Utils.runInAwtDispatchThread(new Runnable(){

            public void run() {
                MultiViewHandler handler = MultiViews.findMultiViewHandler((TopComponent)XmlMultiViewEditorSupport.this.mvtc);
                handler.requestVisible(handler.getPerspectives()[XmlMultiViewEditorSupport.this.xmlMultiViewIndex]);
            }
        });
    }

    protected void notifyClosed() {
        StyledDocument document;
        this.mvtc = null;
        if (this.topComponentsListener != null) {
            TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this.topComponentsListener);
            this.topComponentsListener = null;
        }
        if ((document = this.getDocument()) != null) {
            document.removeDocumentListener(this.docListener);
        }
        super.notifyClosed();
    }

    MultiViewPerspective getSelectedPerspective() {
        if (this.mvtc != null) {
            return MultiViews.findMultiViewHandler((TopComponent)this.mvtc).getSelectedPerspective();
        }
        return null;
    }

    public void updateDisplayName() {
        if (this.mvtc != null) {
            Utils.runInAwtDispatchThread(new Runnable(){

                public void run() {
                    String displayName = XmlMultiViewEditorSupport.this.messageName();
                    if (!displayName.equals(XmlMultiViewEditorSupport.this.mvtc.getDisplayName())) {
                        XmlMultiViewEditorSupport.this.mvtc.setDisplayName(displayName);
                    }
                    XmlMultiViewEditorSupport.this.mvtc.setToolTipText(FileUtil.getFileDisplayName((FileObject)XmlMultiViewEditorSupport.this.dObj.getPrimaryFile()));
                }
            });
        }
    }

    public TopComponent getMVTC() {
        return this.mvtc;
    }

    void setMVTC(TopComponent mvtc) {
        this.mvtc = mvtc;
        if (this.topComponentsListener == null) {
            this.topComponentsListener = new TopComponentsListener();
            TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this.topComponentsListener);
        }
    }

    void setLastOpenView(int index) {
        this.lastOpenView = index;
    }

    protected String messageName() {
        return super.messageName();
    }

    private class TopComponentsListener
    implements PropertyChangeListener {
        private TopComponentsListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("opened".equals(evt.getPropertyName())) {
                Set closed = (Set)evt.getOldValue();
                closed.removeAll((Set)evt.getNewValue());
                Iterator iterator = closed.iterator();
                while (iterator.hasNext()) {
                    Object o = iterator.next();
                    if (!(o instanceof CloneableTopComponent)) continue;
                    CloneableTopComponent topComponent = (CloneableTopComponent)o;
                    Enumeration en = topComponent.getReference().getComponents();
                    if (XmlMultiViewEditorSupport.this.mvtc != topComponent) continue;
                    if (en.hasMoreElements()) {
                        XmlMultiViewEditorSupport.this.mvtc = (TopComponent)((CloneableTopComponent)en.nextElement());
                        continue;
                    }
                    XmlMultiViewEditorSupport.this.notifyClosed();
                }
            }
        }
    }

    static class MyCloseHandler
    implements CloseOperationHandler,
    Serializable {
        static final long serialVersionUID = -6512103928294991474L;
        private XmlMultiViewDataObject dObj;

        MyCloseHandler() {
        }

        MyCloseHandler(XmlMultiViewDataObject dObj) {
            this.dObj = dObj;
        }

        public boolean resolveCloseOperation(CloseOperationState[] elements) {
            for (int i = 0; i < elements.length; ++i) {
                CloseOperationState element = elements[i];
                if (!"Flush Data".equals(element.getCloseWarningID())) continue;
                return false;
            }
            if (this.dObj.isModified()) {
                XmlMultiViewEditorSupport support = this.dObj.getEditorSupport();
                String msg = support.messageSave();
                ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$openide$text$CloneableEditorSupport == null ? (class$org$openide$text$CloneableEditorSupport = XmlMultiViewEditorSupport.class$("org.openide.text.CloneableEditorSupport")) : class$org$openide$text$CloneableEditorSupport));
                JButton saveOption = new JButton(bundle.getString("CTL_Save"));
                saveOption.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_Save"));
                saveOption.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_CTL_Save"));
                JButton discardOption = new JButton(bundle.getString("CTL_Discard"));
                discardOption.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_Discard"));
                discardOption.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_CTL_Discard"));
                discardOption.setMnemonic(bundle.getString("CTL_Discard_Mnemonic").charAt(0));
                NotifyDescriptor nd = new NotifyDescriptor((Object)msg, bundle.getString("LBL_SaveFile_Title"), 1, 3, new Object[]{saveOption, discardOption, NotifyDescriptor.CANCEL_OPTION}, (Object)saveOption);
                Object ret = DialogDisplayer.getDefault().notify(nd);
                if (NotifyDescriptor.CANCEL_OPTION.equals(ret) || NotifyDescriptor.CLOSED_OPTION.equals(ret)) {
                    return false;
                }
                if (saveOption.equals(ret)) {
                    try {
                        if (!this.dObj.acceptEncoding()) {
                            return false;
                        }
                        support.saveDocument();
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                        return false;
                    }
                } else if (discardOption.equals(ret)) {
                    this.dObj.getEditorSupport().reloadDocument().waitFinished();
                    support.notifyClosed();
                }
            }
            return true;
        }
    }

    private class DocumentSynchronizer
    extends XmlMultiViewDataSynchronizer {
        private final RequestProcessor.Task reloadUpdatedTask;

        public DocumentSynchronizer(XmlMultiViewDataObject dataObject) {
            super(dataObject, 100);
            this.reloadUpdatedTask = this.requestProcessor.create(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    DocumentListener listener;
                    StyledDocument document = XmlMultiViewEditorSupport.this.getDocument();
                    DocumentListener documentListener = listener = document == null ? null : (DocumentListener)document.getProperty(XmlMultiViewEditorSupport.PROPERTY_MODIFICATION_LISTENER);
                    if (listener != null) {
                        document.removeDocumentListener(listener);
                    }
                    try {
                        DocumentSynchronizer.this.reloadModel();
                    }
                    finally {
                        if (listener != null) {
                            document.addDocumentListener(listener);
                        }
                    }
                }
            });
            XmlMultiViewEditorSupport.this.getXmlEnv().addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    String propertyName = evt.getPropertyName();
                    if ("time".equals(propertyName) && XmlMultiViewEditorSupport.this.getDocument() == null) {
                        XmlMultiViewEditorSupport.this.dObj.getDataCache().loadData();
                    }
                }
            });
        }

        protected boolean mayUpdateData(boolean allowDialog) {
            return true;
        }

        protected void dataUpdated(long timeStamp) {
            if (XmlMultiViewEditorSupport.this.loading == 0) {
                this.reloadUpdatedTask.schedule(0);
            }
        }

        protected Object getModel() {
            return XmlMultiViewEditorSupport.this.getDocument();
        }

        protected void updateDataFromModel(Object model, final FileLock lock, final boolean modify) {
            final Document doc = (Document)model;
            if (doc == null) {
                try {
                    XmlMultiViewEditorSupport.this.dObj.getDataCache().setData(lock, "", modify);
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            } else {
                doc.render(new Runnable(){

                    public void run() {
                        try {
                            XmlMultiViewEditorSupport.this.dObj.getDataCache().setData(lock, doc.getText(0, doc.getLength()), modify);
                        }
                        catch (BadLocationException e) {
                        }
                        catch (IOException e) {
                            ErrorManager.getDefault().notify((Throwable)e);
                        }
                    }
                });
            }
        }

        protected void reloadModelFromData() {
            if (XmlMultiViewEditorSupport.this.loading == 0) {
                Utils.replaceDocument(XmlMultiViewEditorSupport.this.getDocument(), XmlMultiViewEditorSupport.this.dObj.getDataCache().getStringData());
            }
        }
    }

    private static class XmlViewDesc
    implements MultiViewDescription,
    Serializable {
        private static final long serialVersionUID = 8085725367398466167L;
        XmlMultiViewDataObject dObj;

        XmlViewDesc() {
        }

        XmlViewDesc(XmlMultiViewDataObject dObj) {
            this.dObj = dObj;
        }

        public MultiViewElement createElement() {
            return new XmlMultiViewElement(this.dObj);
        }

        public String getDisplayName() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$xml$multiview$XmlMultiViewEditorSupport == null ? (class$org$netbeans$modules$xml$multiview$XmlMultiViewEditorSupport = XmlMultiViewEditorSupport.class$("org.netbeans.modules.xml.multiview.XmlMultiViewEditorSupport")) : class$org$netbeans$modules$xml$multiview$XmlMultiViewEditorSupport), (String)"LBL_XML_TAB");
        }

        public HelpCtx getHelpCtx() {
            return this.dObj.getHelpCtx();
        }

        public Image getIcon() {
            return this.dObj.getXmlViewIcon();
        }

        public int getPersistenceType() {
            return 1;
        }

        public String preferredID() {
            return "multiview_xml";
        }
    }

    public static class XmlEnv
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = 2882981960507292985L;
        private final XmlMultiViewDataObject xmlMultiViewDataObject;

        public XmlEnv(XmlMultiViewDataObject obj) {
            super((DataObject)obj);
            this.xmlMultiViewDataObject = obj;
            this.changeFile();
        }

        protected FileObject getFile() {
            return this.xmlMultiViewDataObject.getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return this.xmlMultiViewDataObject.getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return this.xmlMultiViewDataObject.getEditorSupport();
        }

        public InputStream inputStream() throws IOException {
            return this.xmlMultiViewDataObject.getDataCache().createInputStream();
        }

        protected OutputStream getFileOutputStream() throws IOException {
            return super.outputStream();
        }

        public OutputStream outputStream() throws IOException {
            if (this.xmlMultiViewDataObject.getEditorSupport().saveLock != null) {
                return super.outputStream();
            }
            return this.xmlMultiViewDataObject.getDataCache().createOutputStream();
        }

        public boolean isModified() {
            return super.isModified();
        }
    }
}

