/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.multiview;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import org.netbeans.modules.xml.multiview.Refreshable;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataSynchronizer;

public abstract class ItemOptionHelper
implements ActionListener,
Refreshable {
    private final AbstractButton[] buttons;
    private final AbstractButton unmatchedOption;
    private XmlMultiViewDataSynchronizer synchronizer;

    public ItemOptionHelper(XmlMultiViewDataSynchronizer synchronizer, ButtonGroup group) {
        this.synchronizer = synchronizer;
        this.buttons = Collections.list(group.getElements()).toArray(new AbstractButton[0]);
        AbstractButton unmatchedOption = null;
        for (int i = 0; i < this.buttons.length; ++i) {
            AbstractButton button = this.buttons[i];
            button.addActionListener(this);
            if (this.getOptionText(button) != null) continue;
            unmatchedOption = button;
        }
        this.unmatchedOption = unmatchedOption;
        this.setOption(this.getItemValue());
    }

    public final void actionPerformed(ActionEvent e) {
        String option = this.getOption();
        if (!option.equals(this.getItemValue())) {
            this.setItemValue(this.getOption());
            this.synchronizer.requestUpdateData();
        }
    }

    public void setOption(String itemValue) {
        AbstractButton matchingButton = this.getMatchingButton(itemValue);
        if (matchingButton != null && !matchingButton.isSelected()) {
            matchingButton.setSelected(true);
        }
    }

    private AbstractButton getMatchingButton(String itemValue) {
        AbstractButton matchingButton = null;
        for (int i = 0; i < this.buttons.length; ++i) {
            AbstractButton button = this.buttons[i];
            if (!this.getOptionText(button).equals(itemValue)) continue;
            matchingButton = button;
            break;
        }
        if (matchingButton == null && this.unmatchedOption != null) {
            matchingButton = this.unmatchedOption;
        }
        return matchingButton;
    }

    private String getOptionText(AbstractButton button) {
        String fixedValue = (String)button.getClientProperty("prop_fixed_value");
        if (fixedValue != null) {
            return fixedValue;
        }
        return button.getText();
    }

    public String getOption() {
        for (int i = 0; i < this.buttons.length; ++i) {
            AbstractButton button = this.buttons[i];
            if (!button.isSelected()) continue;
            return this.getOptionText(button);
        }
        return null;
    }

    public abstract String getItemValue();

    public abstract void setItemValue(String var1);

    public void refresh() {
        this.setOption(this.getItemValue());
    }
}

