/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaee.blueprints.components.ui.rss;

import com.sun.javaee.blueprints.components.ui.util.HttpClient;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.shale.remoting.faces.ResponseFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RssFeedHandler {
    private static boolean rDebug = false;
    private Logger logger = null;
    private String proxyHost = null;
    private String proxyPort = null;
    private String urlString = "https://blueprints.dev.java.net/servlets/ProjectRSS?type=news";
    private String style = "json";
    private String itemCount = "0";
    private String contentType = "text/plain;charset=utf-8";
    private byte[] resultBuffer = null;
    private static ResponseFactory factory = new ResponseFactory();

    public RssFeedHandler() {
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        this.proxyHost = context.getExternalContext().getInitParameter("proxyHost");
        this.proxyPort = context.getExternalContext().getInitParameter("proxyPort");
        if (this.proxyHost == null || this.proxyHost.equals("")) {
            this.proxyHost = null;
        }
        if (this.proxyPort == null || this.proxyPort.equals("")) {
            this.proxyPort = null;
        }
    }

    private void log(String message) {
        if (rDebug & this.logger != null) {
            this.logger.log(Level.INFO, message);
        }
    }

    public void getRssfeed() {
        FacesContext context = FacesContext.getCurrentInstance();
        ExpressionFactory exF = context.getApplication().getExpressionFactory();
        ValueExpression ve = exF.createValueExpression(context.getELContext(), "#{param.url}", String.class);
        this.urlString = (String)ve.getValue(context.getELContext());
        if (this.urlString == null) {
            this.urlString = "https://blueprints.dev.java.net/servlets/ProjectRSS?type=news";
        }
        ve = exF.createValueExpression(context.getELContext(), "#{param.style}", String.class);
        this.style = (String)ve.getValue(context.getELContext());
        if (this.style == null) {
            this.style = "json";
        }
        ve = exF.createValueExpression(context.getELContext(), "#{param.itemCount}", String.class);
        this.itemCount = (String)ve.getValue(context.getELContext());
        if (this.itemCount == null) {
            this.itemCount = "0";
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (this.style != null) {
            paramMap.put("style", this.style);
        }
        if (this.itemCount != null) {
            paramMap.put("number", this.itemCount);
        }
        if (this.resultBuffer == null) {
            this.resultBuffer = this.setResultBuffer(paramMap);
        }
        try {
            ResponseStream stream = factory.getResponseStream(context, this.contentType);
            WritableByteChannel channel = Channels.newChannel((OutputStream)stream);
            ByteBuffer buf = ByteBuffer.wrap(this.resultBuffer);
            channel.write(buf);
            channel.close();
        }
        catch (Exception e) {
            this.log("WARNING channel terminated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] setResultBuffer(Map<String, String> paramMap) {
        Object ct;
        ByteArrayOutputStream baOs = new ByteArrayOutputStream();
        InputStream xslIS = this.getClass().getResourceAsStream("/META-INF/rss/rss.xsl");
        if (xslIS == null) {
            this.log("xslis is null");
        } else {
            this.log("xslis is OK");
        }
        InputStream xmlIS = null;
        HttpClient httpclient = new HttpClient(this.proxyHost, this.proxyPort, this.urlString);
        xmlIS = httpclient.getInputStream();
        String ce = httpclient.getContentEncoding();
        if (ce == null) {
            int idx;
            ct = httpclient.getContentType();
            ce = ct != null ? ((idx = ((String)ct).lastIndexOf("charset=")) >= 0 ? ((String)ct).substring(idx + 8) : "iso-8859-1") : "iso-8859-1";
        }
        try {
            this.contentType = this.style.equals("json") ? "text/plain;charset=" + ce : "text/xml;charset=" + ce;
            this.transform(xmlIS, xslIS, paramMap, baOs, ce);
            ct = baOs.toByteArray();
            return ct;
        }
        catch (Exception e) {
            this.log("WARNING RssFeedHanderl transformation error");
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (xslIS != null) {
                    xslIS.close();
                }
                if (xmlIS != null) {
                    xmlIS.close();
                }
            }
            catch (Exception e) {
                this.log("RssFeedHandler Stream IO Error");
                return null;
            }
        }
    }

    public void transform(InputStream xmlIS, InputStream xslIS, Map<String, String> param, OutputStream result, String encoding) {
        try {
            TransformerFactory trFac = TransformerFactory.newInstance();
            Transformer transformer = trFac.newTransformer(new StreamSource(xslIS));
            for (String key : param.keySet()) {
                transformer.setParameter(key, param.get(key));
            }
            transformer.setOutputProperty("encoding", encoding);
            transformer.transform(new StreamSource(xmlIS), new StreamResult(result));
        }
        catch (Exception e) {
            this.log("Exception in RssHandler xslt");
        }
    }

    public String getUrl() {
        return this.urlString;
    }

    public void setUrl(String str) {
        this.urlString = str;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getItemCount() {
        return this.itemCount;
    }

    public void setItemCount(String itemnum) {
        this.itemCount = itemnum;
    }
}

