/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaee.blueprints.components.ui.rss;

import com.sun.javaee.blueprints.components.ui.rss.RssBarComponent;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.apache.shale.remoting.Mechanism;
import org.apache.shale.remoting.XhtmlHelper;

public class RssBarRenderer
extends Renderer {
    private static final String RENDERED_SCRIPT_KEY = "bpcatalog-ajax-script-rssbar";
    private static final String DOJO_SCRIPT_RESOURCE = "/META-INF/dojo/v0_3/dojo.js";
    private static final String RSS_SCRIPT_RESOURCE = "/META-INF/rss/rssbar.js";
    private static final String COMMON_SCRIPT_RESOURCE = "/META-INF/common/script.js";
    private static final String RSSBAR_CSS_RESOURCE = "/META-INF/rss/rssbar.css";
    private static final String RSS_BKBOTTOMIAGE_RESOURCE = "/META-INF/rss/rssBarBG.jpg";
    private static final String RSS_BKTOPIAGE_RESOURCE = "/META-INF/rss/rssBarAG.jpg";
    private String url = null;
    private String itemCount = null;
    private String backgroundImage = null;
    private String color = null;
    private String fontSize = null;
    private String hoverColor = null;
    private String speed = null;
    private String title = null;
    private static XhtmlHelper helper = new XhtmlHelper();

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        RssBarComponent rssComp = (RssBarComponent)component;
        this.url = (String)rssComp.getAttributes().get("url");
        this.itemCount = (String)rssComp.getAttributes().get("itemCount");
        this.backgroundImage = (String)rssComp.getAttributes().get("backgroundImage");
        this.color = (String)rssComp.getAttributes().get("color");
        this.fontSize = (String)rssComp.getAttributes().get("fontSize");
        this.hoverColor = (String)rssComp.getAttributes().get("hoverColor");
        this.speed = (String)rssComp.getAttributes().get("speed");
        this.title = (String)rssComp.getAttributes().get("title");
        ResponseWriter writer = context.getResponseWriter();
        this.renderScriptOnce(writer, component, context);
        writer.startElement("style", component);
        writer.writeAttribute("type", (Object)"text/css", null);
        if (this.backgroundImage != null && this.backgroundImage.equals("default")) {
            writer.write("\n");
            String imgPath = helper.mapResourceId(context, Mechanism.CLASS_RESOURCE, RSS_BKBOTTOMIAGE_RESOURCE);
            writer.write("#rss-bar table {background-image: url(" + imgPath + "); }");
            writer.write("\n");
            imgPath = helper.mapResourceId(context, Mechanism.CLASS_RESOURCE, RSS_BKTOPIAGE_RESOURCE);
            writer.write("#rss-bar table td#rss-channel {background-image: url(" + imgPath + ");}");
            writer.write("\n");
            writer.write("#rss-bar table td#rss-item {background-image: url(" + imgPath + ");}");
        }
        if (this.color != null) {
            writer.write("\n");
            writer.write("#rss-bar table a { color: " + this.color + ";}");
        }
        if (this.hoverColor != null) {
            writer.write("\n");
            writer.write("#rss-bar table a:hover { color: " + this.hoverColor + ";}");
        }
        if (this.fontSize != null) {
            writer.write("\n");
            writer.write("#rss-bar table td#rss-channel { font-size: " + this.fontSize + ";}");
            writer.write("\n");
            writer.write("#rss-bar table td#rss-item { font-size: " + this.fontSize + ";}");
        }
        writer.write("\n");
        writer.endElement("style");
        writer.write("\n");
        writer.startElement("div", component);
        writer.writeAttribute("id", (Object)"rss-bar", null);
        writer.write("\n");
        writer.startElement("table", component);
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.write("\n");
        writer.startElement("tr", component);
        writer.write("\n");
        writer.startElement("td", component);
        writer.writeAttribute("id", (Object)"rss-channel", null);
        writer.endElement("td");
        writer.write("\n");
        writer.startElement("td", component);
        writer.writeAttribute("id", (Object)"rss-item", null);
        writer.endElement("td");
        writer.write("\n");
        writer.endElement("tr");
        writer.write("\n");
        writer.endElement("table");
        writer.write("\n");
        writer.endElement("div");
        writer.write("\n");
        String rssbarMethod = helper.mapResourceId(context, Mechanism.DYNAMIC_RESOURCE, "/bpui_rssfeedhandler/getRssfeed");
        writer.startElement("script", component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("\n");
        writer.write("var rss = new bpui.RSS();\n");
        writer.write("dojo.addOnLoad(function(){rss.getRssInJson('" + rssbarMethod + "', '" + this.url + "', '" + this.itemCount + "'");
        if (this.speed != null & !this.speed.equals("")) {
            writer.write(", '" + this.speed + "'");
        }
        if (this.title != null & !this.title.equals("")) {
            writer.write(", '" + this.title + "'");
        }
        writer.write(");});");
        writer.write("\n");
        writer.endElement("script");
        writer.write("\n");
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
    }

    private void renderScriptOnce(ResponseWriter writer, UIComponent component, FacesContext context) throws IOException {
        Map requestMap = context.getExternalContext().getRequestMap();
        Boolean scriptRendered = (Boolean)requestMap.get(RENDERED_SCRIPT_KEY);
        if (scriptRendered == Boolean.TRUE) {
            return;
        }
        requestMap.put(RENDERED_SCRIPT_KEY, Boolean.TRUE);
        writer.write("\n");
        helper.linkJavascript(context, component, writer, Mechanism.CLASS_RESOURCE, COMMON_SCRIPT_RESOURCE);
        writer.startElement("script", component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("\n");
        writer.write("if (typeof dojo == 'undefined') {\n");
        writer.write("    bpui.load(\"" + helper.mapResourceId(context, Mechanism.CLASS_RESOURCE, DOJO_SCRIPT_RESOURCE) + "\");\n");
        writer.write("}\n");
        writer.endElement("script");
        writer.write("\n");
        helper.linkJavascript(context, component, writer, Mechanism.CLASS_RESOURCE, RSS_SCRIPT_RESOURCE);
        helper.linkStylesheet(context, component, writer, Mechanism.CLASS_RESOURCE, RSSBAR_CSS_RESOURCE);
    }
}

