/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaee.blueprints.components.ui.popup;

import com.sun.javaee.blueprints.components.ui.popup.PopupUtil;
import com.sun.javaee.blueprints.components.ui.util.Util;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.apache.shale.remoting.Mechanism;
import org.apache.shale.remoting.XhtmlHelper;

public class PopupRenderer
extends Renderer {
    private boolean bDebug = false;
    private static final String RENDERED_SCRIPT_KEY = "bpcatalog-ajax-script-popup";
    private static final String DOJO_SCRIPT_RESOURCE = "/META-INF/dojo/v0_3/dojo.js";
    private static final String POPUP_SCRIPT_RESOURCE = "/META-INF/popup/popup.js";
    private static final String POPUP_CSS_RESOURCE = "/META-INF/popup/popup.css";
    private static final String COMMON_SCRIPT_RESOURCE = "/META-INF/common/script.js";
    private static final String POPUP_TOP_TEMPLATE = "/META-INF/popup/PopupTemplateTop.txt";
    private static final String POPUP_BOTTOM_TEMPLATE = "/META-INF/popup/PopupTemplateBottom.txt";
    private static final String SINGLE_QUOTE = "'";
    private static final String COMMA = ",";
    private static XhtmlHelper helper = new XhtmlHelper();

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        String display;
        String height;
        String width;
        String color;
        String retFunction;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        UIOutput outComp = (UIOutput)component;
        ResponseWriter writer = context.getResponseWriter();
        this.renderScriptOnce(writer, component, context);
        String id = (String)outComp.getAttributes().get("id");
        String xmlHttpRequestURL = (String)Util.getAttributeValue(context, component, "xmlHttpRequestURL");
        String elementNamePairs = (String)Util.getAttributeValue(context, component, "elementNamePairs");
        if (elementNamePairs == null) {
            elementNamePairs = "";
        }
        if ((retFunction = (String)Util.getAttributeValue(context, component, "retFunction")) == null) {
            retFunction = "";
        }
        if ((color = (String)Util.getAttributeValue(context, component, "color")) == null) {
            color = "blue";
        }
        if ((width = (String)Util.getAttributeValue(context, component, "width")) == null) {
            width = "300";
        }
        if ((height = (String)Util.getAttributeValue(context, component, "height")) == null) {
            height = "300";
        }
        display = (display = (String)Util.getAttributeValue(context, component, "display")) == null ? "before" : display.toLowerCase();
        String delay = (String)Util.getAttributeValue(context, component, "delay");
        if (delay == null) {
            delay = "1000";
        }
        if (this.bDebug) {
            System.out.println("Renderer Data - " + id + " - " + xmlHttpRequestURL + " - " + elementNamePairs);
        }
        URL sxURL = PopupRenderer.class.getResource(POPUP_TOP_TEMPLATE);
        if (this.bDebug) {
            System.out.println("\n *** URL of resource = /META-INF/popup/PopupTemplateTop.txt - " + sxURL);
        }
        String sxTemplate = PopupUtil.readInFragmentAsString(sxURL);
        String imagePrefix = helper.mapResourceId(context, Mechanism.DYNAMIC_RESOURCE, "");
        imagePrefix = imagePrefix.substring(0, imagePrefix.lastIndexOf("/") + 1) + "static";
        if (this.bDebug) {
            System.out.println("\n *** images prefix = " + imagePrefix);
        }
        StringBuffer sxReturnNames = new StringBuffer();
        StringBuffer sxTableIds = new StringBuffer();
        String docKey = "";
        String tableId = "";
        StringTokenizer st = new StringTokenizer(elementNamePairs, COMMA);
        int iPos = 0;
        int cnt = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            iPos = token.indexOf("=");
            if (iPos >= 0) {
                tableId = token.substring(iPos + 1);
                docKey = token.substring(0, iPos);
            } else {
                tableId = token;
                docKey = token;
            }
            if (cnt > 0) {
                sxReturnNames.append(COMMA);
            }
            sxReturnNames.append(SINGLE_QUOTE);
            sxReturnNames.append(docKey);
            sxReturnNames.append(SINGLE_QUOTE);
            if (cnt > 0) {
                sxTableIds.append(COMMA);
            }
            sxTableIds.append(SINGLE_QUOTE);
            sxTableIds.append(tableId);
            sxTableIds.append(SINGLE_QUOTE);
            ++cnt;
        }
        HashMap<String, String> hmSub = new HashMap<String, String>();
        hmSub.put("%%%ID%%%", id);
        hmSub.put("%%%REQUESTURL%%%", xmlHttpRequestURL);
        hmSub.put("%%%FACESCONTEXTROOT%%%", imagePrefix);
        hmSub.put("%%%DOMRETURNNAMES%%%", sxReturnNames.toString());
        hmSub.put("%%%TABLEIDS%%%", sxTableIds.toString());
        hmSub.put("%%%RETFUNCTION%%%", retFunction);
        hmSub.put("%%%COLOR%%%", color);
        hmSub.put("%%%POPUPSIZE%%%", width);
        hmSub.put("%%%DISPLAY%%%", display);
        hmSub.put("%%%DELAY%%%", delay);
        hmSub.put("%%%POPUPHEIGHT%%%", height);
        writer.write(PopupUtil.parseString(sxTemplate, hmSub, false));
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String width;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        UIOutput outComp = (UIOutput)component;
        URL sxURL = PopupRenderer.class.getResource(POPUP_BOTTOM_TEMPLATE);
        String sxTemplate = PopupUtil.readInFragmentAsString(sxURL);
        ResponseWriter writer = context.getResponseWriter();
        String id = (String)outComp.getAttributes().get("id");
        String color = (String)Util.getAttributeValue(context, component, "color");
        if (color == null) {
            color = "blue";
        }
        if ((width = (String)Util.getAttributeValue(context, component, "width")) == null) {
            width = "300";
        }
        String imagePrefix = helper.mapResourceId(context, Mechanism.DYNAMIC_RESOURCE, "");
        imagePrefix = imagePrefix.substring(0, imagePrefix.lastIndexOf("/") + 1) + "static";
        if (this.bDebug) {
            System.out.println("\n *** images prefix = " + imagePrefix);
        }
        HashMap<String, String> hmSub = new HashMap<String, String>();
        hmSub.put("%%%ID%%%", id);
        hmSub.put("%%%FACESCONTEXTROOT%%%", imagePrefix);
        hmSub.put("%%%COLOR%%%", color);
        hmSub.put("%%%POPUPSIZE%%%", width);
        writer.write(PopupUtil.parseString(sxTemplate, hmSub, false));
    }

    private void renderScriptOnce(ResponseWriter writer, UIComponent component, FacesContext context) throws IOException {
        Map requestMap = context.getExternalContext().getRequestMap();
        Boolean scriptRendered = (Boolean)requestMap.get(RENDERED_SCRIPT_KEY);
        if (scriptRendered != null && scriptRendered.equals(Boolean.TRUE)) {
            return;
        }
        requestMap.put(RENDERED_SCRIPT_KEY, Boolean.TRUE);
        writer.write("\n");
        helper.linkJavascript(context, component, writer, Mechanism.CLASS_RESOURCE, COMMON_SCRIPT_RESOURCE);
        writer.startElement("script", component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("\n");
        writer.write("if (typeof dojo == 'undefined') {\n");
        writer.write("    bpui.load(\"" + helper.mapResourceId(context, Mechanism.CLASS_RESOURCE, DOJO_SCRIPT_RESOURCE) + "\");\n");
        writer.write("}\n");
        writer.endElement("script");
        writer.write("\n");
        helper.linkJavascript(context, component, writer, Mechanism.CLASS_RESOURCE, POPUP_SCRIPT_RESOURCE);
        helper.linkStylesheet(context, component, writer, Mechanism.CLASS_RESOURCE, POPUP_CSS_RESOURCE);
    }
}

